/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.artifacts.reusable.MyPersistentRestartUserData;
import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.Properties;

public class ChunkTests
extends ServiceEETest {
    private static JobOperatorBridge jobOp = null;

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public void cleanup() {
    }

    public void testChunkNoProcessorDefined() throws EETest.Fault {
        String METHOD = "testChunkDefaultItemCount";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=40");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("readrecord.fail", "40");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkNoProcessorDefined.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkNoProcessorDefined", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "buffer size = 10", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkNullCheckpointInfo() throws EETest.Fault {
        String METHOD = "testChunkDefaultItemCount";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: nullChkPtInfo.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("nullChkPtInfo", null);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "checkpointInfo is null in reader.open...checkpointInfo is null in writer.open", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkArtifactInstanceUniqueness() throws EETest.Fault {
        String METHOD = "testChunkDefaultItemCount";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: uniqueInstanceTest.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("uniqueInstanceTest", null);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "nullChunkListenerChunkListenerStepListenerStepListenerJobListenerJobListener", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkOnErrorListener() throws EETest.Fault {
        String METHOD = "testChunkOnErrorListener";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=5");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "5");
            jobParams.put("app.writepoints", "0,10");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkListenerTest.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkListenerTest", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "Chunk onError invoked", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkRestartItemCount7() throws EETest.Fault {
        String METHOD = "testChunkRestartItemCount7";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.chunksize=7");
            TestUtil.logMsg((String)"app.commitinterval=10");
            Properties jobParams = new Properties();
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("app.writepoints", "0,7,14,21,28,30");
            jobParams.put("app.next.writepoints", "7,14,21,28,30");
            TestUtil.logMsg((String)"Locate job XML file: chunkStopOnEndOn.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkStopOnEndOn", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TestUtil.logMsg((String)("Got Job instance id: " + jobInstanceId + ""));
            TestUtil.logMsg((String)("Got Job execution id: " + lastExecutionId + ""));
            TestUtil.logMsg((String)"Create job parameters for execution #2:");
            TestUtil.logMsg((String)"execution.number=2");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.chunksize=7");
            TestUtil.logMsg((String)"app.commitinterval=10");
            Properties restartJobParameters = new Properties();
            restartJobParameters.put("execution.number", "2");
            restartJobParameters.put("app.arraysize", "30");
            jobParams.put("app.checkpoint.position", "7");
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult with executionId: " + lastExecutionId + ""));
            TCKJobExecutionWrapper exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParams);
            lastExecutionId = exec.getExecutionId();
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + exec.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + ""));
            TestUtil.logMsg((String)("execution #2 Job instance id=" + exec.getInstanceId() + ""));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkRestartItemCount10() throws EETest.Fault {
        String METHOD = "testChunkRestartItemCount10";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.next.writepoints=0,5,10,15,20,25,30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("app.writepoints", "0,10,20,30");
            jobParams.put("app.next.writepoints", "10,20,30");
            TestUtil.logMsg((String)"Locate job XML file: chunkrestartCheckpt10.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkrestartCheckpt10", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TestUtil.logMsg((String)("Got Job instance id: " + jobInstanceId + ""));
            TestUtil.logMsg((String)("Got Job execution id: " + lastExecutionId + ""));
            TestUtil.logMsg((String)"Create job parameters for execution #2:");
            Properties restartJobParameters = new Properties();
            TestUtil.logMsg((String)"execution.number=2");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            restartJobParameters.put("execution.number", "2");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.checkpoint.position", "10");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult with execution id: " + lastExecutionId + ""));
            TCKJobExecutionWrapper exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParams);
            lastExecutionId = exec.getExecutionId();
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + exec.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + ""));
            TestUtil.logMsg((String)("execution #2 Job instance id=" + exec.getInstanceId() + ""));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkRestartChunk5() throws EETest.Fault {
        String METHOD = "testChunkRestartChunk5";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,3,6,9,12,15,18,21,24,27,30");
            TestUtil.logMsg((String)"app.next.writepoints=9,12,15,18,21,24,27,30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.next.writepoints", "10,15,20,25,30");
            TestUtil.logMsg((String)"Locate job XML file: chunksize5commitinterval3.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResul for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval3", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TestUtil.logMsg((String)("Got Job instance id: " + jobInstanceId + ""));
            TestUtil.logMsg((String)("Got Job execution id: " + lastExecutionId + ""));
            TestUtil.logMsg((String)"Create job parameters for execution #2:");
            Properties restartJobParameters = new Properties(jobParams);
            TestUtil.logMsg((String)"execution.number=2");
            TestUtil.logMsg((String)"app.arraysize=30");
            restartJobParameters.put("execution.number", "2");
            restartJobParameters.put("app.checkpoint.position", "10");
            restartJobParameters.put("app.arraysize", "30");
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult with execution id: " + lastExecutionId + ""));
            TCKJobExecutionWrapper exec = jobOp.restartJobAndWaitForResult(lastExecutionId, restartJobParameters);
            lastExecutionId = exec.getExecutionId();
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + exec.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + ""));
            TestUtil.logMsg((String)("execution #2 Job instance id=" + exec.getInstanceId() + ""));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkDefaultItemCount() throws EETest.Fault {
        String METHOD = "testChunkDefaultItemCount";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=40");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("readrecord.fail", "40");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunksizeDEFAULTcommitIntervalDEFAULT.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksizeDEFAULTcommitIntervalDEFAULT", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "buffer size = 10", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkRestartCustomCheckpoint() throws EETest.Fault {
        String METHOD = "testChunkRestartCustomCheckpoint";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=2");
            TestUtil.logMsg((String)"readrecord.fail=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,4,9,13,15,20,22,27,30");
            TestUtil.logMsg((String)"app.next.writepoints=9,13,15,20,22,27,30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,4,9,13,15,20,22,27,30");
            jobParams.put("app.next.writepoints", "9,13,15,20,22,27,30");
            TestUtil.logMsg((String)"Locate job XML file: chunkCustomCheckpoint.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkCustomCheckpoint", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TestUtil.logMsg((String)("Got Job instance id: " + jobInstanceId + ""));
            TestUtil.logMsg((String)("Got Job execution id: " + lastExecutionId + ""));
            TestUtil.logMsg((String)"Create job parameters for execution #2:");
            Properties restartJobParameters = new Properties(jobParams);
            TestUtil.logMsg((String)"execution.number=2");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=9,13,15,20,22,27,30");
            restartJobParameters.put("execution.number", "2");
            restartJobParameters.put("app.checkpoint.position", "9");
            restartJobParameters.put("app.arraysize", "30");
            restartJobParameters.put("app.writepoints", "9,13,15,20,22,27,30");
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult with execution id: " + lastExecutionId + ""));
            TCKJobExecutionWrapper exec = jobOp.restartJobAndWaitForResult(lastExecutionId, restartJobParameters);
            lastExecutionId = exec.getExecutionId();
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + exec.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + ""));
            TestUtil.logMsg((String)("execution #2 Job instance id=" + exec.getInstanceId() + ""));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkTimeBasedDefaultCheckpoint() throws EETest.Fault {
        String METHOD = "testChunkTimeBasedDefaultCheckpoint";
        TestUtil.logTrace((String)METHOD);
        String DEFAULT_SLEEP_TIME = "500";
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=31");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.sleeptime", System.getProperty("ChunkTests.testChunkTimeBasedDefaultCheckpoint.sleep", DEFAULT_SLEEP_TIME));
            TestUtil.logMsg((String)"Locate job XML file: chunkTimeBasedDefaultCheckpoint.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkTimeBasedDefaultCheckpoint", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            String exitStatus = execution1.getExitStatus();
            AssertionUtils.assertWithMessage("Testing execution #1", exitStatus.equals("TRUE: 0") || exitStatus.equals("TRUE: 1"));
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkTimeBasedTimeLimit0() throws EETest.Fault {
        String METHOD = "testChunkTimeBasedDefaultCheckpoint";
        TestUtil.logTrace((String)METHOD);
        String DEFAULT_SLEEP_TIME = "500";
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=31");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.sleeptime", System.getProperty("ChunkTests.testChunkTimeBasedTimeLimit0.sleep", DEFAULT_SLEEP_TIME));
            TestUtil.logMsg((String)"Locate job XML file: chunkTimeLimit0.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkTimeLimit0", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            String exitStatus = execution1.getExitStatus();
            AssertionUtils.assertWithMessage("Testing execution #1", exitStatus.equals("TRUE: 0") || exitStatus.equals("TRUE: 1"));
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkTimeBased10Seconds() throws EETest.Fault {
        String METHOD = "testChunkTimeBased10Seconds";
        TestUtil.logTrace((String)METHOD);
        String DEFAULT_SLEEP_TIME = "500";
        try {
            Properties jobParams = new Properties();
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.sleeptime", System.getProperty("ChunkTests.testChunkTimeBased10Seconds.sleep", DEFAULT_SLEEP_TIME));
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkTimeBasedCheckpoint", jobParams);
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            String exitStatus = execution1.getExitStatus();
            AssertionUtils.assertWithMessage("Testing execution #1", exitStatus.equals("TRUE: 9") || exitStatus.equals("TRUE: 10") || exitStatus.equals("TRUE: 11"));
            TestUtil.logMsg((String)("exit status = " + execution1.getExitStatus() + ""));
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkRestartTimeBasedCheckpoint() throws EETest.Fault {
        String METHOD = "testChunkRestartTimeBasedCheckpoint";
        TestUtil.logTrace((String)METHOD);
        String DEFAULT_SLEEP_TIME = "500";
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.sleeptime", System.getProperty("ChunkTests.testChunkRestartTimeBasedCheckpoint.sleep", DEFAULT_SLEEP_TIME));
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkTimeBasedCheckpoint", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FALSE: 0", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TestUtil.logMsg((String)("Got Job instance id: " + jobInstanceId + ""));
            TestUtil.logMsg((String)("Got Job execution id: " + lastExecutionId + ""));
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult with execution id: " + lastExecutionId + ""));
            TCKJobExecutionWrapper exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParams);
            lastExecutionId = exec.getExecutionId();
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + exec.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + ""));
            TestUtil.logMsg((String)("execution #2 Job instance id=" + exec.getInstanceId() + ""));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            String exitStatus = exec.getExitStatus();
            AssertionUtils.assertWithMessage("Testing execution #2", exitStatus.equals("TRUE: 9") || exitStatus.equals("TRUE: 10") || exitStatus.equals("TRUE: 11"));
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkRestartTimeBasedDefaultCheckpoint() throws EETest.Fault {
        String METHOD = "testChunkRestartTimeBasedDefaultCheckpoint";
        TestUtil.logTrace((String)METHOD);
        String DEFAULT_SLEEP_TIME = "500";
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=2");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "2");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.sleeptime", System.getProperty("ChunkTests.testChunkRestartTimeBasedDefaultCheckpoint.sleep", DEFAULT_SLEEP_TIME));
            TestUtil.logMsg((String)"Locate job XML file: chunkTimeBasedDefaultCheckpoint.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkTimeBasedDefaultCheckpoint", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "TRUE: 0", execution1.getExitStatus());
            JobInstance jobInstance = jobOp.getJobInstance(execution1.getExecutionId());
            long jobInstanceId = jobInstance.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TestUtil.logMsg((String)("Got Job instance id: " + jobInstanceId + ""));
            TestUtil.logMsg((String)("Got Job execution id: " + lastExecutionId + ""));
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult with execution id: " + lastExecutionId + ""));
            TCKJobExecutionWrapper exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParams);
            lastExecutionId = exec.getExecutionId();
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + exec.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + ""));
            TestUtil.logMsg((String)("execution #2 Job instance id=" + exec.getInstanceId() + ""));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "TRUE: 0", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkSkipMultipleExceptions() throws EETest.Fault {
        String METHOD = "testChunkSkipRead";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=1,3");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkSkipMultipleExceptions.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipMultipleExceptions", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipReadListener: GOOD STATUS", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkSkipRead() throws EETest.Fault {
        String METHOD = "testChunkSkipRead";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=1,3");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkSkipInitialTest.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipInitialTest", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipReadListener: GOOD STATUS", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkSkipProcess() throws EETest.Fault {
        String METHOD = "testChunkSkipProcess";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"processrecord.fail=7,13");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("processrecord.fail", "7,13");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkSkipInitialTest.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipInitialTest", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipProcessListener: GOOD STATUS, GOOD OBJ PASSED", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkSkipWrite() throws EETest.Fault {
        String METHOD = "testChunkSkipWrite";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"writerecord.fail=1,3");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("writerecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkSkipInitialTest.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipInitialTest", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipWriteListener: GOOD STATUS, GOOD OBJS PASSED IN", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkSkipOnError() throws EETest.Fault {
        String METHOD = "testChunkSkipOnError";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=1,3");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkSkipOnErrorTest.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipOnErrorTest", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyItemReadListenerImpl.onReadError", execution1.getExitStatus());
            jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"processrecord.fail=7,13");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("processrecord.fail", "7,13");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkSkipOnErrorTest.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution2 = jobOp.startJobAndWaitForResult("chunkSkipOnErrorTest", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution2.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution2.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyItemProcessListenerImpl.onProcessError", execution2.getExitStatus());
            jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"writerecord.fail=1,3");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("writerecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkSkipOnErrorTest.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution3 = jobOp.startJobAndWaitForResult("chunkSkipOnErrorTest", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution3.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution3.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution3.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyItemWriteListenerImpl.onWriteError", execution3.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkRetryOnError() throws EETest.Fault {
        String METHOD = "testChunkRetryOnError";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=1,3");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkRetryOnError.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkRetryOnError", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyItemReadListenerImpl.onReadError", execution1.getExitStatus());
            jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"processrecord.fail=7,13");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("processrecord.fail", "7,13");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkRetryOnError.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution2 = jobOp.startJobAndWaitForResult("chunkRetryOnError", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution2.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution2.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyItemProcessListenerImpl.onProcessError", execution2.getExitStatus());
            jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"writerecord.fail=1,3");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("writerecord.fail", "1,3");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkRetryOnError.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution3 = jobOp.startJobAndWaitForResult("chunkRetryOnError", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution3.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution3.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution3.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyItemWriteListenerImpl.onWriteError", execution3.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkSkipReadExceedSkip() throws EETest.Fault {
        String METHOD = "testChunkSkipReadExceedSkip";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"processrecord.fail=1,2");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,2");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkSkipExceededTest.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipExceededTest", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipReadListener: GOOD STATUS", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkSkipProcessExceedSkip() throws EETest.Fault {
        String METHOD = "testChunkSkipProcessExceedSkip";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"processrecord.fail=5,7");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("processrecord.fail", "5,7");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkSkipExceededTest.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipExceededTest", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipProcessListener: GOOD STATUS, GOOD OBJ PASSED", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkSkipWriteExceedSkip() throws EETest.Fault {
        String METHOD = "testChunkSkipWriteExceedSkip";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"writerecord.fail=2,8");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("writerecord.fail", "2,8");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkSkipExceededTest.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipExceededTest", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipWriteListener: GOOD STATUS, GOOD OBJS PASSED IN", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkSkipReadNoSkipChildEx() throws EETest.Fault {
        String METHOD = "testChunkSkipReadNoSkipChildEx";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"writerecord.fail=1,2,3");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,2,3");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkSkipNoSkipChildExTest.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkSkipNoSkipChildExTest", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MySkipReadListener: GOOD STATUS", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkRetryRead() throws EETest.Fault {
        String METHOD = "testChunkRetryRead";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"writerecord.fail=8,13,22");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "8,13,22");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkRetryInitialTest.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkRetryInitialTest", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "COMPLETED", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkRetryMultipleExceptions() throws EETest.Fault {
        String METHOD = "testChunkRetryMultipleExceptions";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=1,3");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,3,5");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: chunkRetryMultipleExceptions.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkRetryMultipleExceptions", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "MyMultipleExceptionsRetryReadListener: GOOD STATUS", execution1.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkItemListeners() throws EETest.Fault {
        String METHOD = "testChunkItemListeners";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=31");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.listenertest=READ");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.listenertest", "READ");
            TestUtil.logMsg((String)"Locate job XML file: testListeners.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testListeners", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1 for the READ LISTENER", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1 for the READ LISTENER", "MyItemReadListenerImpl: GOOD STATUS", execution1.getExitStatus());
            TestUtil.logMsg((String)"Create job parameters for execution #2:");
            jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=31");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.listenertest=PROCESS");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.listenertest", "PROCESS");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #2");
            TCKJobExecutionWrapper execution2 = jobOp.startJobAndWaitForResult("testListeners", jobParams);
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #2 for the PROCESS LISTENER", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2 for the PROCESS LISTENER", "MyItemProcessListenerImpl: GOOD STATUS", execution2.getExitStatus());
            TestUtil.logMsg((String)"Create job parameters for execution #3:");
            jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=31");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.listenertest=WRITE");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.listenertest", "WRITE");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #3");
            TCKJobExecutionWrapper execution3 = jobOp.startJobAndWaitForResult("testListeners", jobParams);
            TestUtil.logMsg((String)("execution #3 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #3 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #3 for the WRITE LISTENER", BatchStatus.COMPLETED, execution3.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #3 for the WRITE LISTENER", "MyItemWriteListener: GOOD STATUS", execution3.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testChunkItemListenersOnError() throws EETest.Fault {
        String METHOD = "testChunkItemListeners";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"read.fail.immediate=true");
            jobParams.put("read.fail.immediate", "true");
            TestUtil.logMsg((String)"Locate job XML file: testListeners.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testListenersOnError", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1 for the READ LISTENER", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1 for the READ LISTENER", "MyItemReadListenerImpl.onReadError", execution1.getExitStatus());
            TestUtil.logMsg((String)"Create job parameters for execution #2:");
            jobParams = new Properties();
            TestUtil.logMsg((String)"process.fail.immediate=true");
            jobParams.put("process.fail.immediate", "true");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #2");
            TCKJobExecutionWrapper execution2 = jobOp.startJobAndWaitForResult("testListenersOnError", jobParams);
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #2 for the PROCESS LISTENER", BatchStatus.FAILED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2 for the PROCESS LISTENER", "MyItemProcessListenerImpl.onProcessError", execution2.getExitStatus());
            TestUtil.logMsg((String)"Create job parameters for execution #3:");
            jobParams = new Properties();
            TestUtil.logMsg((String)"write.fail.immediate=true");
            jobParams.put("write.fail.immediate", "true");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #3");
            TCKJobExecutionWrapper execution3 = jobOp.startJobAndWaitForResult("testListenersOnError", jobParams);
            TestUtil.logMsg((String)("execution #3 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #3 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #3 for the WRITE LISTENER", BatchStatus.FAILED, execution3.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #3 for the WRITE LISTENER", "MyItemWriteListenerImpl.onWriteError", execution3.getExitStatus());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    public void testUserDataIsPersistedAfterCheckpoint() throws EETest.Fault {
        String METHOD = "testChunkRestartItemCount10";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.next.writepoints=0,5,10,15,20,25,30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.checkpoint.position", "0");
            jobParams.put("app.writepoints", "0,10,20,30");
            jobParams.put("app.next.writepoints", "10,20,30");
            TestUtil.logMsg((String)"Locate job XML file: chunkrestartCheckpt10.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunkrestartCheckpt10", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            List<StepExecution> stepExecs = jobOp.getStepExecutions(execution1.getExecutionId());
            MyPersistentRestartUserData persistedStepData = null;
            for (StepExecution stepExec : stepExecs) {
                if (!stepExec.getStepName().equals("step1")) continue;
                persistedStepData = (MyPersistentRestartUserData)stepExec.getPersistentUserData();
                break;
            }
            AssertionUtils.assertWithMessage("Testing execution #1", 1, persistedStepData.getExecutionNumber());
        }
        catch (Exception e) {
            ChunkTests.handleException(METHOD, e);
        }
    }

    private void showStepState(StepExecution step) {
        TestUtil.logMsg((String)"---------------------------");
        TestUtil.logMsg((String)("getJobExecutionId(): " + step.getStepExecutionId() + " - "));
        Metric[] metrics = step.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            TestUtil.logMsg((String)(metrics[i].getType() + ": " + metrics[i].getValue() + " - "));
        }
        TestUtil.logMsg((String)("getStartTime(): " + step.getStartTime() + " - "));
        TestUtil.logMsg((String)("getEndTime(): " + step.getEndTime() + " - "));
        TestUtil.logMsg((String)("getBatchStatus(): " + step.getBatchStatus() + " - "));
        TestUtil.logMsg((String)("getExitStatus(): " + step.getExitStatus()));
        TestUtil.logMsg((String)"---------------------------");
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }
}

