/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.reusable.MyParentException;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.listener.AbstractChunkListener;
import jakarta.batch.api.listener.StepListener;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;

@Named(value="myChunkListener")
public class MyChunkListener
extends AbstractChunkListener
implements StepListener {
    @Inject
    StepContext stepCtx;
    @Inject
    JobContext jobCtx;
    @Inject
    @BatchProperty(name="fail.immediate")
    String failImmediateString;
    boolean failThrowEx = false;

    public void beforeChunk() throws Exception {
        if (this.failImmediateString != null) {
            this.failThrowEx = Boolean.parseBoolean(this.failImmediateString);
        }
        if (this.failThrowEx) {
            throw new MyParentException("Testing getException");
        }
    }

    public void beforeStep() throws Exception {
    }

    public void afterStep() throws Exception {
        Exception ex = this.stepCtx.getException();
        if (ex == null) {
            this.jobCtx.setExitStatus("MyChunkListener: error, didn't find an exception.");
        } else if (ex instanceof MyParentException) {
            this.jobCtx.setExitStatus("MyChunkListener: found instanceof MyParentException");
        } else {
            this.jobCtx.setExitStatus("MyChunkListener: did not find instanceof MyParentException, but found another exception");
        }
    }
}

