/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;

public class MessageSenderBean {
    public static void sendMessage(QueueConnectionFactory queueConnectionFactory, Queue sendQueue, String testname, int testnum) {
        QueueConnection qConn = null;
        try {
            qConn = queueConnectionFactory.createQueueConnection();
            qConn.start();
            QueueSession qSession = qConn.createQueueSession(false, 1);
            QueueSender qSender = qSession.createSender(sendQueue);
            qSender.setTimeToLive(30000L);
            qSender.send((Message)MessageSenderBean.createTestMessage((Session)qSession, testname, testnum));
            Helper.getLogger().info(String.format("Message sent from testname: %s, testnum: %s, using sender: %s", testname, testnum, qSender));
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (qConn != null) {
                try {
                    qConn.close();
                }
                catch (JMSException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected static TextMessage createTestMessage(Session session, String testname, int num) {
        TextMessage msg;
        try {
            msg = session.createTextMessage();
            msg.setText(testname);
            msg.setIntProperty("TestCaseNum", num);
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", testname);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        return msg;
    }

    public static String getTestName(Message msg) {
        try {
            return msg.getStringProperty("COM_SUN_JMS_TESTNAME");
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }
}

