/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.singleton.concurrency.container.accesstimeout;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import jakarta.interceptor.InvocationContext;

public abstract class CallbackAccessTimeoutBeanBase {
    protected static final long ACCESS_TIMEOUT_MILLIS = 1000L;
    protected static final long AROUND_INVOKE_WAIT_MILLIS = 600L;

    public int postConstructWait(int resultVal) {
        return resultVal;
    }

    public void postConstruct() {
        this.busyWait(2000L, "PostConstruct");
    }

    public void preDestroy() {
        this.busyWait(2000L, "PreDestroy");
    }

    public Object intercept(InvocationContext inv) throws Exception {
        if (inv != null && (inv.getMethod().getName().equals("postConstructWait") || inv.getMethod().getName().equals("postConstruct"))) {
            return inv.proceed();
        }
        this.busyWait(600L, "AroundInvoke");
        return inv == null ? null : inv.proceed();
    }

    protected void busyWait(long waitMillis, String methodName) {
        Helper.getLogger().fine("Waiting in " + methodName + ", but it should not affect AccessTimeout:" + waitMillis);
        Helper.busyWait(waitMillis);
    }
}

