/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.util.TSMessageListenerInterface;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.LocalTxActivationSpec;
import com.sun.ts.tests.common.connector.whitebox.LocalTxMessageListener;
import com.sun.ts.tests.common.connector.whitebox.LocalTxMessageWork;
import com.sun.ts.tests.common.connector.whitebox.LocalTxMessageWork1;
import com.sun.ts.tests.common.connector.whitebox.LocalTxMessageWork2;
import com.sun.ts.tests.common.connector.whitebox.TSSecurityContextWithListener;
import com.sun.ts.tests.common.connector.whitebox.TestBootstrapContext;
import com.sun.ts.tests.common.connector.whitebox.TestWorkManager;
import com.sun.ts.tests.common.connector.whitebox.Util;
import com.sun.ts.tests.common.connector.whitebox.XidImpl;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.resource.spi.work.DistributableWorkManager;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkContext;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkListener;
import jakarta.resource.spi.work.WorkManager;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class LocalTxResourceAdapterImpl
implements ResourceAdapter,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient TestWorkManager twm;
    private transient TestBootstrapContext tbs;
    private transient LocalTxMessageListener ml;
    private String RAName;
    private Boolean useSecurityMapping = null;
    private int counter = 0;
    private transient LocalTxMessageWork work1;
    private transient LocalTxMessageWork1 work2;
    private transient LocalTxMessageWork2 work3;
    private transient WorkManager wm;
    private int mefcount = 0;
    private transient MessageEndpointFactory mef1;
    private transient MessageEndpointFactory mef2;
    private transient BootstrapContext bsc;
    private String sicUser = "";
    private String sicPwd = "";
    private String eisUser = "";
    private String eisPwd = "";

    public LocalTxResourceAdapterImpl() {
        ConnectorStatus.getConnectorStatus().logState("LocalTxResourceAdapterImpl Constructor ");
        Debug.trace("LocalTxResourceAdapterImpl Constructor ");
        this.sicUser = TestUtil.getSystemProperty((String)"j2eelogin.name");
        this.sicPwd = TestUtil.getSystemProperty((String)"j2eelogin.password");
        this.eisUser = TestUtil.getSystemProperty((String)"eislogin.name");
        this.eisPwd = TestUtil.getSystemProperty((String)"eislogin.password");
    }

    public void start(final BootstrapContext bsc) throws ResourceAdapterInternalException {
        ++this.counter;
        this.bsc = bsc;
        Debug.trace("LocalTxResourceAdapter Started " + this.counter);
        String str1 = "LocalTxResourceAdapter Started " + this.counter;
        ConnectorStatus.getConnectorStatus().logState(str1);
        this.wm = bsc.getWorkManager();
        if (bsc != null) {
            ConnectorStatus.getConnectorStatus().logState("LocalTxResourceAdapter BootstrapContext Not Null ");
        }
        if (this.wm != null) {
            ConnectorStatus.getConnectorStatus().logState("LocalTxResourceAdapter WorkManager Not Null ");
            if (this.wm instanceof DistributableWorkManager) {
                Debug.trace("wm supports DistributableWorkManager");
                ConnectorStatus.getConnectorStatus().logState("wm supports DistributableWorkManager");
            } else {
                Debug.trace("wm Does NOT support DistributableWorkManager");
                ConnectorStatus.getConnectorStatus().logState("wm Does NOT support DistributableWorkManager");
            }
        }
        try {
            bsc.getWorkManager().startWork(new Work(){

                public void run() {
                    LocalTxResourceAdapterImpl.this.myStart(bsc);
                }

                public void release() {
                }
            });
        }
        catch (WorkException we) {
            throw new ResourceAdapterInternalException();
        }
    }

    private void myStart(BootstrapContext ctx) {
        this.wm = ctx.getWorkManager();
        this.twm = new TestWorkManager(ctx);
        if (this.useSecurityMapping.booleanValue()) {
            Debug.trace(" LocalTxResourceAdapterImpl ; calling setUseSecurityMapping(true)");
            ConnectorStatus.getConnectorStatus().logState(" LocalTxResourceAdapterImpl ; calling setUseSecurityMapping(true)");
            this.twm.setUseSecurityMapping(true);
        } else {
            Debug.trace(" LocalTxResourceAdapterImpl ; calling setUseSecurityMapping(false)");
            ConnectorStatus.getConnectorStatus().logState(" LocalTxResourceAdapterImpl ; calling setUseSecurityMapping(false)");
            this.twm.setUseSecurityMapping(false);
        }
        this.twm.runTests();
        this.tbs = new TestBootstrapContext(ctx);
        this.tbs.runTests();
    }

    public void stop() {
        if (this.work1 != null) {
            this.work1.stop();
        }
        if (this.work2 != null) {
            this.work2.stop();
        }
        if (this.work3 != null) {
            this.work3.stop();
        }
    }

    public void endpointActivation(MessageEndpointFactory mef, ActivationSpec as) {
        try {
            ++this.mefcount;
            Debug.trace("LocalTxResourceAdapter.endpointActivation called");
            Method onMessagexa = this.getOnMessageMethod();
            boolean de = mef.isDeliveryTransacted(onMessagexa);
            if (!de) {
                this.mef1 = mef;
                String destinationName = ((LocalTxActivationSpec)as).getDestinationName();
                Debug.trace("LocalTxResourceAdapter preparing work1");
                if (this.mef1 != null) {
                    Debug.trace("mef1 is not null");
                }
                this.work1 = new LocalTxMessageWork(destinationName, this.mef1);
                this.work1.setBootstrapContext(this.bsc);
                TSSecurityContextWithListener sic = new TSSecurityContextWithListener(this.sicUser, this.sicPwd, this.eisUser, this.useSecurityMapping);
                this.work1.addWorkContext((WorkContext)sic);
                Debug.trace("LocalTxResourceAdapter work1 created");
                this.wm.scheduleWork((Work)this.work1, Long.MAX_VALUE, null, null);
                Debug.trace("LocalTxResourceAdapter work1 scheduled");
            } else {
                this.mef2 = mef;
                Debug.trace("LocalTxResourceAdapter preparing work2");
                String destinationName = ((LocalTxActivationSpec)as).getDestinationName();
                Debug.trace("Before Destination name");
                Debug.trace("Destination name is " + destinationName);
                if (this.mef2 != null) {
                    Debug.trace("mef2 is not null");
                }
                this.work2 = new LocalTxMessageWork1(destinationName, this.mef2);
                Debug.trace("LocalTxResourceAdapter work2 created");
                this.wm.scheduleWork((Work)this.work2, Long.MAX_VALUE, null, null);
                Debug.trace("LocalTxResourceAdapter work2 scheduled");
                this.work3 = new LocalTxMessageWork2(destinationName, this.mef2);
                XidImpl myid = new XidImpl();
                ExecutionContext ec = new ExecutionContext();
                int idcount = myid.getFormatId();
                Debug.trace("XID getting used [ " + idcount + " ]");
                ec.setXid((Xid)myid);
                this.ml = new LocalTxMessageListener(myid, this.bsc);
                this.wm.scheduleWork((Work)this.work3, Long.MAX_VALUE, ec, (WorkListener)this.ml);
            }
            if (this.mefcount == 2) {
                this.chkUniqueMessageEndpointFactory();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] as) {
        return null;
    }

    private Method getOnMessageMethod() {
        Method onMessageMethod = null;
        try {
            Class<TSMessageListenerInterface> msgListenerClass = TSMessageListenerInterface.class;
            Class[] paramTypes = new Class[]{String.class};
            onMessageMethod = msgListenerClass.getMethod("onMessage", paramTypes);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return onMessageMethod;
    }

    private void chkUniqueMessageEndpointFactory() {
        if (this.mef1 != null && !this.mef1.equals(this.mef2)) {
            ConnectorStatus.getConnectorStatus().logState("LocalTx MessageEndpointFactory is Unique");
            ConnectorStatus.getConnectorStatus().logState("LocalTx MessageEndpointFactory equals implemented correctly");
        }
    }

    public void endpointDeactivation(MessageEndpointFactory mef, ActivationSpec as) {
        --this.mefcount;
        if (this.mef1 != null && this.mef1.equals(mef)) {
            this.mef1 = null;
        } else if (this.mef2 != null && this.mef2.equals(mef)) {
            this.mef2 = null;
        } else {
            Object str = "WARNING:  LocalTxResourceAdapterImpl.endpointDeactivation():  ";
            str = (String)str + "unexpected MEF passed in";
            Debug.trace((String)str);
            if (mef == null) {
                Debug.trace("NULL MEF passed into endpointDeactivation()");
            } else {
                Debug.trace("Unrecognize mef passed into endpointDeactivation()");
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LocalTxResourceAdapterImpl)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        LocalTxResourceAdapterImpl that = (LocalTxResourceAdapterImpl)obj;
        if (this.counter != that.getCounter()) {
            return false;
        }
        if (this.mefcount != that.getMefcount()) {
            return false;
        }
        if (!Util.isEqual(this.sicUser, that.getSicUser())) {
            return false;
        }
        if (!Util.isEqual(this.sicPwd, that.getSicPwd())) {
            return false;
        }
        if (!Util.isEqual(this.eisUser, that.getEisUser())) {
            return false;
        }
        if (!Util.isEqual(this.eisPwd, that.getEisPwd())) {
            return false;
        }
        if (!Util.isEqual(this.RAName, that.getRAName())) {
            return false;
        }
        return this.getUseSecurityMapping().booleanValue() == that.getUseSecurityMapping().booleanValue();
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public void setRAName(String name) {
        ConnectorStatus.getConnectorStatus().logState("LocalTxResourceAdapter.setRAName");
        this.RAName = name;
    }

    public String getRAName() {
        Debug.trace("LocalTxResourceAdapter.getRAName");
        return this.RAName;
    }

    public void setUseSecurityMapping(Boolean val) {
        this.useSecurityMapping = val;
    }

    public Boolean getUseSecurityMapping() {
        return this.useSecurityMapping;
    }

    public void setCounter(int val) {
        this.counter = val;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setMefcount(int val) {
        this.mefcount = val;
    }

    public int getMefcount() {
        return this.mefcount;
    }

    public void setSicUser(String val) {
        this.sicUser = val;
    }

    public String getSicUser() {
        return this.sicUser;
    }

    public void setSicPwd(String val) {
        this.sicPwd = val;
    }

    public String getSicPwd() {
        return this.sicPwd;
    }

    public void setEisUser(String val) {
        this.eisUser = val;
    }

    public String getEisUser() {
        return this.eisUser;
    }

    public void setEisPwd(String val) {
        this.eisPwd = val;
    }

    public String getEisPwd() {
        return this.eisPwd;
    }
}

