/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.common.pluggability.util;

import ee.jakarta.tck.persistence.common.pluggability.util.LogRecordEntry;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.SequenceInputStream;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.jupiter.api.BeforeAll;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogFileProcessor {
    private String logFileLocation = null;
    private String logFileName = "JPALog.xml";
    private Collection recordCollection = null;
    private Collection appIdRecordCollection = null;
    private Collection appSpecificRecordCollection = null;
    private static final System.Logger logger = System.getLogger(LogFileProcessor.class.getName());

    public LogFileProcessor() {
        this.setup();
    }

    @BeforeAll
    public void setup() {
        this.logFileLocation = System.getProperty("log.file.location");
        if (this.logFileLocation == null) {
            logger.log(System.Logger.Level.ERROR, "LogFileProcessor setup failed ");
            logger.log(System.Logger.Level.ERROR, "Please verify that the property log.file.location exists in ts.jte");
        } else {
            logger.log(System.Logger.Level.INFO, "log.file.location = " + this.logFileLocation);
        }
        this.logFileLocation = this.getLogFileName(this.logFileLocation);
        logger.log(System.Logger.Level.TRACE, "LogFileProcessor setup finished");
    }

    public long getCurrentSequenceNumber() {
        LogRecordEntry recordEntry2 = null;
        long seqNum = 0L;
        logger.log(System.Logger.Level.TRACE, "Searching for current Sequence Number");
        if (this.recordCollection != null) {
            logger.log(System.Logger.Level.TRACE, "Record collection has:  " + this.recordCollection.size() + " records.");
            for (LogRecordEntry recordEntry2 : this.recordCollection) {
                seqNum = recordEntry2.getSequenceNumber();
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Record collection empty : No log records found");
        }
        return seqNum;
    }

    public void purgeLog() {
        File logfile = null;
        try {
            if (this.logFileLocation != null) {
                logfile = new File(this.logFileLocation);
            }
            if (this.logFileLocation == null || !logfile.exists()) {
                logger.log(System.Logger.Level.ERROR, "Log File : " + this.logFileLocation + " does not exists");
            } else {
                logger.log(System.Logger.Level.TRACE, "Purging log file : " + this.logFileLocation);
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.logFileLocation));
                writer.newLine();
                writer.close();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception occurred while purging log:" + e);
        }
    }

    public boolean fetchLog() {
        boolean logRetrieved = false;
        File logfile = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (this.logFileLocation != null) {
                logfile = new File(this.logFileLocation);
            }
            if (this.logFileLocation == null || !logfile.exists()) {
                logger.log(System.Logger.Level.ERROR, "Log File : " + this.logFileLocation + " does not exists");
                logger.log(System.Logger.Level.ERROR, "Check permissions for log file ");
                logger.log(System.Logger.Level.ERROR, "See User guide for Configuring log file permissions");
            } else {
                logger.log(System.Logger.Level.TRACE, "Log File : " + logfile.getAbsolutePath());
                String endLogTag = "</log>";
                ByteArrayInputStream bais = new ByteArrayInputStream(endLogTag.getBytes());
                SequenceInputStream sis = new SequenceInputStream(new FileInputStream(this.logFileLocation), bais);
                Document document = documentBuilder.parse(sis);
                Element rootElement = document.getDocumentElement();
                NodeList nodes = rootElement.getChildNodes();
                this.recordCollection = LogFileProcessor.pullAllLogRecords(nodes);
                logRetrieved = true;
                sis.close();
                bais.close();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception occurred while fetching log:" + e);
        }
        return logRetrieved;
    }

    public static Collection pullAllLogRecords(NodeList nodes) throws Exception {
        Vector<LogRecordEntry> recordCollection = new Vector<LogRecordEntry>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node recordNode = nodes.item(i);
            if (!recordNode.getNodeName().equals("record")) continue;
            LogRecordEntry recordEntry = new LogRecordEntry(recordNode);
            recordCollection.add(recordEntry);
        }
        return recordCollection;
    }

    public void setAppIdRecordCollection(Collection recordCollection) {
        this.appIdRecordCollection = recordCollection;
    }

    public Collection getAppIdRecordCollection() {
        return this.appIdRecordCollection;
    }

    public void setRecordCollection(Collection recordCollection) {
        this.recordCollection = recordCollection;
    }

    public Collection getRecordCollection() {
        return this.recordCollection;
    }

    public void setAppSpecificRecordCollection(Collection recordCollection) {
        this.appSpecificRecordCollection = recordCollection;
    }

    public Collection getAppSpecificRecordCollection() {
        return this.appSpecificRecordCollection;
    }

    public boolean verifyLogContains(String[] args) {
        return this.verifyLogContains(args, 0L);
    }

    public boolean verifyLogContains(String[] args, long sequenceNum) {
        LogRecordEntry recordEntry2 = null;
        logger.log(System.Logger.Level.TRACE, "Searching log records for the following:");
        for (String s : args) {
            logger.log(System.Logger.Level.TRACE, "item:" + s);
        }
        if (this.recordCollection == null) {
            logger.log(System.Logger.Level.TRACE, "Record collection empty : No log records found");
            return false;
        }
        logger.log(System.Logger.Level.TRACE, "Record collection has:  " + this.recordCollection.size() + " records.");
        int numberOfArgs = args.length;
        int numberOfMatches = 0;
        boolean[] argsMatchIndex = new boolean[args.length];
        for (int i = 0; i < args.length; ++i) {
            argsMatchIndex[i] = false;
        }
        for (LogRecordEntry recordEntry2 : this.recordCollection) {
            long seqNum = recordEntry2.getSequenceNumber();
            if (seqNum < sequenceNum) continue;
            String message = recordEntry2.getMessage();
            for (int i = 0; i < numberOfArgs; ++i) {
                if (argsMatchIndex[i] || message == null || !message.equals(args[i])) continue;
                logger.log(System.Logger.Level.TRACE, "Matching Record :");
                logger.log(System.Logger.Level.TRACE, recordEntry2.getSequenceNumber() + ":" + recordEntry2.getMessage());
                ++numberOfMatches;
                argsMatchIndex[i] = true;
            }
            if (numberOfMatches != numberOfArgs) continue;
            return true;
        }
        logger.log(System.Logger.Level.TRACE, "No Matching log Record(s) found for the following String(s) :");
        for (int i = 0; i < numberOfArgs; ++i) {
            if (argsMatchIndex[i]) continue;
            logger.log(System.Logger.Level.TRACE, args[i]);
        }
        return false;
    }

    public boolean verifyLogContainsOneOf(String[] args) {
        LogRecordEntry recordEntry2 = null;
        boolean result = false;
        logger.log(System.Logger.Level.TRACE, "Searching log records for one of the following:");
        for (String s : args) {
            logger.log(System.Logger.Level.TRACE, "item:" + s);
        }
        if (this.recordCollection == null) {
            logger.log(System.Logger.Level.TRACE, "Record collection empty : No log records found");
            return false;
        }
        logger.log(System.Logger.Level.TRACE, "Record collection has:  " + this.recordCollection.size() + " records.");
        int numberOfArgs = args.length;
        block1: for (LogRecordEntry recordEntry2 : this.recordCollection) {
            String message = recordEntry2.getMessage();
            for (int i = 0; i < numberOfArgs; ++i) {
                if (message == null || !message.equals(args[i])) continue;
                logger.log(System.Logger.Level.TRACE, "Matching Record :");
                logger.log(System.Logger.Level.TRACE, recordEntry2.getSequenceNumber() + ":" + recordEntry2.getMessage());
                result = true;
                break block1;
            }
        }
        if (!result) {
            logger.log(System.Logger.Level.TRACE, "No Matching log Record(s) found for the following String(s) :");
            for (int i = 0; i < numberOfArgs; ++i) {
                logger.log(System.Logger.Level.TRACE, args[i]);
            }
        }
        return result;
    }

    public boolean verifyLogContainsOneOfSubString(String[] args, String srchStrPrefix) {
        LogRecordEntry recordEntry2 = null;
        boolean result = false;
        logger.log(System.Logger.Level.TRACE, "Searching log records for the presence of one of the String from a given string array");
        if (this.recordCollection == null) {
            logger.log(System.Logger.Level.TRACE, "Record collection empty : No log records found");
            return false;
        }
        logger.log(System.Logger.Level.TRACE, "Record collection has:  " + this.recordCollection.size() + " records.");
        int numberOfArgs = args.length;
        block0: for (LogRecordEntry recordEntry2 : this.recordCollection) {
            String message = recordEntry2.getMessage();
            for (int i = 0; i < numberOfArgs; ++i) {
                if (message == null || !message.startsWith(srchStrPrefix, 0) || message.indexOf(args[i]) <= 0) continue;
                logger.log(System.Logger.Level.TRACE, "Matching Record :");
                logger.log(System.Logger.Level.TRACE, recordEntry2.getMessage());
                result = true;
                break block0;
            }
        }
        if (!result) {
            logger.log(System.Logger.Level.TRACE, "No Matching log Record(s) found for the following String(s) :");
            for (int i = 0; i < numberOfArgs; ++i) {
                logger.log(System.Logger.Level.TRACE, args[i]);
            }
        }
        return result;
    }

    public void printCollection(Collection recordCollection) {
        LogRecordEntry recordEntry2 = null;
        for (LogRecordEntry recordEntry2 : recordCollection) {
            this.printRecordEntry(recordEntry2);
        }
    }

    public void printRecordEntry(LogRecordEntry rec) {
        logger.log(System.Logger.Level.TRACE, "*******Log Content*******");
        logger.log(System.Logger.Level.TRACE, "Milli Seconds  =" + rec.getMilliSeconds());
        logger.log(System.Logger.Level.TRACE, "Seqence no  =" + rec.getSequenceNumber());
        logger.log(System.Logger.Level.TRACE, "Message     =" + rec.getMessage());
        if (rec.getClassName() != null) {
            logger.log(System.Logger.Level.TRACE, "Class name  =" + rec.getClassName());
        }
        if (rec.getMethodName() != null) {
            logger.log(System.Logger.Level.TRACE, "Method name =" + rec.getMethodName());
        }
        if (rec.getLevel() != null) {
            logger.log(System.Logger.Level.TRACE, "Level        =" + rec.getLevel());
        }
        if (rec.getThrown() != null) {
            logger.log(System.Logger.Level.TRACE, "Thrown       =" + rec.getThrown());
        }
        logger.log(System.Logger.Level.TRACE, "");
    }

    public String extractQueryToken(String str, String ContextId) {
        String DELIMETER = "|";
        String qstring = null;
        String qparams = null;
        StringTokenizer strtok = new StringTokenizer(ContextId, DELIMETER);
        if (ContextId.indexOf(DELIMETER) > 0) {
            qstring = strtok.nextToken();
            if (strtok.hasMoreTokens()) {
                qparams = strtok.nextToken();
            }
        }
        if (str.equals("LogQueryString")) {
            return qstring;
        }
        return qparams;
    }

    public static String[] getTokens(String str, String delimeter) {
        String[] array = new String[2];
        StringTokenizer strtoken = new StringTokenizer(str, delimeter);
        if (str.indexOf(delimeter) > 0) {
            array[0] = strtoken.nextToken();
            array[1] = str.substring(array[0].length() + 3, str.length());
        }
        return array;
    }

    public Collection findLogsByPrefix(String queryParams, NodeList nodes) throws Exception {
        Vector<LogRecordEntry> recordCollection = new Vector<LogRecordEntry>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node recordNode = nodes.item(i);
            NodeList recordNodeChildren = recordNode.getChildNodes();
            for (int j = 0; j < recordNodeChildren.getLength(); ++j) {
                String nodeValue;
                Node childNode = recordNodeChildren.item(j);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals("message") || !(nodeValue = this.getText(childNode)).startsWith(queryParams)) continue;
                LogRecordEntry recordEntry = new LogRecordEntry(recordNode);
                recordCollection.add(recordEntry);
            }
        }
        return recordCollection;
    }

    public String getText(Node textNode) {
        String result = "";
        NodeList nodes = textNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 3) continue;
            result = node.getNodeValue();
            break;
        }
        return result;
    }

    public String getLogFileName(String logFileLocation) {
        String logName = logFileLocation + File.separator + this.logFileName;
        String lastFileName = this.logFileName;
        int lastFileIndex = 0;
        File dir = new File(logFileLocation);
        if (dir.exists()) {
            logger.log(System.Logger.Level.TRACE, "log file location exists:" + logFileLocation);
            String[] chld = dir.list();
            if (chld == null) {
                logger.log(System.Logger.Level.ERROR, "Appserver log directory does not exist or is not a directory, using default log file location.");
            } else {
                boolean found = false;
                for (int i = 0; i < chld.length; ++i) {
                    String fName = chld[i];
                    if (fName.indexOf(this.logFileName) >= 0 && fName.indexOf(".lck") < 0) {
                        int lastFileIndexTemp;
                        String[] fileNameArr = fName.split("\\.");
                        if (fileNameArr.length == 3 && lastFileIndex < (lastFileIndexTemp = Integer.parseInt(fileNameArr[2]))) {
                            lastFileIndex = lastFileIndexTemp;
                            lastFileName = fName;
                        }
                        logName = logFileLocation + File.separator + lastFileName;
                        logger.log(System.Logger.Level.INFO, "Found log file:" + logName);
                        found = true;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Ignoring file:" + fName);
                }
                if (!found) {
                    logger.log(System.Logger.Level.INFO, "Log file not found, using default location:" + logName);
                }
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Log file location DOES NOT exist, using default location:" + logName);
        }
        return logName;
    }
}

