/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation;

import ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.TSLogRecord;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;

public class TSXMLFormatter
extends XMLFormatter {
    private String contextId;

    @Override
    public String format(LogRecord lrecord) {
        String message = lrecord.getMessage();
        Level level = lrecord.getLevel();
        TSLogRecord record = new TSLogRecord(level, message);
        return this.format(record);
    }

    public String format(TSLogRecord record) {
        StringBuffer sb;
        block11: {
            sb = new StringBuffer(500);
            sb.append("<record>\n");
            sb.append("  <sequence>");
            sb.append(record.getSequenceNumber());
            sb.append("</sequence>\n");
            sb.append("  <dateTime>");
            sb.append(record.getDateTime());
            sb.append("</dateTime>\n");
            sb.append("  <contextId>");
            sb.append(record.getContextId());
            sb.append("</contextId>\n");
            sb.append("  <level>");
            this.escape(sb, record.getLevel().toString());
            sb.append("</level>\n");
            if (record.getSourceClassName() != null) {
                sb.append("  <class>");
                this.escape(sb, record.getSourceClassName());
                sb.append("; pkgName +\n");
            }
            if (record.getSourceMethodName() != null) {
                sb.append("  <method>");
                this.escape(sb, record.getSourceMethodName());
                sb.append("</method>\n");
            }
            sb.append("  <thread>");
            sb.append(record.getThreadID());
            sb.append("</thread>\n");
            if (record.getMessage() != null) {
                String message = this.formatMessage(record);
                sb.append("  <message>");
                this.escape(sb, message);
                sb.append("</message>");
                sb.append("\n");
            }
            ResourceBundle bundle = record.getResourceBundle();
            try {
                if (bundle == null || bundle.getString(record.getMessage()) == null) break block11;
                sb.append("  <key>");
                this.escape(sb, record.getMessage());
                sb.append("</key>\n");
                sb.append("  <catalog>");
                this.escape(sb, record.getResourceBundleName());
                sb.append("</catalog>\n");
                Object[] parameters = record.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    sb.append("  <param>");
                    try {
                        this.escape(sb, parameters[i].toString());
                    }
                    catch (Exception ex) {
                        sb.append("???");
                    }
                    sb.append("</param>\n");
                }
            }
            catch (Exception parameters) {
                // empty catch block
            }
        }
        if (record.getThrown() != null) {
            Throwable th = record.getThrown();
            sb.append("  <exception>\n");
            sb.append("    <message>");
            this.escape(sb, th.toString());
            sb.append("</message>\n");
            StackTraceElement[] trace = th.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                StackTraceElement frame = trace[i];
                sb.append("    <frame>\n");
                sb.append("      <class>");
                this.escape(sb, frame.getClassName());
                sb.append("; pkgName +\n");
                sb.append("      <method>");
                this.escape(sb, frame.getMethodName());
                sb.append("</method>\n");
                if (frame.getLineNumber() >= 0) {
                    sb.append("      <line>");
                    sb.append(frame.getLineNumber());
                    sb.append("</line>\n");
                }
                sb.append("    </frame>\n");
            }
            sb.append("  </exception>\n");
        }
        sb.append("</record>\n");
        return sb.toString();
    }

    private void escape(StringBuffer sb, String text) {
        if (text == null) {
            text = "<null>";
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(ch);
        }
    }

    @Override
    public String getHead(Handler h) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"");
        String encoding = "UTF-8";
        sb.append(" encoding=\"");
        sb.append(encoding);
        sb.append("\"");
        sb.append(" standalone=\"no\"?>\n");
        sb.append("<log>\n");
        return sb.toString();
    }
}

