/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.entity;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.entity.NameOnlyInXML;
import ee.jakarta.tck.persistence.core.override.entity.NoEntityAnnotation;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final Long ID = 9L;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFiles = new String[]{"orm.xml"};
        String[] classes = new String[]{pkgName + "NameOnlyInAnnotation", pkgName + "NameOnlyInXML", pkgName + "NameOverride", pkgName + "NoEntityAnnotation"};
        return this.createDeploymentJar("jpa_core_override_entity.jar", pkgNameWithoutSuffix, classes, xmlFiles);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception:test failed ", (Throwable)e);
        }
    }

    @Test
    public void testNameOnlyInXML() throws Exception {
        block6: {
            this.getEntityTransaction().begin();
            NameOnlyInXML entity = new NameOnlyInXML();
            entity.setId(ID);
            this.getEntityManager().persist((Object)entity);
            this.getEntityManager().flush();
            try {
                List result = this.getEntityManager().createNamedQuery("findAll").getResultList();
                logger.log(System.Logger.Level.TRACE, "Result of the entity is " + result.size());
                if (result.size() == 1) {
                    logger.log(System.Logger.Level.TRACE, "Test Passed");
                    break block6;
                }
                throw new Exception("Expected the size to be 1  but it is -" + result.size());
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testNameOnlyInXML" + e);
            }
            finally {
                this.getEntityManager().remove((Object)entity);
                this.getEntityTransaction().commit();
            }
        }
    }

    @Test
    public void testNameOnlyInAnnotation() throws Exception {
        List result = this.getEntityManager().createQuery("SELECT m FROM NAMEONLYINANNOTATION m").getResultList();
        if (result.size() != 0) {
            throw new Exception("Expected the size to be 0  but it is -" + result.size());
        }
        logger.log(System.Logger.Level.TRACE, "Test Passed");
    }

    @Test
    public void testNameOverride() throws Exception {
        List result = this.getEntityManager().createQuery("SELECT n FROM NAMEOVERRIDE n").getResultList();
        if (result.size() != 0) {
            throw new Exception("Expected the size to be 0  but it is -" + result.size());
        }
        logger.log(System.Logger.Level.TRACE, "Test Passed");
    }

    @Test
    public void testNoEntityAnnotation() throws Exception {
        block6: {
            this.getEntityTransaction().begin();
            NoEntityAnnotation entity = new NoEntityAnnotation();
            entity.setId(ID);
            this.getEntityManager().persist((Object)entity);
            this.getEntityManager().flush();
            try {
                List result = this.getEntityManager().createNamedQuery("findAllNoEntityAnnotation").getResultList();
                logger.log(System.Logger.Level.TRACE, "Result of the entity is " + result.size());
                if (result.size() == 1) {
                    logger.log(System.Logger.Level.TRACE, "Test Passed");
                    break block6;
                }
                throw new Exception("Expected the size to be 1  but it is -" + result.size());
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testNoEntityAnnotation" + e);
            }
            finally {
                this.getEntityManager().remove((Object)entity);
                this.getEntityTransaction().commit();
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NAMEONLYINXML").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYANNOTATION").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

