/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.mappedsuperclasstype;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.mappedsuperclasstype.FullTimeEmployee;
import ee.jakarta.tck.persistence.core.metamodelapi.mappedsuperclasstype.FullTimeEmployee2;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.MappedSuperclassType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Employee", pkgName + "Employee2", pkgName + "EmployeeId", pkgName + "FullTimeEmployee", pkgName + "FullTimeEmployee2"};
        return this.createDeploymentJar("jpa_core_metamodelapi_mappedsuperclasstype.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void mappedSuperclassType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            pass = false;
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Set of EntityType");
                for (EntityType mType : aSet) {
                    logger.log(System.Logger.Level.TRACE, "EntityType:" + mType.getJavaType().getName());
                    IdentifiableType idType = mType.getSupertype();
                    if (idType == null) continue;
                    logger.log(System.Logger.Level.TRACE, "IdentifiableType:" + idType.getJavaType().getName());
                    if (!(idType instanceof MappedSuperclassType)) continue;
                    logger.log(System.Logger.Level.TRACE, "type is instance of MappedSuperClassType:" + idType.getJavaType().getName());
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("mappedSuperclassType failed");
        }
    }

    @Test
    public void getDeclaredId() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    SingularAttribute idAttrib = idType.getDeclaredId(String.class);
                    if (idAttrib != null) {
                        String name = idAttrib.getType().getJavaType().getName();
                        if (name.equals("java.lang.String")) {
                            logger.log(System.Logger.Level.TRACE, "Received:" + name);
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected java.lang.String, actual:" + name);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getDeclaredId(...) returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSupertype() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredId failed");
        }
    }

    @Test
    public void getDeclaredIdIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        idType.getDeclaredId(Date.class);
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSupertype() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredIdIllegalArgumentException failed");
        }
    }

    public void getDeclaredVersion() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    SingularAttribute idAttrib = idType.getDeclaredVersion(Integer.class);
                    if (idAttrib != null) {
                        String name = idAttrib.getType().getJavaType().getName();
                        if (name.equals("java.lang.Integer")) {
                            logger.log(System.Logger.Level.TRACE, "Received:" + name);
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected java.lang.Integer, actual:" + name);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getDeclaredId(...) returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSupertype() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredVersion failed");
        }
    }

    @Test
    public void getDeclaredVersionIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        idType.getDeclaredVersion(Date.class);
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSupertype() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredVersionIllegalArgumentException failed");
        }
    }

    @Test
    public void getId() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    SingularAttribute idAttrib = idType.getId(String.class);
                    if (idAttrib != null) {
                        String name = idAttrib.getType().getJavaType().getName();
                        if (name.equals("java.lang.String")) {
                            logger.log(System.Logger.Level.TRACE, "Received:" + name);
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected java.lang.String, actual:" + name);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getDeclaredId(...) returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSupertype() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getId failed");
        }
    }

    @Test
    public void getIdIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        idType.getId(Date.class);
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSupertype() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdIllegalArgumentException failed");
        }
    }

    @Test
    public void getIdClassAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    Set idAttribSet = idType.getIdClassAttributes();
                    if (idAttribSet != null) {
                        if (idAttribSet.size() > 0) {
                            for (Attribute attrib : idAttribSet) {
                                actual.add(attrib.getName());
                            }
                            Collections.sort(actual);
                            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                                logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                                for (String attribName : expected) {
                                    logger.log(System.Logger.Level.TRACE, "attrib:" + attribName);
                                }
                                pass = true;
                            } else {
                                logger.log(System.Logger.Level.ERROR, "Received Unexpected attributes");
                                logger.log(System.Logger.Level.ERROR, "Expected:");
                                for (String attribName : expected) {
                                    logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                                }
                                logger.log(System.Logger.Level.ERROR, "Actual:");
                                for (String attribName : actual) {
                                    logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                                }
                            }
                        } else {
                            logger.log(System.Logger.Level.ERROR, "getIdClassAttributes() returned 0 results");
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getIdClassAttributes() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSupertype() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdClassAttributes failed");
        }
    }

    @Test
    public void getIdClassAttributesIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        idType.getIdClassAttributes();
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSupertype() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdClassAttributesIllegalArgumentException failed");
        }
    }

    @Test
    public void getIdType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    String name = idType.getIdType().getJavaType().getName();
                    if (name.equals("java.lang.String")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected: " + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected java.lang.String, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSupertype() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getId failed");
        }
    }

    @Test
    public void getVersion() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    SingularAttribute idAttrib = eType.getVersion(Integer.class);
                    String name = idAttrib.getType().getJavaType().getName();
                    if (name.equals("java.lang.Integer")) {
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected java.lang.Integer, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSupertype() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getVersion failed");
        }
    }

    @Test
    public void getVersionIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        eType.getVersion(Date.class);
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSupertype() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getVersionIllegalArgumentException failed");
        }
    }

    @Test
    public void hasSingleIdAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    boolean hasSingleIdAttribute = idType.hasSingleIdAttribute();
                    if (hasSingleIdAttribute) {
                        pass = true;
                        logger.log(System.Logger.Level.TRACE, "hasSingleIdAttribute() returned" + hasSingleIdAttribute);
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: false, actual:" + hasSingleIdAttribute);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSupertype() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("hasSingleIdAttribute failed");
        }
    }

    @Test
    public void hasVersionAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    boolean hasVersionAttribute = idType.hasVersionAttribute();
                    if (hasVersionAttribute) {
                        pass = true;
                        logger.log(System.Logger.Level.TRACE, "hasVersionAttribute() returned" + hasVersionAttribute);
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: false, actual:" + hasVersionAttribute);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSupertype() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("hasVersionAttribute failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

