/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.embeddabletype;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.embeddabletype.Address;
import ee.jakarta.tck.persistence.core.metamodelapi.embeddabletype.ZipCode;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "Address", pkgName + "ZipCode"};
        return this.createDeploymentJar("jpa_core_metamodelapi_embeddabletype.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void embeddableTest() throws Exception {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cZipcode");
        expected.add("street");
        expected.add("state");
        expected.add("city");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                EmbeddableType eTypeOrder = metaModel.embeddable(Address.class);
                if (eTypeOrder != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null EmbeddableType");
                    Set attribSet = eTypeOrder.getDeclaredAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            String name = attrib.getName();
                            if (expected.contains(name)) {
                                logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                                continue;
                            }
                            logger.log(System.Logger.Level.ERROR, "Received unexpected result:" + name);
                            pass = false;
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getDeclaredAttributes() returned null");
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "embeddable() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("embeddableTest failed");
        }
    }

    @Test
    public void getAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                Attribute attrib = eType.getAttribute("street");
                if (attrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                    String name = attrib.getName();
                    if (name.equals("street")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: street, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getAttribute(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getAttribute failed");
        }
    }

    @Test
    public void getAttributeIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                try {
                    eType.getAttribute("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getAttributeIllegalArgumentException failed");
        }
    }

    @Test
    public void getAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("street");
        expected.add("state");
        expected.add("city");
        expected.add("cZipcode");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                Set set = eType.getAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.TRACE, "attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received unexpected attributes");
                            logger.log(System.Logger.Level.ERROR, "Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                            logger.log(System.Logger.Level.ERROR, "Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getAttributes() returned 0 results");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getAttributes() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getAttributes failed");
        }
    }

    @Test
    public void getCollectionStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                CollectionAttribute cAttrib = eType.getCollection("cZipcode", ZipCode.class);
                if (cAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: cZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getCollection(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionStringClass failed");
        }
    }

    @Test
    public void getCollectionStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getCollection("doesnotexist", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getCollectionString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                CollectionAttribute cAttrib = eType.getCollection("cZipcode");
                if (cAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: cZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getCollection(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionString failed");
        }
    }

    @Test
    public void getCollectionStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getCollection("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                Attribute attrib = eType.getDeclaredAttribute("cZipcode");
                if (attrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                    String name = attrib.getName();
                    if (name.equals("cZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: cZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredAttribute(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredAttribute failed");
        }
    }

    @Test
    public void getDeclaredAttributeIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredAttribute("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredAttributeIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("street");
        expected.add("state");
        expected.add("city");
        expected.add("cZipcode");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                Set set = eType.getDeclaredAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.TRACE, "attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received unexpected attributes:");
                            logger.log(System.Logger.Level.ERROR, "Expected (" + expected.size() + "):");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                            logger.log(System.Logger.Level.ERROR, "Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getAttributes() returned 0 results");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredAttributes() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredAttributes failed");
        }
    }

    @Test
    public void getDeclaredCollectionStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                CollectionAttribute cAttrib = eType.getCollection("cZipcode", ZipCode.class);
                if (cAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: cZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getCollection(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringClass failed");
        }
    }

    @Test
    public void getDeclaredCollectionStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredCollection("doesnotexist", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredCollectionString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                CollectionAttribute cAttrib = eType.getCollection("cZipcode", ZipCode.class);
                if (cAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + cAttrib.getName());
                    String name = cAttrib.getName();
                    if (name.equals("cZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: cZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getCollection(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionString failed");
        }
    }

    @Test
    public void getDeclaredCollectionStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredCollection("doesnotexist", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredListStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                ListAttribute lAttrib = eType.getDeclaredList("lZipcode", ZipCode.class);
                if (lAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: lZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredList(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListStringClass failed");
        }
    }

    @Test
    public void getDeclaredListStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredList("doesnotexist", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredListString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                ListAttribute lAttrib = eType.getDeclaredList("lZipcode");
                if (lAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: lZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredList(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListString failed");
        }
    }

    @Test
    public void getDeclaredListStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredList("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredListStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredMapStringClassClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                MapAttribute mAttrib = eType.getDeclaredMap("mZipcode", ZipCode.class, String.class);
                if (mAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: mZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredMap(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapStringClassClass failed");
        }
    }

    @Test
    public void getDeclaredMapStringClassClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredMap("doesnotexist", Address.class, String.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapStringClassClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredMapString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                MapAttribute mAttrib = eType.getDeclaredMap("mZipcode");
                if (mAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: mZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredMap(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapString failed");
        }
    }

    @Test
    public void getDeclaredMapStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredMap("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredMapStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredSetStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                SetAttribute sAttrib = eType.getDeclaredSet("sZipcode", ZipCode.class);
                if (sAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: sZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredSet(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetStringClass failed");
        }
    }

    @Test
    public void getDeclaredSetStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredSet("doesnotexist", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredSetString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                SetAttribute sAttrib = eType.getDeclaredSet("sZipcode");
                if (sAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: sZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredSet(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetString failed");
        }
    }

    @Test
    public void getDeclaredSetStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredSet("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSetStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributeStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                SingularAttribute singAttrib = eType.getDeclaredSingularAttribute("city", String.class);
                if (singAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute city = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("city")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: name, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredSingularAttribute(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringClass failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributeStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                try {
                    eType.getDeclaredSingularAttribute("value", Integer.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributeString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                SingularAttribute singAttrib = eType.getDeclaredSingularAttribute("street");
                if (singAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("street")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: street, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredSingularAttribute(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeString failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributeStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                try {
                    eType.getDeclaredSingularAttribute("value");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("city");
        expected.add("state");
        expected.add("street");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                Set set = eType.getDeclaredSingularAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.TRACE, "attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received unexpected attributes");
                            logger.log(System.Logger.Level.ERROR, "Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                            logger.log(System.Logger.Level.ERROR, "Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getDeclaredSingularAttributes() returned 0 results");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredSingularAttributes() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributes failed");
        }
    }

    @Test
    public void getListStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                ListAttribute lAttrib = eType.getList("lZipcode", ZipCode.class);
                if (lAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: lZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getList(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListStringClass failed");
        }
    }

    @Test
    public void getListStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getList("doesnotexist", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getListString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                ListAttribute lAttrib = eType.getList("lZipcode");
                if (lAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + lAttrib.getName());
                    String name = lAttrib.getName();
                    if (name.equals("lZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: lZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getList(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListString failed");
        }
    }

    @Test
    public void getListStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredList("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getListStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getMapStringClassClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                MapAttribute mAttrib = eType.getMap("mZipcode", ZipCode.class, String.class);
                if (mAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: mZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getMap(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapStringClassClass failed");
        }
    }

    @Test
    public void getMapStringClassClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getMap("doesnotexist", Address.class, String.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapStringClassClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getMapString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                MapAttribute mAttrib = eType.getMap("mZipcode");
                if (mAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + mAttrib.getName());
                    String name = mAttrib.getName();
                    if (name.equals("mZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: mZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getMap(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapString failed");
        }
    }

    @Test
    public void getMapStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getMap("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getMapStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getPluralAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cZipcode");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                Set set = eType.getPluralAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.TRACE, "attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received Unexpected attributes");
                            logger.log(System.Logger.Level.ERROR, "Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                            logger.log(System.Logger.Level.ERROR, "Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getPluralAttributes() returned 0 results");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getPluralAttributes() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPluralAttributes failed");
        }
    }

    @Test
    public void getSetStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                SetAttribute sAttrib = eType.getSet("sZipcode", ZipCode.class);
                if (sAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: sZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSet(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetStringClass failed");
        }
    }

    @Test
    public void getSetStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getSet("doesnotexist", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getSetString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                SetAttribute sAttrib = eType.getSet("sZipcode");
                if (sAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + sAttrib.getName());
                    String name = sAttrib.getName();
                    if (name.equals("sZipcode")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: sZipcode, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSet(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetString failed");
        }
    }

    @Test
    public void getSetStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getSet("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSetStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getSingularAttributeStringClass() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                SingularAttribute singAttrib = eType.getSingularAttribute("street", String.class);
                if (singAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("street")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: street, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSingularAttribute(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeStringClass failed");
        }
    }

    @Test
    public void getSingularAttributeStringClassIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                try {
                    eType.getSingularAttribute("doesnotexist", Address.class);
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeStringClassIllegalArgumentException failed");
        }
    }

    @Test
    public void getSingularAttributeString() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                SingularAttribute singAttrib = eType.getSingularAttribute("street");
                if (singAttrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + singAttrib.getName());
                    String name = singAttrib.getName();
                    if (name.equals("street")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + name);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: street, actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSingularAttribute(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeString failed");
        }
    }

    @Test
    public void getSingularAttributeStringIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                try {
                    eType.getSingularAttribute("doesnotexist");
                    logger.log(System.Logger.Level.ERROR, "Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributeStringIllegalArgumentException failed");
        }
    }

    @Test
    public void getSingularAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("city");
        expected.add("state");
        expected.add("street");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Entity Address");
                Set set = eType.getSingularAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.TRACE, "attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received Unexpected attributes");
                            logger.log(System.Logger.Level.ERROR, "Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                            logger.log(System.Logger.Level.ERROR, "Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getSingularAttributes() returned 0 results");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getSingularAttributes(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSingularAttributes failed");
        }
    }

    @Test
    public void getDeclaredPluralAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cZipcode");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                Set set = eType.getDeclaredPluralAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.TRACE, "attrib:" + attribName);
                            }
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received Unexpected attributes");
                            logger.log(System.Logger.Level.ERROR, "Expected(" + expected.size() + "):");
                            for (String attribName : expected) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                            logger.log(System.Logger.Level.ERROR, "Actual(" + actual.size() + "):");
                            for (String attribName : actual) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getPluralAttributes() returned 0 results");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getPluralAttributes() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredPluralAttributes failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

