/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.remove.basic;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.remove.basic.A;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A"};
        return this.createDeploymentJar("jpa_core_entitytest_remove_basic.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeBasicTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin removeBasicTest1");
        boolean pass = false;
        A a1 = new A("1", "a1", 1);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().remove((Object)a1);
            pass = true;
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception during remove operation.  Should have been ignored.", (Throwable)fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("removeBasicTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeBasicTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin removeBasicTest2");
        boolean pass = false;
        A a1 = new A("2", "a2", 2);
        this.createA(a1);
        this.getEntityTransaction().begin();
        try {
            A newA = this.findA("2");
            this.getEntityManager().remove((Object)newA);
            logger.log(System.Logger.Level.TRACE, "Call contains after remove()");
            pass = !this.getEntityManager().contains((Object)newA);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("removeBasicTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeBasicTest3() throws Exception {
        A a1 = new A("4", "a4", 4);
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            this.getEntityManager().persist((Object)a1);
            if (this.getEntityManager().contains((Object)a1)) {
                try {
                    this.getEntityManager().remove((Object)a1);
                    this.getEntityManager().flush();
                    A stillExists = this.findA("4");
                    if (stillExists == null) {
                        this.getEntityManager().remove((Object)a1);
                        pass = true;
                    }
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception caught trying to remove a removed entity, should have been ignored", (Throwable)e);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "entity not managed, unexpected, test fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("removeBasicTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeBasicTest4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin removeBasicTest4");
        boolean pass = false;
        A a1 = new A("5", "a5", 5);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a1);
        try {
            A newA = this.findA("5");
            if (null != newA) {
                logger.log(System.Logger.Level.TRACE, "Found newA, try Remove");
                this.getEntityManager().remove((Object)newA);
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "Removed, try to find and verify the entity has been removed");
                newA = this.findA("5");
                if (null == newA) {
                    logger.log(System.Logger.Level.TRACE, "NewA is Null as expected");
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Could not find persisted entity.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception attempting to find removed entity:" + e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("removeBasicTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeBasicTest5() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin removeBasicTest5");
        boolean pass = false;
        A a1 = new A("6", "a6", 6);
        this.createA(a1);
        try {
            this.getEntityTransaction().begin();
            A a2 = this.findA("6");
            this.getEntityManager().remove((Object)a2);
            if (!this.getEntityManager().contains((Object)a2)) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception caught:" + e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("removeBasicTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeMergeBasicTest() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin removeMergeBasicTest");
        boolean pass = false;
        String reason = null;
        String aId = "7";
        A a1 = new A("7", "a7", 7);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            this.getEntityManager().remove((Object)a1);
            try {
                this.getEntityManager().merge((Object)a1);
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.TRACE, "Got expected exception when merging a removed entity:" + e);
                pass = true;
            }
            if (!pass) {
                this.getEntityTransaction().commit();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "This exception may be expected, but we need to check if the commit really failed:" + e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            A aFound = this.findA("7");
            if (aFound == null) {
                pass = true;
                logger.log(System.Logger.Level.TRACE, "No entity with id 7 was found.  The commit must have failed, as expected.");
            } else {
                reason = "Entity with id 7 was found: " + aFound + ".  It means the previous commit unexpectedly succeeded.";
                logger.log(System.Logger.Level.TRACE, reason);
            }
        }
        if (!pass) {
            throw new Exception("removeMergeBasicTest failed, reason: " + reason);
        }
    }

    private void createA(A a) {
        logger.log(System.Logger.Level.TRACE, "Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    private A findA(String id) {
        logger.log(System.Logger.Level.TRACE, "Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

