/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.cascadeall.manyXmany;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.cascadeall.manyXmany.A;
import ee.jakarta.tck.persistence.core.entitytest.cascadeall.manyXmany.B;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "B"};
        return this.createDeploymentJar("jpa_core_entitytest_cascadeall_manyXmany.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMXMTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAllMXMTest1");
        boolean pass = false;
        try {
            logger.log(System.Logger.Level.TRACE, "New instances");
            B b1 = new B("1", "b1", 1);
            B b2 = new B("2", "b2", 1);
            B b3 = new B("3", "b3", 1);
            B b4 = new B("4", "b4", 1);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("1", "bean1", 1, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Test failed");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMXMTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMXMTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAllMXMTest2");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            B b1 = new B("1", "b1", 2);
            B b2 = new B("2", "b2", 2);
            B b3 = new B("3", "b3", 2);
            B b4 = new B("4", "b4", 2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("2", "bean2", 2, v1);
            this.getEntityManager().persist((Object)aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                try {
                    A newA = this.findA("2");
                    logger.log(System.Logger.Level.TRACE, "Remove newA ");
                    this.getEntityManager().remove((Object)newA);
                    this.getEntityManager().flush();
                    logger.log(System.Logger.Level.TRACE, "Persist a removed entity ");
                    this.getEntityManager().persist((Object)newA);
                    pass = this.getInstanceStatus(newA);
                }
                catch (Exception ee) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception trying to persist a removed entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMXMTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMXMTest3() throws Exception {
        boolean pass = false;
        try {
            logger.log(System.Logger.Level.TRACE, "New instances");
            B b1 = new B("4", "b4", 4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            A aRef = new A("4", "bean4", 4, v1);
            this.createA(aRef);
            this.getEntityTransaction().begin();
            A a2 = this.findA("4");
            if (this.getEntityManager().contains((Object)a2)) {
                a2.setAName("newBean4");
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "getAName returns: " + a2.getAName());
                if (a2.getAName().equals("newBean4")) {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Entity not managed - test fails.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMXMTest3 failed");
        }
    }

    @Test
    public void cascadeAllMXMTest4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAllMXMTest4");
        boolean pass = false;
        try {
            B b1 = new B("1", "b1", 5);
            B b2 = new B("2", "b2", 5);
            B b3 = new B("3", "b3", 5);
            B b4 = new B("4", "b4", 5);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New A instance");
            A a1 = new A("5", "bean5", 5, v1);
            this.getEntityManager().persist((Object)a1);
            Collection newCol = a1.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                try {
                    logger.log(System.Logger.Level.TRACE, "Remove instances");
                    this.getEntityManager().remove((Object)this.findB("1"));
                    this.getEntityManager().remove((Object)this.findB("2"));
                    this.getEntityManager().remove((Object)this.findB("3"));
                    this.getEntityManager().remove((Object)this.findB("4"));
                    this.getEntityManager().remove((Object)a1);
                    if (!this.getEntityManager().contains((Object)a1)) {
                        pass = true;
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception fe) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception caught trying to remove entity instance :", (Throwable)fe);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Test failed");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("cascadeAllMXMTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMXMTest5() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAllMXMTest5");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New B instances");
            B b1 = new B("1", "b1", 6);
            B b2 = new B("2", "b2", 6);
            B b3 = new B("3", "b3", 6);
            B b4 = new B("4", "b4", 6);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            logger.log(System.Logger.Level.TRACE, "New A instance");
            A a1 = new A("6", "bean6", 6, v1);
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            A a2 = this.findA("6");
            Collection newCol = a2.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                try {
                    pass = this.getInstanceStatus(a2);
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception caught trying to remove entity instance :" + fe);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMXMTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMXMTest6() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAllMXMTest6");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New B instances");
            B b1 = new B("1", "b1", 7);
            B b2 = new B("2", "b2", 7);
            B b3 = new B("3", "b3", 7);
            B b4 = new B("4", "b4", 7);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            logger.log(System.Logger.Level.TRACE, "New A instance");
            A a1 = new A("7", "bean7", 7, v1);
            this.getEntityManager().persist((Object)a1);
            pass = this.getInstanceStatus(a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMXMTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMXMTest7() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAllMXMTest7");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New A instance");
            B b1 = new B("1", "b1", 8);
            B b2 = new B("2", "b2", 8);
            B b3 = new B("3", "b3", 8);
            B b4 = new B("4", "b4", 8);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            logger.log(System.Logger.Level.TRACE, "New B instances");
            A a1 = new A("8", "bean8", 8, v1);
            this.getEntityManager().persist((Object)a1);
            pass = this.getEntityManager().contains((Object)b1) && this.getEntityManager().contains((Object)b2) && this.getEntityManager().contains((Object)b3) && this.getEntityManager().contains((Object)b4);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMXMTest7 failed");
        }
    }

    @Test
    public void cascadeAllMXMTest8() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAllMXMTest8");
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("1", "b1", 9);
            B b2 = new B("2", "b2", 9);
            B b3 = new B("3", "b3", 9);
            B b4 = new B("4", "b4", 9);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            logger.log(System.Logger.Level.TRACE, "New A instance");
            A a1 = new A("9", "bean9", 9, v1);
            pass = this.getInstanceStatus(a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (pass) {
            throw new Exception("cascadeAllMXMTest8 failed");
        }
    }

    @Test
    public void cascadeAllMXMTest9() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAllMXMTest9");
        boolean pass1 = true;
        boolean pass2 = true;
        boolean pass = true;
        try {
            B b1 = new B("1", "b1", 10);
            B b2 = new B("2", "b2", 10);
            B b3 = new B("3", "b3", 10);
            B b4 = new B("4", "b4", 10);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New A instance");
            A a1 = new A("10", "bean10", 10, v1);
            pass1 = !this.getEntityManager().contains((Object)b1) && !this.getEntityManager().contains((Object)b2) && !this.getEntityManager().contains((Object)b3) && !this.getEntityManager().contains((Object)b4);
            pass2 = this.getEntityManager().contains((Object)a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!(pass1 || pass2 || pass)) {
            logger.log(System.Logger.Level.ERROR, "pass=" + pass + ", pass1=" + pass1 + ", pass2=" + pass2);
            throw new Exception("cascadeAllMXMTest9 failed");
        }
    }

    @Test
    public void cascadeAllMXMTest10() throws Exception {
        boolean pass = false;
        B bRef1 = null;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("11", "a11", 11);
            B bRef = new B("11", "bean11", 11);
            this.getEntityManager().persist((Object)bRef);
            if (this.getEntityManager().contains((Object)bRef)) {
                bRef1 = this.findB("11");
                Vector<A> v1 = new Vector<A>();
                v1.add(a1);
                bRef1.setACol(v1);
                this.getEntityManager().persist((Object)bRef1);
                this.getEntityManager().flush();
                pass = this.getEntityManager().contains((Object)a1);
                logger.log(System.Logger.Level.TRACE, "try to find A");
                A a2 = this.findA("11");
                if (null != a2) {
                    logger.log(System.Logger.Level.TRACE, "A2 is not null");
                }
            }
            Vector nullCol = new Vector();
            if (bRef1 != null) {
                bRef1.setACol(nullCol);
                this.getEntityManager().merge((Object)bRef);
                a1.setBCol(nullCol);
                this.getEntityManager().merge((Object)a1);
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "bRef1 was null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception :", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("cascadeAllMXMTest10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAllMXMTest11() throws Exception {
        boolean pass = false;
        try {
            logger.log(System.Logger.Level.TRACE, "New instances");
            this.getEntityTransaction().begin();
            B b1 = new B("1", "b1", 12);
            B b2 = new B("2", "b2", 12);
            B b3 = new B("3", "b3", 12);
            B b4 = new B("4", "b4", 12);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            logger.log(System.Logger.Level.TRACE, "New A instance");
            A a1 = new A("12", "bean12", 12, v1);
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            pass = this.getEntityManager().contains((Object)a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception :", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAllMXMTest11 failed");
        }
    }

    private void createA(A a) {
        logger.log(System.Logger.Level.TRACE, "Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
    }

    private A findA(String id) {
        logger.log(System.Logger.Level.TRACE, "Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private B findB(String id) {
        logger.log(System.Logger.Level.TRACE, "Entered findB method");
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private boolean getInstanceStatus(Object o) {
        logger.log(System.Logger.Level.TRACE, "Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    private void dumpCollectionDataB(Collection c) {
        logger.log(System.Logger.Level.TRACE, "collection Data");
        logger.log(System.Logger.Level.TRACE, "---------------");
        logger.log(System.Logger.Level.TRACE, "- size=" + c.size());
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            B v = (B)i.next();
            logger.log(System.Logger.Level.TRACE, "- Element #" + elem++);
            logger.log(System.Logger.Level.TRACE, "  id=" + v.getBId() + ", name=" + v.getBName() + ", value=" + v.getBValue());
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM FKEYS_MXM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_MXM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_MXM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

