/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.parameter;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.core.criteriaapi.parameter.Client;
import ee.jakarta.tck.persistence.core.criteriaapi.parameter.Employee;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends Client {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    @Override
    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Employee"};
        return this.createDeploymentJar("jpa_core_criteriaapi_parameter2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.getEntityManager();
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupEmployee")
    @Test
    public void parameterExpressionInObjectArrayTest() throws Exception {
        boolean pass = false;
        try {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            expected.add(this.empRef[0].getId());
            expected.add(this.empRef[1].getId());
            expected.add(this.empRef[2].getId());
            expected.add(this.empRef[3].getId());
            expected.add(this.empRef[4].getId());
            this.getEntityTransaction().begin();
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            if (cquery != null) {
                Root employee = cquery.from(Employee.class);
                cquery.select((Selection)employee);
                ArrayList<Predicate> criteria = new ArrayList<Predicate>();
                ParameterExpression pe = qbuilder.parameter(Integer.class, "num");
                Object[] o = new Object[]{1, 2};
                criteria.add(pe.in(o));
                cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
                TypedQuery q = this.getEntityManager().createQuery(cquery);
                q.setParameter("num", (Object)1);
                List result = q.getResultList();
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee e : result) {
                    actual.add(e.getId());
                }
                Collections.sort(actual);
                logger.log(System.Logger.Level.TRACE, "actual" + actual);
                if (expected.equals(actual)) {
                    logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "expected: " + expected + ", actual: " + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        finally {
            this.removeTestData();
        }
        if (!pass) {
            throw new Exception("parameterExpressionInObjectArrayTest test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupEmployee")
    @Test
    public void parameterExpressionInExpressionArrayTest() throws Exception {
        boolean pass = false;
        try {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            expected.add(this.empRef[0].getId());
            expected.add(this.empRef[1].getId());
            expected.add(this.empRef[2].getId());
            expected.add(this.empRef[3].getId());
            expected.add(this.empRef[4].getId());
            this.getEntityTransaction().begin();
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            if (cquery != null) {
                Root employee = cquery.from(Employee.class);
                cquery.select((Selection)employee);
                ArrayList<Predicate> criteria = new ArrayList<Predicate>();
                ParameterExpression pe = qbuilder.parameter(String.class, "sid");
                Expression[] exp = new Expression[]{qbuilder.literal((Object)"1"), qbuilder.literal((Object)"2")};
                criteria.add(pe.in(exp));
                cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
                TypedQuery q = this.getEntityManager().createQuery(cquery);
                q.setParameter("sid", (Object)"1");
                List result = q.getResultList();
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee e : result) {
                    actual.add(e.getId());
                }
                Collections.sort(actual);
                logger.log(System.Logger.Level.TRACE, "actual" + actual);
                if (expected.equals(actual)) {
                    logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "expected: " + expected + ", actual: " + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        finally {
            this.removeTestData();
        }
        if (!pass) {
            throw new Exception("parameterExpressionInExpressionArrayTest test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupEmployee")
    @Test
    public void parameterExpressionInCollectionTest() throws Exception {
        boolean pass = false;
        try {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            expected.add(this.empRef[0].getId());
            expected.add(this.empRef[1].getId());
            expected.add(this.empRef[2].getId());
            expected.add(this.empRef[3].getId());
            expected.add(this.empRef[4].getId());
            this.getEntityTransaction().begin();
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            if (cquery != null) {
                Root employee = cquery.from(Employee.class);
                cquery.select((Selection)employee);
                ArrayList<Predicate> criteria = new ArrayList<Predicate>();
                ParameterExpression pe = qbuilder.parameter(String.class, "sid");
                ArrayList<String> col = new ArrayList<String>();
                col.add("1");
                col.add("2");
                criteria.add(pe.in(col));
                cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
                TypedQuery q = this.getEntityManager().createQuery(cquery);
                q.setParameter("sid", (Object)"1");
                List result = q.getResultList();
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee e : result) {
                    actual.add(e.getId());
                }
                Collections.sort(actual);
                logger.log(System.Logger.Level.TRACE, "actual" + actual);
                if (expected.equals(actual)) {
                    logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "expected: " + expected + ", actual: " + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        finally {
            this.removeTestData();
        }
        if (!pass) {
            throw new Exception("parameterExpressionInCollectionTest test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupEmployee")
    @Test
    public void parameterExpressionInExpressionTest() throws Exception {
        boolean pass = false;
        try {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            expected.add(this.empRef[0].getId());
            expected.add(this.empRef[1].getId());
            expected.add(this.empRef[2].getId());
            expected.add(this.empRef[3].getId());
            expected.add(this.empRef[4].getId());
            this.getEntityTransaction().begin();
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            if (cquery != null) {
                Root employee = cquery.from(Employee.class);
                cquery.select((Selection)employee);
                ArrayList<Predicate> criteria = new ArrayList<Predicate>();
                ParameterExpression pe = qbuilder.parameter(String.class, "sid");
                Expression exp = qbuilder.literal((Object)"1");
                criteria.add(pe.in(exp));
                cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
                TypedQuery q = this.getEntityManager().createQuery(cquery);
                q.setParameter("sid", (Object)"1");
                List result = q.getResultList();
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee e : result) {
                    actual.add(e.getId());
                }
                Collections.sort(actual);
                logger.log(System.Logger.Level.TRACE, "actual" + actual);
                if (expected.equals(actual)) {
                    logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "expected: " + expected + ", actual: " + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        finally {
            this.removeTestData();
        }
        if (!pass) {
            throw new Exception("parameterExpressionInExpressionTest test failed");
        }
    }
}

