/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.basic;

import ee.jakarta.tck.persistence.core.annotations.basic.Client;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends Client {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = Client.class.getPackageName() + ".";
        String[] classes = new String[]{pkgName + "A"};
        return this.createDeploymentJar("jpa_core_annotations_basic2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupData");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void DoubleOperandResultTypeTests() throws Exception {
        Object p;
        double whereValue;
        boolean pass8 = false;
        boolean pass7 = false;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing + Double operand:");
            this.getEntityTransaction().begin();
            whereValue = 1234.5;
            p = this.getEntityManager().createQuery("Select (a.basicBigDouble + 1) From A a where (a.basicBigDouble = ?1)").setParameter(1, (Object)whereValue).getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected Double type");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - Double operand:");
            this.getEntityTransaction().begin();
            whereValue = 1234.0;
            p = this.getEntityManager().createQuery("Select (a.basicBigDouble - 1) From A a where (a.basicBigDouble > ?1)").setParameter(1, (Object)whereValue).getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected Double type");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * Double operand:");
            this.getEntityTransaction().begin();
            double whereValue2 = 1235.0;
            p = this.getEntityManager().createQuery("Select (a.basicBigDouble * 1) From A a where (a.basicBigDouble < ?1)").setParameter(1, (Object)whereValue2).getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected Double type");
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing / Double operand:");
            this.getEntityTransaction().begin();
            double whereValue3 = 1235.0;
            p = this.getEntityManager().createQuery("Select (a.basicBigDouble / 1) From A a where (a.basicBigDouble <> ?1)").setParameter(1, (Object)whereValue3).getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected Double type");
                pass4 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing + double operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicDouble + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected double type");
                pass5 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - double operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicDouble - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected double type");
                pass6 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * double operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicDouble * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected double type");
                pass7 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing / double operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicDouble / 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected double type");
                pass8 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8)) {
            throw new Exception("DoubleOperandResultTypeTests failed");
        }
    }

    @Test
    public void FloatOperandResultTypeTests() throws Exception {
        Object p;
        boolean pass8 = false;
        boolean pass7 = false;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing + Float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigFloat + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected Float type");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - Float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigFloat - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected Float type");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * Float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigFloat * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected Float type");
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing / Float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigFloat / 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected Float type");
                pass4 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing + float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicFloat + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected float type");
                pass5 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicFloat - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected float type");
                pass6 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicFloat * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected float type");
                pass7 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing / float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigFloat / 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected Float type");
                pass8 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8)) {
            throw new Exception("FloatOperandResultTypeTests failed");
        }
    }

    @Test
    public void BigDecimalOperandResultTypeTests() throws Exception {
        Object p;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing + BigDecimal operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigDecimal + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigDecimal) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigDecimal type");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigDecimal:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - BigDecimal operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigDecimal - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigDecimal) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigDecimal type");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigDecimal:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * BigDecimal operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigDecimal * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigDecimal) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigDecimal type");
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigDecimal:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing / BigDecimal operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigDecimal / 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigDecimal) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigDecimal type");
                pass4 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigDecimal:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("BigDecimalOperandResultTypeTests failed");
        }
    }

    @Test
    public void BigIntegerOperandResultTypeTests() throws Exception {
        Object p;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing + BigInteger operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigInteger + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigInteger) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigInteger type");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigInteger:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - BigInteger operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigInteger - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigInteger) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigInteger type");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigInteger:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * BigInteger operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigInteger * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigInteger) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigInteger type");
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigInteger:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("BigIntegerOperandResultTypeTests failed");
        }
    }

    @Test
    public void LongOperandResultTypeTests() throws Exception {
        Object p;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing + Long operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigLong + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Long) {
                logger.log(System.Logger.Level.TRACE, "Received expected Long type");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Long:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - Long operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigLong - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Long) {
                logger.log(System.Logger.Level.TRACE, "Received expected Long type");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Long:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * Long operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigLong * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Long) {
                logger.log(System.Logger.Level.TRACE, "Received expected Long type");
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Long:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing + long operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicLong + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Long) {
                logger.log(System.Logger.Level.TRACE, "Received expected long type");
                pass4 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type long:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - long operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicLong - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Long) {
                logger.log(System.Logger.Level.TRACE, "Received expected long type");
                pass5 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type long:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * long operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicLong * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Long) {
                logger.log(System.Logger.Level.TRACE, "Received expected long type");
                pass6 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type long:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6)) {
            throw new Exception("LongOperandResultTypeTests failed");
        }
    }

    @Test
    public void ShortOperandResultTypeTests() throws Exception {
        Object p;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing + Short operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigShort + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Integer) {
                logger.log(System.Logger.Level.TRACE, "Received expected Integer type");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Integer:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - Short operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigShort - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Integer) {
                logger.log(System.Logger.Level.TRACE, "Received expected Integer type");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Integer:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * Short operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigShort * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Integer) {
                logger.log(System.Logger.Level.TRACE, "Received expected Integer type");
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Integer:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing + short operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicShort + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Integer) {
                logger.log(System.Logger.Level.TRACE, "Received expected Integer type");
                pass4 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Integer:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - short operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicShort - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Integer) {
                logger.log(System.Logger.Level.TRACE, "Received expected Integer type");
                pass5 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Integer:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * short operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicShort * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Integer) {
                logger.log(System.Logger.Level.TRACE, "Received expected Integer type");
                pass6 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Integer:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6)) {
            throw new Exception("ShortOperandResultTypeTests failed");
        }
    }
}

