/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.access.field;

import ee.jakarta.tck.persistence.core.annotations.access.field.Client;
import ee.jakarta.tck.persistence.core.annotations.access.field.DataTypes;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends Client {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = Client2.class.getPackageName() + ".";
        String[] classes = new String[]{pkgName + "DataTypes", pkgName + "DataTypes2", "ee.jakarta.tck.persistence.core.types.common.Grade"};
        return this.createDeploymentJar("jpa_core_annotations_access_field2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup2");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData2();
            logger.log(System.Logger.Level.TRACE, "Done creating test data");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void createTestData2() {
        logger.log(System.Logger.Level.TRACE, "createTestData2");
        try {
            this.getEntityTransaction().begin();
            this.d1 = new DataTypes(1, 300);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mixedAccessTest() throws Exception {
        boolean pass = false;
        int newInt = 500;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getIntData2() == 300) {
                logger.log(System.Logger.Level.INFO, "Int value after find=" + this.d1.getIntData2());
                this.d1.setIntData2(500);
                logger.log(System.Logger.Level.INFO, "Int value after set=" + this.d1.getIntData2());
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                this.clearCache();
                this.d1 = null;
                this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
                if (this.d1.getIntData2() == 500) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "Received expected value:" + this.d1.getIntData2());
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected:500, actual:" + this.d1.getIntData2());
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "find returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("mixedAccessTest failed");
        }
    }
}

