/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.access.field;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.access.field.DataTypes;
import ee.jakarta.tck.persistence.core.annotations.access.field.DataTypes2;
import java.util.Date;
import org.junit.jupiter.api.AfterEach;

public class Client
extends PMClientBase {
    protected DataTypes d1;
    protected DataTypes2 d2;
    final Date dateId = this.getPKDate(2006, 4, 15);
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    protected void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "isActive:" + this.getEntityTransaction().isActive());
            this.getEntityManager().createNativeQuery("Delete from DATATYPES").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DATATYPES2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

