/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.KflPlainText;
import com.sun.javatest.report.ReportFormat;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.report.TestResultsByFileComparator;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.TextWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class PlainTextReport
implements ReportFormat {
    private static final String[] files = new String[]{"summary.txt"};
    private static final int SMRY_TXT = 0;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(PlainTextReport.class);

    public static String[] getReportFilenames() {
        return files;
    }

    @Override
    public ReportFormat.ReportLink write(ReportSettings s, File dir) throws IOException {
        TestResultTable resultTable = s.getInterview().getWorkDirectory().getTestResultTable();
        File[] initFiles = s.getInitialFiles();
        TreeSet<TestResult> tests = new TreeSet<TestResult>(new TestResultsByFileComparator());
        int width = 0;
        Iterator<TestResult> iter = null;
        try {
            iter = initFiles == null ? resultTable.getIterator(s.filter) : resultTable.getIterator(initFiles, s.filter);
        }
        catch (TestResultTable.Fault f) {
            throw new JavaTestError(i18n.getString("report.testResult.err"));
        }
        while (iter.hasNext()) {
            TestResult tr = (TestResult)iter.next();
            width = Math.max(width, tr.getTestName().length());
            tests.add(tr);
        }
        TextWriter out = new TextWriter(this.openWriter(dir, files[0]));
        for (TestResult tr : tests) {
            String u = tr.getTestName();
            out.print(u);
            for (int sp = u.length(); sp < width; ++sp) {
                out.print(" ");
            }
            out.print("  ");
            out.println(tr.getStatus().toString());
        }
        out.close();
        KflPlainText kfl = new KflPlainText(s);
        kfl.write(dir, s.isKflTestCasesEnabled());
        return new ReportFormat.ReportLink(i18n.getString("index.plaintype.txt"), this.getBaseDirName(), i18n.getString("index.desc.txt"), dir);
    }

    @Override
    public String getReportID() {
        return "pt";
    }

    @Override
    public String getBaseDirName() {
        return "text";
    }

    @Override
    public String getTypeName() {
        return "txt";
    }

    @Override
    public boolean acceptSettings(ReportSettings s) {
        return s.isPlainEnabled();
    }

    @Override
    public List<ReportFormat> getSubReports() {
        return Collections.emptyList();
    }

    private Writer openWriter(File reportDir, String filename) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(reportDir, filename)), StandardCharsets.UTF_8));
    }
}

