/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.se.cache.xml.all;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.DriverManagerConnection;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.se.cache.xml.all.Order;
import jakarta.persistence.Cache;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class Client
extends PMClientBase {
    Properties jpaprops = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.jpaprops = p;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", (Throwable)e);
        }
    }

    public void containsTest() throws EETest.Fault {
        boolean pass;
        block8: {
            pass = false;
            if (this.cachingSupported) {
                try {
                    EntityManager em2 = this.getEntityManager();
                    EntityTransaction et = this.getEntityTransaction();
                    et.begin();
                    Order order = new Order(1, 101);
                    em2.persist((Object)order);
                    TestUtil.logTrace((String)("persisted order " + order));
                    em2.flush();
                    et.commit();
                    EntityManagerFactory emf = this.getEntityManagerFactory();
                    Cache cache = emf.getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (b) {
                            TestUtil.logTrace((String)("Cache returned: " + b + ", therefore cache contains order " + order));
                            pass = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b + ", therefore cache does not contain order " + order));
                        }
                        break block8;
                    }
                    TestUtil.logErr((String)"Cache returned was null");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"Cache not supported, bypassing test");
                pass = true;
            }
        }
        if (!pass) {
            throw new EETest.Fault("containsTest failed");
        }
    }

    public void cacheStoreModeBYPASSTest() throws EETest.Fault {
        boolean pass1;
        boolean pass2;
        boolean pass3;
        block14: {
            pass3 = false;
            pass2 = false;
            pass1 = false;
            if (this.cachingSupported) {
                try {
                    TestUtil.logTrace((String)"Persist an order");
                    this.getEntityTransaction().begin();
                    this.getEntityManager().setProperty("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
                    Order order = new Order(1, 101);
                    this.getEntityManager().persist((Object)order);
                    TestUtil.logTrace((String)("persisted order " + order));
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    TestUtil.logTrace((String)"Verify the order persisted successfully, but it is not in the cache");
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (!b) {
                            TestUtil.logTrace((String)("Cache returned: " + b + ", therefore cache does not contain order " + order));
                            pass1 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b + ", therefore cache does contain order " + order));
                        }
                    } else {
                        TestUtil.logErr((String)"Cache returned was null");
                    }
                    int[] result = this.selectDataVIAJDBC(this.jpaprops, 1);
                    Order order2 = new Order(result[0], result[1]);
                    if (order.equals(order2)) {
                        TestUtil.logTrace((String)"Entity was persisted correctly");
                        pass2 = true;
                    } else {
                        TestUtil.logErr((String)("Entity was not persisted correctly - expected:" + order + ", actual:" + order2));
                    }
                    TestUtil.logTrace((String)"Find the order and verify it is not loaded into the cache");
                    this.getEntityManager().find(Order.class, (Object)1);
                    cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (!b) {
                            TestUtil.logTrace((String)("Cache returned: " + b + ", therefore cache does not contain order " + order));
                            pass3 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b + ", therefore cache does contain order " + order));
                        }
                        break block14;
                    }
                    TestUtil.logErr((String)"Cache returned was null");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"Cache not supported, bypassing test");
                pass3 = true;
                pass2 = true;
                pass1 = true;
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("cacheStoreModeBYPASSTest failed");
        }
    }

    public void cacheStoreModeUSETest() throws EETest.Fault {
        boolean pass1;
        boolean pass2;
        boolean pass3;
        block14: {
            pass3 = false;
            pass2 = false;
            pass1 = false;
            if (this.cachingSupported) {
                try {
                    TestUtil.logTrace((String)"Persist an order");
                    this.getEntityTransaction().begin();
                    this.getEntityManager().setProperty("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.USE);
                    Order order = new Order(1, 101);
                    this.getEntityManager().persist((Object)order);
                    TestUtil.logTrace((String)("persisted order " + order));
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    TestUtil.logTrace((String)"Verify the order persisted successfully, and it is in the cache");
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (b) {
                            TestUtil.logTrace((String)("Cache returned: " + b + ", therefore cache does contain order " + order));
                            pass1 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b + ", therefore cache does not contain order " + order));
                        }
                    } else {
                        TestUtil.logErr((String)"Cache returned was null");
                    }
                    int[] result = this.selectDataVIAJDBC(this.jpaprops, 1);
                    Order order2 = new Order(result[0], result[1]);
                    if (order.equals(order2)) {
                        TestUtil.logTrace((String)"Entity was persisted correctly");
                        pass2 = true;
                    } else {
                        TestUtil.logErr((String)("Entity was not persisted correctly - expected:" + order + ", actual:" + order2));
                    }
                    TestUtil.logTrace((String)"Find the order and verify it is loaded into the cache");
                    this.getEntityManager().find(Order.class, (Object)1);
                    cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (b) {
                            TestUtil.logTrace((String)("Cache returned: " + b + ", therefore cache does contain order " + order));
                            pass3 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b + ", therefore cache does not contain order " + order));
                        }
                        break block14;
                    }
                    TestUtil.logErr((String)"Cache returned was null");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"Cache not supported, bypassing test");
                pass3 = true;
                pass2 = true;
                pass1 = true;
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("cacheStoreModeUSETest failed");
        }
    }

    public void cacheStoreModeREFRESHTest() throws EETest.Fault {
        boolean pass1;
        boolean pass2;
        boolean pass3;
        block14: {
            pass3 = false;
            pass2 = false;
            pass1 = false;
            if (this.cachingSupported) {
                try {
                    TestUtil.logTrace((String)"Persist an order");
                    this.getEntityTransaction().begin();
                    this.getEntityManager().setProperty("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.REFRESH);
                    Order order = new Order(1, 101);
                    this.getEntityManager().persist((Object)order);
                    TestUtil.logTrace((String)("persisted order " + order));
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    TestUtil.logTrace((String)"Verify the order persisted successfully, and it is in the cache");
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (b) {
                            TestUtil.logTrace((String)("Cache returned: " + b + ", therefore cache does contain order " + order));
                            pass1 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b + ", therefore cache does not contain order " + order));
                        }
                    } else {
                        TestUtil.logErr((String)"Cache returned was null");
                    }
                    int[] result = this.selectDataVIAJDBC(this.jpaprops, 1);
                    Order order2 = new Order(result[0], result[1]);
                    if (order.equals(order2)) {
                        TestUtil.logTrace((String)"Entity was persisted correctly");
                        pass2 = true;
                    } else {
                        TestUtil.logErr((String)("Entity was not persisted correctly - expected:" + order + ", actual:" + order2));
                    }
                    TestUtil.logTrace((String)"Find the order and verify it is loaded into the cache");
                    this.getEntityManager().find(Order.class, (Object)1);
                    cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (b) {
                            TestUtil.logTrace((String)("Cache returned: " + b + ", therefore cache does contain order " + order));
                            pass3 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b + ", therefore cache does not contain order " + order));
                        }
                        break block14;
                    }
                    TestUtil.logErr((String)"Cache returned was null");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"Cache not supported, bypassing test");
                pass3 = true;
                pass2 = true;
                pass1 = true;
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("cacheStoreModeREFRESHTest failed");
        }
    }

    public void cacheRetrieveModeBYPASSTest() throws EETest.Fault {
        boolean pass1;
        boolean pass2;
        block12: {
            pass2 = false;
            pass1 = false;
            if (this.cachingSupported) {
                try {
                    TestUtil.logTrace((String)"Persist an order");
                    this.createDataVIAJDBC(this.jpaprops);
                    TestUtil.logTrace((String)"Verify order is not in Cache before executing find");
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (!b) {
                            TestUtil.logTrace((String)("Cache returned: " + b + ", therefore cache does not contain order "));
                            pass1 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b + ", therefore cache does contain order "));
                        }
                    } else {
                        TestUtil.logErr((String)"Cache returned was null");
                    }
                    TestUtil.logTrace((String)"Find the order and verify it is not loaded into the cache");
                    this.getEntityManager().setProperty("jakarta.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.BYPASS);
                    this.getEntityManager().setProperty("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
                    Order order = (Order)this.getEntityManager().find(Order.class, (Object)1);
                    cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (!b) {
                            TestUtil.logTrace((String)("Cache returned: " + b + ", therefore cache does not contain order " + order));
                            pass2 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b + ", therefore cache does contain order " + order));
                        }
                        break block12;
                    }
                    TestUtil.logErr((String)"Cache returned was null");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"Cache not supported, bypassing test");
                pass2 = true;
                pass1 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("cacheRetrieveModeBYPASSTest failed");
        }
    }

    public void cacheRetrieveModeUSETest() throws EETest.Fault {
        boolean pass1;
        boolean pass2;
        block12: {
            pass2 = false;
            pass1 = false;
            if (this.cachingSupported) {
                try {
                    TestUtil.logTrace((String)"Persist an order");
                    this.createDataVIAJDBC(this.jpaprops);
                    TestUtil.logTrace((String)"Verify order is not in Cache before executing find");
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (!b) {
                            TestUtil.logTrace((String)("Cache returned: " + b + ", therefore cache does not contain order "));
                            pass1 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b + ", therefore cache does contain order "));
                        }
                    } else {
                        TestUtil.logErr((String)"Cache returned was null");
                    }
                    TestUtil.logTrace((String)"Find the order and verify it is not loaded into the cache");
                    this.getEntityManager().setProperty("jakarta.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.USE);
                    this.getEntityManager().setProperty("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
                    Order order = (Order)this.getEntityManager().find(Order.class, (Object)1);
                    cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        boolean b = cache.contains(Order.class, (Object)1);
                        if (!b) {
                            TestUtil.logTrace((String)("Cache returned: " + b + ", therefore cache does not contain order " + order));
                            pass2 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b + ", therefore cache does contain order " + order));
                        }
                        break block12;
                    }
                    TestUtil.logErr((String)"Cache returned was null");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"Cache not supported, bypassing test");
                pass2 = true;
                pass1 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("cacheRetrieveModeUSETest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] selectDataVIAJDBC(Properties p, int id) {
        int[] params;
        block20: {
            params = new int[2];
            this.displayMap(p);
            Connection conn = null;
            try {
                DriverManagerConnection dmCon = new DriverManagerConnection();
                conn = dmCon.getConnection(p);
                String selectString = p.getProperty("Select_Jpa_Purchase_Order", "");
                TestUtil.logTrace((String)("ASDF:" + selectString));
                PreparedStatement pStmt = conn.prepareStatement(selectString);
                pStmt.setInt(1, id);
                TestUtil.logTrace((String)("SQL to be executed:" + pStmt.toString()));
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) {
                    params[0] = rs.getInt(1);
                    params[1] = rs.getInt(2);
                    break block20;
                }
                throw new SQLException("Data not found");
            }
            catch (SQLException sqlex) {
                TestUtil.logErr((String)"Received SQLException", (Throwable)sqlex);
            }
            catch (ClassNotFoundException cnfe) {
                TestUtil.logErr((String)"Received ClassNotFoundException", (Throwable)cnfe);
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Received Exception", (Throwable)ex);
            }
            finally {
                try {
                    conn.close();
                }
                catch (Exception sqlex) {}
            }
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDataVIAJDBC(Properties p) {
        Connection conn = null;
        try {
            DriverManagerConnection dmCon = new DriverManagerConnection();
            conn = dmCon.getConnection(p);
            String insertString = p.getProperty("Insert_Jpa_Purchase_Order", "");
            PreparedStatement pStmt = conn.prepareStatement(insertString);
            pStmt.setInt(1, 1);
            pStmt.setInt(2, 101);
            TestUtil.logTrace((String)("SQL to be executed:" + pStmt.toString()));
            int rows = pStmt.executeUpdate();
            TestUtil.logTrace((String)("Row inserted:" + rows));
        }
        catch (SQLException sqlex) {
            TestUtil.logErr((String)"Received SQLException", (Throwable)sqlex);
        }
        catch (ClassNotFoundException cnfe) {
            TestUtil.logErr((String)"Received ClassNotFoundException", (Throwable)cnfe);
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received Exception", (Throwable)ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception sqlex) {}
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

