/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class PrefixMap<V>
implements Map<String, V> {
    private Map<String, V> map;
    private String prefix;

    public PrefixMap(Map<String, V> map, String prefix) {
        this.map = map;
        this.prefix = prefix + ".";
    }

    @Override
    public void clear() {
        Iterator<String> i = this.map.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next();
            if (!key.startsWith(this.prefix)) continue;
            i.remove();
        }
    }

    public String getPrefix() {
        if (this.prefix.length() > 1) {
            return this.prefix.substring(0, this.prefix.length() - 1);
        }
        return "";
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(this.prefix + key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<String, V> e : this.map.entrySet()) {
            String key = e.getKey();
            if (!key.startsWith(this.prefix) || !e.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        HashMap<String, V> m = new HashMap<String, V>();
        for (Map.Entry<String, V> e : this.map.entrySet()) {
            String key = e.getKey();
            if (!key.startsWith(this.prefix)) continue;
            m.put(key.substring(this.prefix.length()), e.getValue());
        }
        return m.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.map.get(this.prefix + key);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode() + this.prefix.hashCode();
    }

    @Override
    public boolean isEmpty() {
        for (String key : this.map.keySet()) {
            if (!key.startsWith(this.prefix)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> s = new HashSet<String>();
        for (String key : this.map.keySet()) {
            if (!key.startsWith(this.prefix)) continue;
            s.add(key.substring(this.prefix.length()));
        }
        return s;
    }

    @Override
    public V put(String key, V value) {
        return this.map.put(this.prefix + key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> t) {
        for (Map.Entry<String, V> e : t.entrySet()) {
            String key = e.getKey();
            this.put(key, e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(this.prefix + key);
    }

    @Override
    public int size() {
        int n = 0;
        for (String key : this.map.keySet()) {
            if (!key.startsWith(this.prefix)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Collection<V> values() {
        Vector<V> c = new Vector<V>();
        for (Map.Entry<String, V> e : this.map.entrySet()) {
            String key = e.getKey();
            if (!key.startsWith(this.prefix)) continue;
            c.add(e.getValue());
        }
        return c;
    }
}

