/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;

public class BackupUtil {
    public static int backupFile(File file, int maxBackups) {
        boolean renamed;
        int index;
        if (!file.exists()) {
            return -1;
        }
        if (file.isDirectory()) {
            return -1;
        }
        String filename = file.getPath();
        File dir = file.getParentFile();
        Object[] list = dir.list();
        if (list == null) {
            return -1;
        }
        String prefix = file.getName() + "~";
        String suffix = "~";
        boolean maxBackupIndex = false;
        Vector<Integer> backups = new Vector<Integer>();
        Arrays.sort(list);
        for (int i = list.length - 1; i >= 0; --i) {
            String mid;
            Object s = list[i];
            if (((String)s).length() <= prefix.length() + suffix.length() || !((String)s).startsWith(prefix) || !((String)s).endsWith(suffix) || !BackupUtil.checkForInteger(mid = ((String)s).substring(prefix.length(), ((String)s).length() - suffix.length()))) continue;
            index = Integer.parseInt(mid);
            File backuppedFile = new File(filename + "~" + index + "~");
            renamed = backuppedFile.renameTo(new File(filename + "~" + ++index + "~"));
            if (!renamed) {
                return -1;
            }
            backups.add(index);
        }
        renamed = file.renameTo(new File(filename + "~" + 1 + "~"));
        if (!renamed) {
            return -1;
        }
        backups.add(1);
        int maxIndex = 0;
        for (Integer backup : backups) {
            index = backup;
            int n = maxIndex = index > maxIndex ? index : maxIndex;
            if (index <= maxBackups) continue;
            File oldBackup = new File(filename + "~" + backup + "~");
            oldBackup.delete();
        }
        return maxIndex > maxBackups ? maxBackups : maxIndex;
    }

    public static void backupDir(File file, int maxBackups) {
        boolean renamed;
        if (!file.isDirectory()) {
            return;
        }
        if (file.list().length == 0) {
            return;
        }
        String filename = file.getPath();
        File dir = file.getParentFile();
        Object[] list = dir.list();
        String prefix = file.getName() + "~";
        String suffix = "~";
        boolean maxBackupIndex = false;
        Vector<Integer> backups = new Vector<Integer>();
        Arrays.sort(list);
        for (int i = list.length - 1; i >= 0; --i) {
            String mid;
            Object s = list[i];
            if (((String)s).length() <= prefix.length() + suffix.length() || !((String)s).startsWith(prefix) || !((String)s).endsWith(suffix) || !BackupUtil.checkForInteger(mid = ((String)s).substring(prefix.length(), ((String)s).length() - suffix.length()))) continue;
            int index = Integer.parseInt(mid);
            File backuppedFile = new File(filename + "~" + index + "~");
            renamed = backuppedFile.renameTo(new File(filename + "~" + ++index + "~"));
            if (!renamed) {
                return;
            }
            backups.add(index);
        }
        renamed = file.renameTo(new File(filename + "~" + 1 + "~"));
        if (!renamed) {
            return;
        }
        for (Integer backup : backups) {
            int index = backup;
            if (index <= maxBackups) continue;
            File oldBackup = new File(filename + "~" + backup + "~");
            BackupUtil.deleteDir(oldBackup);
        }
    }

    public static void backupAllSubdirs(File dir, int maxBackups) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files.length == 0) {
            return;
        }
        HashSet<Integer> layers = new HashSet<Integer>();
        String suffix = "~";
        for (File file : files) {
            if (!file.isDirectory()) continue;
            String fileName = file.getName();
            if (!fileName.endsWith(suffix)) {
                layers.add(0);
                continue;
            }
            String prefix = fileName.substring(0, fileName.lastIndexOf(suffix));
            String numb = prefix.substring(prefix.lastIndexOf(suffix) + 1, prefix.length());
            if (!BackupUtil.checkForInteger(numb)) continue;
            layers.add(Integer.parseInt(numb));
        }
        Object[] larray = layers.toArray();
        Arrays.sort(larray);
        for (int i = larray.length - 1; i >= 0; --i) {
            BackupUtil.backupLayer(dir, (Integer)larray[i], maxBackups);
        }
    }

    private static void backupLayer(File parentDir, Integer numb, int maxBackups) {
        block6: {
            int number = numb;
            String suffix = number == 0 ? "" : "~" + number + "~";
            String newSuffix = "~" + (number + 1) + "~";
            LayerFilter filter = new LayerFilter(suffix);
            File[] layer = parentDir.listFiles(filter);
            if (layer == null) break block6;
            if (number >= maxBackups) {
                for (File aLayer : layer) {
                    BackupUtil.deleteDir(aLayer);
                }
            } else {
                for (File aLayer : layer) {
                    try {
                        String newName = number != 0 ? aLayer.getCanonicalPath().replaceAll(suffix, newSuffix) : aLayer.getCanonicalPath() + newSuffix;
                        aLayer.renameTo(new File(newName));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static void backupContents(File dir, int maxBackups) {
        String[] list;
        if (!dir.isDirectory()) {
            return;
        }
        for (String aList : list = dir.list()) {
            File f = new File(dir, aList);
            if (f.isDirectory() || f.getPath().endsWith("~")) continue;
            BackupUtil.backupFile(f, maxBackups);
        }
    }

    public static boolean checkForInteger(String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean deleteDir(File dir) {
        boolean deleted = dir.delete();
        if (!deleted) {
            String[] list = dir.list();
            if (list != null) {
                for (String aList : list) {
                    BackupUtil.deleteDir(new File(dir, aList));
                }
            }
            deleted = dir.delete();
        }
        return deleted;
    }

    private static class LayerFilter
    implements FileFilter {
        private String suffix;

        public LayerFilter(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File file) {
            if (!file.isDirectory()) {
                return false;
            }
            if (this.suffix.isEmpty()) {
                return !file.getName().endsWith("~");
            }
            return file.getName().endsWith(this.suffix);
        }
    }
}

