/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.FileOpener;
import com.sun.javatest.tool.FocusMonitor;
import com.sun.javatest.tool.HelpMenu;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.ContextHelpManager;
import com.sun.javatest.tool.jthelp.HelpBroker;
import com.sun.javatest.util.ExitCount;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.PrefixMap;
import com.sun.javatest.util.StringArray;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

abstract class DeskView {
    static final String CLOSE = "close";
    private static final int MENU_INSERT_POINT = 4;
    private static final String EXIT = "exit";
    private static final String PREFS = "prefs";
    private static final String HISTORY = "history";
    private static final String SEPARATOR = null;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(DeskView.class);
    private static Collection<JFrame> allFrames = new Vector<JFrame>();
    private static int frameIndex;
    private static FocusMonitor focusMonitor;
    protected final UIFactory uif;
    private Desktop desktop;

    protected DeskView(Desktop desktop) {
        this.desktop = desktop;
        this.uif = new UIFactory(this.getClass(), desktop.getHelpBroker());
    }

    public static Rectangle getDefaultBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle mwb = ge.getMaximumWindowBounds();
        int w = Math.min(mwb.width, Math.max(640, mwb.width * 3 / 4));
        int h = Math.min(mwb.height, Math.max(480, mwb.height * 3 / 4));
        int x = ge.getCenterPoint().x - w / 2;
        int y = ge.getCenterPoint().y - h / 2;
        return new Rectangle(x, y, w, h);
    }

    protected static void saveBounds(Component c, Map<String, String> m) {
        Rectangle r = c.getBounds();
        m.put("x", String.valueOf(r.x));
        m.put("y", String.valueOf(r.y));
        m.put("w", String.valueOf(r.width));
        m.put("h", String.valueOf(r.height));
    }

    protected static void restoreBounds(Component c, Map<String, String> m) {
        try {
            String xs = m.get("x");
            String ys = m.get("y");
            String ws = m.get("w");
            String hs = m.get("h");
            if (xs != null && ys != null && ws != null && hs != null) {
                Rectangle restored = new Rectangle(Integer.parseInt(xs), Integer.parseInt(ys), Integer.parseInt(ws), Integer.parseInt(hs));
                restored = DeskView.getScreenBounds().intersection(restored);
                if (!restored.isEmpty()) {
                    c.setBounds(restored);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static Rectangle getScreenBounds() {
        GraphicsDevice[] gs;
        Rectangle result = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gs = ge.getScreenDevices()) {
            GraphicsConfiguration[] gc;
            for (GraphicsConfiguration aGc : gc = gd.getConfigurations()) {
                result = result.union(aGc.getBounds());
            }
        }
        return result;
    }

    public Desktop getDesktop() {
        return this.desktop;
    }

    public void dispose() {
        Tool[] tools;
        for (Tool tool : tools = this.getTools()) {
            tool.dispose();
        }
    }

    public abstract boolean isVisible();

    public abstract void setVisible(boolean var1);

    public abstract boolean isEmpty();

    public abstract Tool[] getTools();

    public abstract void addTool(Tool var1);

    public abstract void removeTool(Tool var1);

    public abstract Tool getSelectedTool();

    public abstract void setSelectedTool(Tool var1);

    public abstract int getStyle();

    public abstract JFrame[] getFrames();

    public Component getDialogParent() {
        JFrame[] frames = this.getFrames();
        if (frames == null || frames.length == 0) {
            return null;
        }
        return frames[0].getContentPane();
    }

    public abstract Rectangle getBounds();

    protected JFrame createFrame(MenuListener winMenuListener, String uiKey) {
        return this.createFrame(winMenuListener, null, uiKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JFrame createFrame(MenuListener winMenuListener, Action fileCloseAction, String uiKey) {
        ToolManager[] mgrs;
        JFrame frame = new JFrame();
        frame.setName(uiKey + ":" + frameIndex++);
        frame.setTitle(this.uif.getI18NString("dt.title.txt"));
        frame.setIconImage(this.uif.createImage("images/jticon.gif"));
        this.uif.setAccessibleInfo(frame, uiKey);
        JRootPane root = frame.getRootPane();
        root.setName("root");
        this.uif.setAccessibleInfo(root, uiKey);
        JMenuBar mb = this.uif.createMenuBar("dt.menuBar");
        JMenu fileMenu = this.uif.createMenu("dt.file");
        fileMenu.addMenuListener(new FileMenuListener(fileCloseAction));
        mb.add(fileMenu);
        JMenu toolMenu = this.uif.createMenu("dt.tasks");
        for (ToolManager mgr : mgrs = this.desktop.getToolManagers()) {
            Action[] actions = mgr.getWindowOpenMenuActions();
            if (actions == null) continue;
            for (Action action : actions) {
                toolMenu.add(action);
            }
        }
        mb.add(toolMenu);
        JMenu winMenu = this.uif.createMenu("dt.windows");
        winMenu.addMenuListener(winMenuListener);
        mb.add(winMenu);
        mb.add(this.uif.createHorizontalGlue("dt.pad"));
        HelpMenu helpMenu = new HelpMenu(frame, this.desktop, this.uif);
        mb.add(helpMenu);
        frame.setJMenuBar(mb);
        HelpBroker helpBroker = this.desktop.getHelpBroker();
        JRootPane rootPane = frame.getRootPane();
        KeyStroke keystroke = KeyStroke.getKeyStroke(112, 0, false);
        rootPane.registerKeyboardAction(e -> helpBroker.displayCurrentID(ContextHelpManager.getHelpIDString(this.getSelectedTool())), keystroke, 1);
        Desktop.addPreferredSizeDebugListener(frame);
        if (focusMonitor != null) {
            focusMonitor.monitor(frame);
        }
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent e) {
                JFrame frame = (JFrame)e.getSource();
                Collection collection = allFrames;
                synchronized (collection) {
                    if (allFrames.remove(frame) && allFrames.isEmpty()) {
                        EventQueue.invokeLater(ExitCount::dec);
                    }
                }
            }
        });
        Collection<JFrame> collection = allFrames;
        synchronized (collection) {
            allFrames.add(frame);
            if (allFrames.size() == 1) {
                ExitCount.inc();
            }
        }
        return frame;
    }

    protected void addToolMenuItemsToFrameMenuBar(JFrame frame, Tool tool) {
        JMenuBar toolMenuBar;
        JMenuBar frameMenuBar = frame.getJMenuBar();
        Tool curr = (Tool)frameMenuBar.getClientProperty(this.getClass());
        if (tool == curr) {
            return;
        }
        if (curr != null) {
            this.removeToolMenuItemsFromFrameMenuBar(frame, curr);
        }
        if ((toolMenuBar = tool.getMenuBar()) == null) {
            return;
        }
        for (int i = 0; i < toolMenuBar.getMenuCount(); ++i) {
            JMenu toolMenu = toolMenuBar.getMenu(i);
            if (toolMenu == null) continue;
            int toolMenuSize = toolMenu.getMenuComponentCount();
            JMenu frameMenu = this.findMenu(frameMenuBar, toolMenu.getText());
            if (frameMenu == null) {
                frameMenu = new JMenu(toolMenu.getText());
                frameMenu.setName(toolMenu.getName());
                frameMenu.setMnemonic(toolMenu.getMnemonic());
                AccessibleContext bc = frameMenu.getAccessibleContext();
                AccessibleContext tc = toolMenu.getAccessibleContext();
                bc.setAccessibleName(tc.getAccessibleName());
                bc.setAccessibleDescription(tc.getAccessibleDescription());
                this.copyMenuListeners(toolMenu, frameMenu);
                for (int j = 0; j < toolMenuSize; ++j) {
                    frameMenu.add(toolMenu.getMenuComponent(0));
                }
                frameMenuBar.add((Component)frameMenu, frameMenuBar.getMenuCount() - 4);
            } else {
                for (int j = 0; j < toolMenuSize; ++j) {
                    frameMenu.add(toolMenu.getMenuComponent(0), j);
                }
                frameMenu.insertSeparator(toolMenuSize);
            }
            frameMenu.putClientProperty(this.getClass(), toolMenuSize);
        }
        frameMenuBar.putClientProperty(this.getClass(), tool);
    }

    private void removeToolMenuItemsFromFrameMenuBar(JFrame frame) {
        JMenuBar frameMenuBar = frame.getJMenuBar();
        Tool tool = (Tool)frameMenuBar.getClientProperty(this.getClass());
        if (tool == null) {
            return;
        }
        this.removeToolMenuItemsFromFrameMenuBar(frame, tool);
    }

    protected void removeToolMenuItemsFromFrameMenuBar(JFrame frame, Tool tool) {
        JMenuBar frameMenuBar = frame.getJMenuBar();
        JMenuBar toolMenuBar = tool.getMenuBar();
        for (int i = 0; i < toolMenuBar.getMenuCount(); ++i) {
            JMenu toolMenu = toolMenuBar.getMenu(i);
            if (toolMenu == null) continue;
            JMenu frameMenu = this.findMenu(frameMenuBar, toolMenu.getText());
            int toolMenuSize = (Integer)frameMenu.getClientProperty(this.getClass());
            for (int j = 0; j < toolMenuSize; ++j) {
                toolMenu.add(frameMenu.getMenuComponent(0));
            }
            if (frameMenu.getItemCount() == 0) {
                frameMenuBar.remove(frameMenu);
                continue;
            }
            frameMenu.remove(0);
            frameMenu.putClientProperty(this.getClass(), null);
        }
        frameMenuBar.putClientProperty(this.getClass(), null);
    }

    protected JMenu getWindowOpenMenu() {
        ToolManager[] mgrs;
        JMenu menu = this.uif.createMenu("dt.windows.open");
        for (ToolManager mgr : mgrs = this.desktop.getToolManagers()) {
            Action[] actions = mgr.getWindowOpenMenuActions();
            if (actions == null) continue;
            for (Action action : actions) {
                menu.add(action);
            }
        }
        return menu;
    }

    private void copyMenuListeners(JMenu src, JMenu dst) {
        MenuListener[] ll;
        for (MenuListener aLl : ll = (MenuListener[])src.getListeners(MenuListener.class)) {
            dst.addMenuListener(aLl);
        }
    }

    private JMenu findMenu(JMenuBar mb, String text) {
        for (int i = 0; i < mb.getMenuCount(); ++i) {
            JMenu m = mb.getMenu(i);
            if (m == null || !m.getText().equals(text)) continue;
            return m;
        }
        return null;
    }

    public abstract Container createDialog(Tool var1, String var2, String var3, JMenuBar var4, Container var5, Rectangle var6, int var7);

    public abstract boolean isToolOwnerForDialog(Tool var1, Container var2);

    private void doPrefs(JFrame parent) {
        this.desktop.showPreferences(parent);
    }

    protected abstract void saveDesktop(Map<String, String> var1);

    protected void saveTools(Map<String, String> m) {
        Tool[] tools = this.getTools();
        m.put("tool.count", String.valueOf(tools.length));
        for (int i = 0; i < tools.length; ++i) {
            this.saveTool(new PrefixMap<String>(m, "tool." + String.valueOf(i)), tools[i]);
        }
    }

    protected void saveTool(Map<String, String> m, Tool t) {
        m.put("mgr", t.getManager().getClass().getName());
        m.put("class", t.getClass().getName());
        m.put("selected", String.valueOf(t == this.getSelectedTool()));
        t.save(m);
    }

    protected abstract void restoreDesktop(Map<String, String> var1);

    protected void restoreTools(Map<String, String> m) {
        try {
            String c = m.get("tool.count");
            if (c != null) {
                int count = Integer.parseInt(c);
                for (int i = 0; i < count; ++i) {
                    try {
                        String prefix = "tool." + i;
                        PrefixMap<String> toolMap = new PrefixMap<String>(m, prefix);
                        this.restoreTool(toolMap, prefix);
                        continue;
                    }
                    catch (Fault | ToolManager.Fault e) {
                        this.uif.showError("dv.restore.cantRestoreTool", i, e.getMessage());
                        continue;
                    }
                    catch (Throwable e) {
                        this.uif.showError("dv.restore.cantRestoreTool", i, e.toString());
                        I18NResourceBundle i18n = this.uif.getI18NResourceBundle();
                        this.desktop.log(i18n, "dv.restore.cantRestoreTool", e, i);
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected Tool restoreTool(Map<String, String> m, String name) throws Fault, ToolManager.Fault {
        ToolManager mgr;
        String mgrClassName = m.get("mgr");
        if (mgrClassName == null) {
            String toolClassName = m.get("class");
            if (toolClassName != null && toolClassName.endsWith("Tool")) {
                String n = toolClassName.substring(0, toolClassName.length()) + "Manager";
                try {
                    if (Class.forName(n) != null) {
                        mgrClassName = n;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (mgrClassName == null) {
                throw new Fault(i18n, "dv.restore.noMgrClass", (Object)name);
            }
        }
        if ((mgr = this.desktop.getToolManager(mgrClassName)) == null) {
            throw new Fault(i18n, "dv.restore.noMgr", name, mgrClassName);
        }
        Tool t = mgr.restoreTool(m);
        this.addTool(t);
        boolean selected = "true".equals(m.get("selected"));
        if (selected) {
            this.setSelectedTool(t);
        }
        return t;
    }

    static {
        String opts = System.getProperty("javatest.focus.monitor");
        if (opts != null) {
            focusMonitor = FocusMonitor.access();
            if (!opts.equals("true")) {
                focusMonitor.setOptions(StringArray.split(opts));
            }
            focusMonitor.setActivateKey("alt 2");
            focusMonitor.setReportKey("shift alt 2");
            focusMonitor.setReportFile(System.getProperty("javatest.focus.monitor.log"));
        }
    }

    private class FileMenuListener
    implements MenuListener,
    ActionListener {
        private JMenu fileOpenMenu;
        private JMenuItem prefs;
        private JMenuItem close;
        private JMenuItem exit;

        FileMenuListener(Action closeAction) {
            this.prefs = DeskView.this.uif.createMenuItem("dt.file", DeskView.PREFS, this);
            if (closeAction != null) {
                this.close = DeskView.this.uif.createMenuItem(closeAction);
            }
            this.exit = DeskView.this.uif.createMenuItem("dt.file", DeskView.EXIT, this);
        }

        @Override
        public void menuSelected(MenuEvent e) {
            ToolManager[] mgrs;
            JMenu m = (JMenu)e.getSource();
            m.removeAll();
            for (ToolManager mgr1 : mgrs = DeskView.this.desktop.getToolManagers()) {
                JMenuItem[] jmi;
                Action[] fma = mgr1.getFileMenuActions();
                if (fma != null) {
                    for (Action aFma : fma) {
                        m.add(new JMenuItem(aFma));
                    }
                }
                if ((jmi = mgr1.getFileMenuPrimaries()) == null) continue;
                JMenuItem[] jMenuItemArray = jmi;
                int n = jMenuItemArray.length;
                for (int aFma = 0; aFma < n; ++aFma) {
                    JMenuItem aJmi = jMenuItemArray[aFma];
                    m.add(aJmi);
                }
            }
            for (ToolManager mgr : mgrs) {
                JMenuItem[] jmi = mgr.getFileMenuSecondaries();
                if (jmi == null) continue;
                for (JMenuItem aJmi : jmi) {
                    m.add(aJmi);
                }
                m.addSeparator();
            }
            List<Desktop.FileHistoryEntry> fileHistory = DeskView.this.desktop.getFileHistory();
            JMenu hm = DeskView.this.uif.createMenu("dt.file.recentwd");
            if (!fileHistory.isEmpty()) {
                int n = 0;
                for (Desktop.FileHistoryEntry h : fileHistory) {
                    if (!h.file.exists()) continue;
                    String s = DeskView.this.uif.getI18NString("dt.file.historyX.mit", n, h.file.getPath());
                    JMenuItem mi = new JMenuItem(s);
                    mi.setActionCommand(DeskView.HISTORY);
                    mi.addActionListener(this);
                    mi.putClientProperty(this, h);
                    if (n < 10) {
                        mi.setMnemonic(Character.forDigit(n, 10));
                    }
                    ++n;
                    hm.add(mi);
                }
            } else {
                JMenuItem noEntries = new JMenuItem(i18n.getString("fh.empty"));
                noEntries.setEnabled(false);
                hm.add(noEntries);
            }
            m.add(hm);
            m.addSeparator();
            m.add(this.prefs);
            m.addSeparator();
            if (this.close != null) {
                m.add(this.close);
            }
            m.add(this.exit);
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            JMenu m = (JMenu)e.getSource();
            m.removeAll();
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            JMenu m = (JMenu)e.getSource();
            m.removeAll();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd;
            Component src = (Component)e.getSource();
            JFrame parent = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, src);
            if (parent == null) {
                parent = DeskView.this.getFrames()[0];
            }
            if ((cmd = e.getActionCommand()).equals(DeskView.PREFS)) {
                DeskView.this.doPrefs(parent);
            } else if (cmd.equals(DeskView.HISTORY)) {
                JMenuItem mi = (JMenuItem)e.getSource();
                Desktop.FileHistoryEntry h = (Desktop.FileHistoryEntry)mi.getClientProperty(this);
                try {
                    h.fileOpener.open(h.file);
                }
                catch (FileNotFoundException ex) {
                    DeskView.this.uif.showError("dt.file.cannotFind", (Object)h.file);
                }
                catch (FileOpener.Fault ex) {
                    DeskView.this.uif.showError("dt.file.cannotOpen", h.file, ex.getMessage());
                }
            } else if (cmd.equals(DeskView.EXIT)) {
                DeskView.this.desktop.checkToolsAndExitIfOK(parent);
            }
        }
    }

    static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        Fault(I18NResourceBundle i18n, String s, Object ... o) {
            super(i18n.getString(s, o));
        }
    }
}

