/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.services;

import com.sun.javatest.ResourceLoader;
import com.sun.javatest.TestSuite;
import com.sun.javatest.services.LocalConnector;
import com.sun.javatest.services.Service;
import com.sun.javatest.services.ServiceProperties;
import com.sun.javatest.services.ServiceReader;
import com.sun.javatest.services.TestPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLServiceReader
implements ServiceReader {
    public static final String SERVICES_XML = File.separator + "lib" + File.separator + "services.xml";
    private File xml;
    private Document doc;
    private TestSuite ts;

    @Override
    public String getServiceDescriptorFileName() {
        return SERVICES_XML;
    }

    @Override
    public void init(TestSuite ts, String ... args) {
        this.ts = ts;
        File tsRoot = ts.getRootDir();
        if (args == null || args.length == 0) {
            this.xml = new File(tsRoot, SERVICES_XML);
        } else {
            String path = args[0].replace("/", File.separator);
            this.xml = new File(tsRoot, path);
        }
        try {
            SchemaFactory xsdFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            File sch = ResourceLoader.getResourceFile("services.xsd", this.getClass());
            Schema schema = xsdFactory.newSchema(sch.toURI().toURL());
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            domFactory.setValidating(false);
            domFactory.setSchema(schema);
            DocumentBuilder parser = domFactory.newDocumentBuilder();
            parser.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) {
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            this.doc = parser.parse(this.xml);
        }
        catch (SAXParseException ex) {
            ts.getNotificationLog(null).severe(ex.getMessage());
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
    }

    @Override
    public Map<String, Service> readServices() {
        ServiceProperties common = this.readProperties(this.doc);
        return this.readServices(this.doc, common);
    }

    @Override
    public Set<TestPath> readTestServiceMap() {
        HashSet<TestPath> result = new HashSet<TestPath>();
        if (this.doc == null) {
            return result;
        }
        NodeList paths = this.doc.getElementsByTagName("testpath");
        for (int i = 0; i < paths.getLength(); ++i) {
            Element path = (Element)paths.item(i);
            String regexp = null;
            String matcher = null;
            if (path.hasAttribute("path")) {
                regexp = path.getAttribute("path");
            }
            if (path.hasAttribute("matcher")) {
                matcher = path.getAttribute("matcher");
            }
            TestPath tPath = new TestPath(this.ts, regexp, matcher);
            NodeList refs = path.getElementsByTagName("service");
            for (int j = 0; j < refs.getLength(); ++j) {
                Element ref = (Element)refs.item(j);
                tPath.addService(ref.getAttribute("refid"));
            }
            result.add(tPath);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceProperties readProperties(Document doc) {
        if (doc == null) {
            return null;
        }
        ServiceProperties res = new ServiceProperties(null);
        NodeList imports = doc.getElementsByTagName("propertyfile");
        FileInputStream fis = null;
        for (int i = 0; i < imports.getLength(); ++i) {
            try {
                Element elem = (Element)imports.item(i);
                String path = elem.getAttribute("file");
                File propFile = new File(this.xml.getAbsolutePath() + path);
                Properties props = new Properties();
                fis = new FileInputStream(propFile);
                props.load(fis);
                for (Object key : props.keySet()) {
                    String skey = (String)key;
                    res.addProperty(skey, props.getProperty(skey));
                }
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                continue;
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
        NodeList defs = doc.getElementsByTagName("property");
        for (int i = 0; i < defs.getLength(); ++i) {
            Element elem = (Element)defs.item(i);
            String key = elem.getAttribute("name");
            String value = null;
            if (elem.hasAttribute("value")) {
                value = elem.getAttribute("value");
            }
            res.addProperty(key, value);
        }
        if (res.isEmpty()) {
            return null;
        }
        return res;
    }

    private Map<String, Service> readServices(Document doc, ServiceProperties common) {
        TreeMap<String, Service> result = new TreeMap<String, Service>();
        if (doc == null) {
            return result;
        }
        Element root = doc.getDocumentElement();
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !child.getNodeName().equals("service")) continue;
            try {
                Element elem = (Element)child;
                String id = elem.getAttribute("id");
                String svClassName = elem.getAttribute("class");
                String descr = elem.getAttribute("description");
                Class serviceClass = this.ts.loadClass(svClassName);
                Service service = (Service)serviceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                service.setId(id);
                service.setDescription(descr);
                LocalConnector conn = new LocalConnector(service.getDefaultServiceExecutor());
                service.setConnector(conn);
                ServiceProperties servProps = new ServiceProperties(common);
                NodeList args = elem.getElementsByTagName("arg");
                for (int j = 0; j < args.getLength(); ++j) {
                    Element arg = (Element)args.item(j);
                    String key = arg.getAttribute("name");
                    String value = null;
                    if (arg.hasAttribute("value")) {
                        value = arg.getAttribute("value");
                    }
                    servProps.addProperty(key, value);
                }
                service.setProperties(servProps);
                result.put(service.getId(), service);
                continue;
            }
            catch (TestSuite.Fault | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return result;
    }
}

