/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Status;
import com.sun.javatest.Test;
import com.sun.javatest.lib.MultiStatus;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class TestCases {
    private static final Object[] noArgs = new Object[0];
    private static final Class<?>[] noArgTypes = new Class[0];
    private Object test;
    private Class<?> testClass;
    private Map<String, Method> selectedCases = new Hashtable<String, Method>();
    private Map<String, Method> excludedCases = new Hashtable<String, Method>();
    private PrintWriter log;

    public TestCases(Test t, PrintWriter log) {
        this.test = t;
        this.log = log;
        this.testClass = t.getClass();
    }

    public void select(String testCaseNames) throws Fault {
        this.select(this.split(testCaseNames));
    }

    public void select(String ... testCaseNames) throws Fault {
        for (String t : testCaseNames) {
            this.selectedCases.put(t, this.getTestCase(t));
        }
    }

    public void exclude(String testCaseNames) throws Fault {
        this.exclude(this.split(testCaseNames));
    }

    public void exclude(String ... testCaseNames) throws Fault {
        for (String t : testCaseNames) {
            this.excludedCases.put(t, this.getTestCase(t));
        }
    }

    public Enumeration<Method> enumerate() {
        Vector<Method> v = new Vector<Method>();
        if (this.selectedCases.isEmpty()) {
            Method[] methods;
            for (Method m : methods = this.testClass.getMethods()) {
                if (this.excludedCases.get(m.getName()) != null) continue;
                Class<?>[] paramTypes = m.getParameterTypes();
                Class<?> returnType = m.getReturnType();
                if (paramTypes.length != 0 || !Status.class.isAssignableFrom(returnType)) continue;
                v.add(m);
            }
        } else {
            for (Method m : this.selectedCases.values()) {
                if (this.excludedCases.get(m.getName()) != null) continue;
                v.add(m);
            }
        }
        return v.elements();
    }

    public Status invokeTestCases() {
        Method invoker;
        try {
            invoker = this.testClass.getMethod("invokeTestCase", Method.class);
            if (!Status.class.isAssignableFrom(invoker.getReturnType())) {
                invoker = null;
            }
        }
        catch (NoSuchMethodException e) {
            invoker = null;
        }
        MultiStatus ms = new MultiStatus(this.log);
        Enumeration<Method> e = this.enumerate();
        while (e.hasMoreElements()) {
            Status s;
            Method m = e.nextElement();
            try {
                s = invoker != null ? (Status)invoker.invoke(this.test, m) : (Status)m.invoke(this.test, noArgs);
            }
            catch (IllegalAccessException ex) {
                s = Status.failed("Could not access test case: " + m.getName());
            }
            catch (InvocationTargetException ex) {
                this.printStackTrace(ex.getTargetException());
                s = Status.failed("Exception from test case: " + ex.getTargetException().toString());
            }
            catch (ThreadDeath t) {
                this.printStackTrace(t);
                throw t;
            }
            catch (Throwable t) {
                this.printStackTrace(t);
                s = Status.failed("Unexpected Throwable: " + t);
            }
            ms.add(m.getName(), s);
        }
        if (ms.getTestCount() == 0) {
            return Status.passed("Test passed by default: no test cases executed.");
        }
        return ms.getStatus();
    }

    protected void printStackTrace(Throwable t) {
        if (this.log != null) {
            t.printStackTrace(this.log);
        }
    }

    private Method getTestCase(String name) throws Fault {
        try {
            Method m = this.testClass.getMethod(name, noArgTypes);
            if (!Status.class.isAssignableFrom(m.getReturnType())) {
                throw new Fault("Method for test case '" + name + "' has wrong return type");
            }
            return m;
        }
        catch (NoSuchMethodException e) {
            throw new Fault("Could not find test case: " + name);
        }
        catch (SecurityException e) {
            throw new Fault(e.toString());
        }
    }

    private String[] split(String s) {
        Vector<String> v = new Vector<String>();
        int start = 0;
        int i = s.indexOf(44);
        while (i != -1) {
            v.add(s.substring(start, i));
            start = i + 1;
            i = s.indexOf(44, start);
        }
        if (start != s.length()) {
            v.add(s.substring(start));
        }
        return v.toArray(new String[v.size()]);
    }

    public static class Fault
    extends Exception {
        public Fault(String s) {
            super(s);
        }
    }
}

