/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestResult;
import com.sun.javatest.exec.TP_Subpanel;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.text.View;

abstract class TP_PropertySubpanel
extends TP_Subpanel {
    private Table table;

    protected TP_PropertySubpanel(UIFactory uif, String uiKey) {
        super(uif, uiKey);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JTextField caption = uif.createHeading("test." + uiKey + ".caption");
        caption.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.add((Component)caption, "North");
        this.table = new Table(uif);
        JScrollPane sp = uif.createScrollPane(this.table);
        sp.getViewport().setViewPosition(new Point(0, 0));
        sp.getViewport().setBackground(Color.white);
        this.add((Component)sp, "Center");
    }

    void setHead(String nameTitle, String valueTitle) {
        this.table.setHead(nameTitle, valueTitle);
    }

    @Override
    protected void updateSubpanel(TestResult currTest) {
        super.updateSubpanel(currTest);
        this.table.reset();
    }

    protected void updateEntries(Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            String key = e.getKey();
            String val = e.getValue();
            if (val == null || val.trim().isEmpty()) continue;
            this.table.updateEntry(key, val);
        }
    }

    protected void updateEntry(String key, String val) {
        if (val != null && !val.trim().isEmpty()) {
            this.table.updateEntry(key, val);
        }
    }

    private class Table
    extends JPanel
    implements ComponentListener,
    Scrollable {
        private SortedMap<String, Entry> entries;
        private int maxNameStringWidth = 100;
        private JTextField nameLabel;
        private JTextField valueLabel;
        private Border headBorder;
        private Border bodyBorder;
        private boolean inScrollPane;
        private boolean pendingValidate;

        Table(UIFactory uif) {
            this.addComponentListener(this);
            this.setLayout(null);
            this.setBackground(Color.white);
            this.entries = new TreeMap<String, Entry>();
            Border bsp = BorderFactory.createEmptyBorder(2, 4, 2, 4);
            MatteBorder bh = BorderFactory.createMatteBorder(1, 0, 1, 0, Color.lightGray);
            this.headBorder = BorderFactory.createCompoundBorder(bh, bsp);
            MatteBorder br = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.lightGray);
            this.bodyBorder = BorderFactory.createCompoundBorder(br, bsp);
            this.nameLabel = uif.createHeading("test.table.name");
            this.nameLabel.setBorder(this.headBorder);
            this.valueLabel = uif.createHeading("test.table.value");
            this.valueLabel.setBorder(this.headBorder);
        }

        void setHead(String nameTitle, String valueTitle) {
            this.nameLabel.setText(nameTitle);
            this.valueLabel.setText(valueTitle);
        }

        void updateEntry(String key, String value) {
            Entry e = (Entry)this.entries.get(key);
            if (e == null) {
                e = new Entry(key, value);
                this.entries.put(key, e);
                this.maxNameStringWidth = Math.max(this.maxNameStringWidth, this.getFontMetrics(this.getFont()).stringWidth(key));
            } else {
                e.valueText.setText(value);
            }
            this.revalidate();
        }

        void reset() {
            this.entries.clear();
            this.removeAll();
            this.maxNameStringWidth = 100;
            if (!this.inScrollPane) {
                this.add(this.nameLabel);
                this.add(this.valueLabel);
            }
            this.revalidate();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.configureEnclosingScrollPane();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.unconfigureEnclosingScrollPane();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void revalidate() {
            if (this.inScrollPane) {
                Object object = this.getTreeLock();
                synchronized (object) {
                    if (!this.pendingValidate) {
                        this.invalidate();
                        SwingUtilities.invokeLater(() -> {
                            Object object = this.getTreeLock();
                            synchronized (object) {
                                this.validate();
                                this.pendingValidate = false;
                            }
                        });
                        this.pendingValidate = true;
                    }
                }
            } else {
                super.revalidate();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.revalidate();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doLayout() {
            Object object = this.getTreeLock();
            synchronized (object) {
                Insets ni = this.bodyBorder.getBorderInsets(this);
                int nameWidth = ni.left + this.maxNameStringWidth + 10 + ni.right;
                int valueWidth = Math.max(this.getWidth() - nameWidth, 200);
                int h = this.nameLabel.getPreferredSize().height;
                this.nameLabel.setBounds(0, 0, nameWidth, h);
                this.valueLabel.setBounds(nameWidth, 0, valueWidth, h);
                int y = this.inScrollPane ? 0 : h;
                for (Entry e : this.entries.values()) {
                    Insets vi = e.valueText.getInsets();
                    View v = e.valueText.getUI().getRootView(e.valueText);
                    v.setSize(valueWidth, 2.1474836E9f);
                    h = vi.top + (int)v.getPreferredSpan(1) + vi.bottom;
                    e.nameField.setBounds(0, y, nameWidth, h);
                    e.valueText.setBounds(nameWidth, y, valueWidth, h);
                    y += h;
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            int h = this.inScrollPane ? 0 : this.nameLabel.getPreferredSize().height;
            for (Entry e : this.entries.values()) {
                h += e.valueText.getMinimumSize().height;
            }
            return new Dimension(this.maxNameStringWidth + 400, h);
        }

        @Override
        public Dimension getPreferredSize() {
            int h = this.inScrollPane ? 0 : this.nameLabel.getPreferredSize().height;
            for (Entry e : this.entries.values()) {
                h += e.valueText.getPreferredSize().height;
            }
            return new Dimension(this.maxNameStringWidth + 400, h);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            switch (orientation) {
                case 1: {
                    return visibleRect.height / 10;
                }
                case 0: {
                    return visibleRect.width / 10;
                }
            }
            throw new IllegalArgumentException("Invalid orientation: " + orientation);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            switch (orientation) {
                case 1: {
                    return visibleRect.height;
                }
                case 0: {
                    return visibleRect.width;
                }
            }
            throw new IllegalArgumentException("Invalid orientation: " + orientation);
        }

        private void configureEnclosingScrollPane() {
            Container gp;
            Container p = this.getParent();
            if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)gp;
                JViewport viewport = scrollPane.getViewport();
                if (viewport == null || viewport.getView() != this) {
                    return;
                }
                this.inScrollPane = true;
                scrollPane.setColumnHeaderView(new Header());
                JPanel corner = new JPanel();
                corner.setBackground(Color.white);
                corner.setBorder(this.headBorder);
                scrollPane.setCorner("UPPER_RIGHT_CORNER", corner);
            }
        }

        private void unconfigureEnclosingScrollPane() {
            Container gp;
            Container p = this.getParent();
            if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)gp;
                JViewport viewport = scrollPane.getViewport();
                if (viewport == null || viewport.getView() != this) {
                    return;
                }
                this.inScrollPane = false;
                scrollPane.setColumnHeaderView(null);
            }
        }

        private class Header
        extends JPanel {
            Header() {
                this.setLayout(null);
                this.setOpaque(true);
                this.setBackground(Color.white);
                this.add(Table.this.nameLabel);
                this.add(Table.this.valueLabel);
            }

            public Dimension getMinumumSize() {
                return new Dimension(Table.this.getMinimumSize().width, ((Table)Table.this).nameLabel.getMinimumSize().height);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(Table.this.getPreferredSize().width, ((Table)Table.this).nameLabel.getPreferredSize().height);
            }
        }

        private class Entry {
            String name;
            JTextField nameField;
            String value;
            JTextArea valueText;

            Entry(String name, String value) {
                this.name = name;
                this.value = value;
                this.nameField = TP_PropertySubpanel.this.uif.createOutputField("test.table.entry.name", name);
                this.nameField.setBorder(Table.this.bodyBorder);
                this.nameField.setEditable(false);
                this.nameField.setOpaque(false);
                Table.this.add(this.nameField);
                int width = Math.max(Table.this.getWidth() - Table.this.maxNameStringWidth, 200);
                this.valueText = TP_PropertySubpanel.this.uif.createTextArea("test.table.entry.value");
                this.valueText.setText(value);
                this.valueText.setBorder(Table.this.bodyBorder);
                this.valueText.setEditable(false);
                this.valueText.setLineWrap(true);
                Table.this.add(this.valueText);
            }
        }
    }
}

