/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.tool.PreferencesPane;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.HelpBroker;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class PrefsPane
extends PreferencesPane {
    private UIFactory uif;
    private JCheckBox toolBarChk;
    private JCheckBox filterWarnChk;
    private JCheckBox wrapResChk;
    private ConfigEditorPane configEditorPane;
    private ReportingPane reportingPane;
    private RunPane runPane;
    private PreferencesPane[] childPanes;

    PrefsPane(HelpBroker helpBroker) {
        this.uif = new UIFactory(this, helpBroker);
        this.initGUI();
    }

    @Override
    public PreferencesPane[] getChildPanes() {
        if (this.configEditorPane == null) {
            this.configEditorPane = new ConfigEditorPane();
        }
        if (this.reportingPane == null) {
            this.reportingPane = new ReportingPane();
        }
        if (this.runPane == null) {
            this.runPane = new RunPane();
        }
        if (this.childPanes == null) {
            this.childPanes = new PreferencesPane[]{this.configEditorPane, this.reportingPane, this.runPane};
        }
        return this.childPanes;
    }

    @Override
    public String getText() {
        return this.uif.getI18NString("ep.title");
    }

    @Override
    public void load(Map<String, String> m) {
        super.load(m);
        String p = m.get("exec.toolbar");
        this.toolBarChk.setSelected(p == null || p.equals("true"));
        p = m.get("exec.filterWarn");
        this.filterWarnChk.setSelected(p == null || p.equals("true"));
        p = m.get("testOutput.lineWrap");
        this.wrapResChk.setSelected(p == null ? true : p.equals("true"));
    }

    @Override
    public void save(Map<String, String> m) {
        super.save(m);
        m.put("exec.toolbar", String.valueOf(this.toolBarChk.isSelected()));
        m.put("exec.filterWarn", String.valueOf(this.filterWarnChk.isSelected()));
        m.put("testOutput.lineWrap", String.valueOf(this.wrapResChk.isSelected()));
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)this.createToolBarPanel(), c);
        this.add((Component)this.createFilterPanel(), c);
        this.add((Component)this.createTestRunMsgPanel(), c);
        c.weighty = 1.0;
        this.add(Box.createVerticalGlue(), c);
    }

    private JPanel createToolBarPanel() {
        JPanel p = this.uif.createPanel("exec.prefs", new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        p.setBorder(this.uif.createTitledBorder("ep.toolbar"));
        this.toolBarChk = this.uif.createCheckBox("ep.toolbar", true);
        this.uif.setAccessibleName(this.toolBarChk, "ep.toolbar");
        p.add((Component)this.toolBarChk, c);
        return p;
    }

    private JPanel createFilterPanel() {
        JPanel p = this.uif.createPanel("exec.prefs.filter", new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        p.setBorder(this.uif.createTitledBorder("ep.filt"));
        this.filterWarnChk = this.uif.createCheckBox("ep.filt", true);
        this.uif.setAccessibleName(this.filterWarnChk, "ep.filt");
        p.add((Component)this.filterWarnChk, c);
        return p;
    }

    private JPanel createTestRunMsgPanel() {
        JPanel p = this.uif.createPanel("exec.prefs.testrun", new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        p.setBorder(this.uif.createTitledBorder("ep.testrun"));
        this.wrapResChk = this.uif.createCheckBox("ep.wrapres", true);
        this.uif.setAccessibleName(this.wrapResChk, "ep.wrapres");
        p.add((Component)this.wrapResChk, c);
        return p;
    }

    private class RunPane
    extends PreferencesPane {
        private JTextField bugUrlTf;
        private JCheckBox tests2RunChk;
        private JCheckBox testSortingChk;
        private JRadioButton defaultRadio;
        private JRadioButton reverseRadio;
        private JRadioButton randomRadio;
        private ButtonGroup sequenceButtons;

        RunPane() {
            this.initGUI();
        }

        @Override
        public String getText() {
            return PrefsPane.this.uif.getI18NString("ep.run.title");
        }

        @Override
        public void load(Map<String, String> m) {
            String mp = m.get("javatest.executionOrder");
            if (mp == null) {
                mp = "default";
            }
            if (mp.equals("reverse")) {
                this.reverseRadio.setSelected(true);
            } else if (mp.equals("random")) {
                this.randomRadio.setSelected(true);
            } else {
                this.defaultRadio.setSelected(true);
            }
            mp = m.get("exec.tests2runPop");
            this.tests2RunChk.setSelected(mp == null ? false : mp.equals("true"));
            mp = m.get("javatest.sortExecution");
            this.testSortingChk.setSelected(mp == null ? false : mp.equals("false"));
        }

        @Override
        public void save(Map<String, String> m) {
            m.put("exec.tests2runPop", String.valueOf(this.tests2RunChk.isSelected()));
            m.put("javatest.sortExecution", Boolean.toString(!this.testSortingChk.isSelected()));
            String sequence = ".default";
            sequence = this.reverseRadio.isSelected() ? this.reverseRadio.getName() : (this.randomRadio.isSelected() ? this.randomRadio.getName() : this.defaultRadio.getName());
            m.put("javatest.executionOrder", sequence.substring(sequence.lastIndexOf(46) + 1));
        }

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            this.add((Component)this.createExecutionPanel(), c);
            this.add((Component)this.createOrderPanel(), c);
            c.weighty = 1.0;
            this.add(Box.createVerticalGlue(), c);
        }

        private JPanel createExecutionPanel() {
            JPanel p = PrefsPane.this.uif.createPanel("exec.prefs.run", new GridBagLayout(), false);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.weightx = 1.0;
            p.setBorder(PrefsPane.this.uif.createTitledBorder("ep.exec"));
            this.tests2RunChk = PrefsPane.this.uif.createCheckBox("ep.tests2run", true);
            PrefsPane.this.uif.setAccessibleName(this.tests2RunChk, "ep.tests2run");
            p.add((Component)this.tests2RunChk, c);
            this.testSortingChk = PrefsPane.this.uif.createCheckBox("ep.sorttests", true);
            c.gridy = 20;
            p.add((Component)this.testSortingChk, c);
            return p;
        }

        private JPanel createOrderPanel() {
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            JPanel p = PrefsPane.this.uif.createPanel("exec.prefs.exec", new GridBagLayout(), false);
            p.setBorder(PrefsPane.this.uif.createTitledBorder("ep.run"));
            this.sequenceButtons = new ButtonGroup();
            this.defaultRadio = PrefsPane.this.uif.createRadioButton("ep.run.order.default", this.sequenceButtons);
            this.randomRadio = PrefsPane.this.uif.createRadioButton("ep.run.order.random", this.sequenceButtons);
            this.reverseRadio = PrefsPane.this.uif.createRadioButton("ep.run.order.reverse", this.sequenceButtons);
            p.add((Component)this.defaultRadio, c);
            p.add((Component)this.randomRadio, c);
            p.add((Component)this.reverseRadio, c);
            return p;
        }
    }

    private class ReportingPane
    extends PreferencesPane {
        private JTextField bugUrlTf;

        ReportingPane() {
            this.initGUI();
        }

        @Override
        public String getText() {
            return PrefsPane.this.uif.getI18NString("ep.rpt.title");
        }

        @Override
        public void load(Map<String, String> m) {
            String mp = m.get("exec.report.bugurl");
            this.bugUrlTf.setText(mp);
        }

        @Override
        public void save(Map<String, String> m) {
            m.put("exec.report.bugurl", this.bugUrlTf.getText());
        }

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            this.add((Component)this.createDefaultViewPanel(), c);
            c.weighty = 1.0;
            this.add(Box.createVerticalGlue(), c);
        }

        private JPanel createDefaultViewPanel() {
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 512;
            c.gridwidth = 1;
            c.gridx = -1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            JPanel p = new JPanel(new GridBagLayout());
            JLabel lbl = PrefsPane.this.uif.createLabel("ep.rpt.url");
            p.add((Component)lbl, c);
            this.bugUrlTf = PrefsPane.this.uif.createInputField("ep.rpt.url", lbl);
            this.bugUrlTf.setColumns(30);
            PrefsPane.this.uif.setAccessibleName(this.bugUrlTf, "ep.rpt.url");
            c.gridwidth = 0;
            c.weightx = 5.0;
            p.add((Component)this.bugUrlTf, c);
            JTextArea hint = PrefsPane.this.uif.createMessageArea("ep.rpt.url");
            hint.setFont(hint.getFont().deriveFont(2));
            hint.setBorder(BorderFactory.createEmptyBorder());
            c.gridx = 1;
            c.gridy = 1;
            c.weightx = 1.0;
            p.add((Component)hint, c);
            return p;
        }
    }

    private class ConfigEditorPane
    extends PreferencesPane {
        private JCheckBox moreInfoChk;

        ConfigEditorPane() {
            this.initGUI();
        }

        @Override
        public String getText() {
            return PrefsPane.this.uif.getI18NString("ep.ce.title");
        }

        @Override
        public void load(Map<String, String> m) {
            String mp = m.get("exec.config.moreInfo");
            this.moreInfoChk.setSelected(mp == null || mp.equals("true"));
        }

        @Override
        public void save(Map<String, String> m) {
            m.put("exec.config.moreInfo", String.valueOf(this.moreInfoChk.isSelected()));
        }

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            this.add((Component)this.createDefaultViewPanel(), c);
            c.weighty = 1.0;
            this.add(Box.createVerticalGlue(), c);
        }

        private JPanel createDefaultViewPanel() {
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.gridwidth = 0;
            c.insets.left = 10;
            c.weightx = 1.0;
            c.weighty = 0.0;
            JPanel p = new JPanel(new GridBagLayout());
            JTextArea infoTa = PrefsPane.this.uif.createMessageArea("ep.ce.info");
            infoTa.setOpaque(false);
            this.add((Component)infoTa, c);
            p.setBorder(PrefsPane.this.uif.createTitledBorder("ep.ce.defView"));
            this.moreInfoChk = PrefsPane.this.uif.createCheckBox("ep.ce.moreInfo", true);
            PrefsPane.this.uif.setAccessibleName(this.moreInfoChk, "ep.ce.moreInfo");
            c.insets.top = 10;
            p.add((Component)this.moreInfoChk, c);
            return p;
        }
    }
}

