/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import java.io.File;
import java.util.ResourceBundle;
import javax.swing.filechooser.FileFilter;

class FileType
extends FileFilter {
    public static FileType allFiles = new FileType();
    public static FileType jteFiles = new FileType("jte");
    public static FileType jtpFiles = new FileType("jtp");
    public static FileType jtxFiles = new FileType("jtx");
    private static ResourceBundle i18n = ResourceBundle.getBundle("com.sun.javatest.exec.i18n");
    private String desc;
    private String[] extns;

    public FileType() {
    }

    public FileType(String extn) {
        this(new String[]{extn});
    }

    public FileType(String ... extns) {
        this.extns = extns;
    }

    @Override
    public String getDescription() {
        if (this.desc == null) {
            StringBuilder sb = new StringBuilder("filetype");
            if (this.extns == null) {
                sb.append(".allFiles");
            } else {
                for (String extn : this.extns) {
                    sb.append("." + extn);
                }
            }
            this.desc = i18n.getString(sb.toString());
        }
        return this.desc;
    }

    public String[] getExtensions() {
        return this.extns;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory() || this.extns == null || this.extns.length == 0) {
            return true;
        }
        String fName = f.getName();
        for (String extn : this.extns) {
            if (!fName.endsWith(extn)) continue;
            return true;
        }
        return false;
    }
}

