/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.InterviewEditor;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class CE_TemplateDialog
extends ToolDialog {
    private InterviewParameters config;
    private FileChooser fileChooser;
    private JTextField fileField;
    private JButton browseBtn;
    private JCheckBox testSuiteCheckBox;
    private JCheckBox workDirCheckBox;
    private JCheckBox markersCheckBox;
    private JCheckBox filterCheckBox;
    private JCheckBox clearCheckBox;
    private JButton okBtn;
    private ExecModel model;
    private Listener listener;

    CE_TemplateDialog(JComponent parent, InterviewParameters config, ExecModel model, UIFactory uif) {
        super(parent, uif, "ct");
        this.config = config;
        this.model = model;
        this.fileChooser = new FileChooser(true);
        this.fileChooser.addChoosableExtension(".jti", uif.getI18NString("ct.jtiFiles"));
    }

    @Override
    public void setVisible(boolean on) {
        if (on) {
            if (this.markersCheckBox == null) {
                this.initGUI();
            }
            this.markersCheckBox.setSelected(this.config.getMarkersEnabled());
            this.filterCheckBox.setEnabled(this.markersCheckBox.isSelected());
            this.filterCheckBox.setSelected(this.config.getMarkersFilterEnabled());
        }
        super.setVisible(on);
    }

    @Override
    protected void initGUI() {
        this.setI18NTitle("ct.title");
        this.setHelp("confEdit.templateDialog.csh");
        this.listener = new Listener();
        JPanel body = this.uif.createPanel("ct.body", false);
        body.setLayout(new GridBagLayout());
        body.setBorder(BorderFactory.createEmptyBorder(10, 10, 30, 10));
        GridBagConstraints c = new GridBagConstraints();
        JLabel fileLbl = this.uif.createLabel("ct.file");
        c.insets.right = 10;
        body.add((Component)fileLbl, c);
        JPanel p = this.uif.createPanel("ct.file", false);
        p.setLayout(new BorderLayout());
        this.fileField = this.uif.createInputField("ct.file", 32);
        this.fileField.getDocument().addDocumentListener(this.listener);
        fileLbl.setLabelFor(this.fileField);
        p.add((Component)this.fileField, "Center");
        this.browseBtn = this.uif.createButton("ct.browse", this.listener);
        p.add((Component)this.browseBtn, "East");
        c.fill = 2;
        c.gridwidth = 0;
        c.insets.top = 10;
        c.insets.right = 0;
        c.weightx = 1.0;
        body.add((Component)p, c);
        GridBagConstraints c2 = new GridBagConstraints();
        body.add(Box.createHorizontalGlue(), c2);
        this.testSuiteCheckBox = this.uif.createCheckBox("ct.testSuite");
        this.testSuiteCheckBox.addChangeListener(this.listener);
        c.anchor = 17;
        c.fill = 0;
        c.insets.top = 0;
        body.add((Component)this.testSuiteCheckBox, c);
        body.add(Box.createHorizontalGlue(), c2);
        this.workDirCheckBox = this.uif.createCheckBox("ct.workDir");
        this.workDirCheckBox.setEnabled(this.testSuiteCheckBox.isSelected());
        body.add((Component)this.workDirCheckBox, c);
        body.add(Box.createHorizontalGlue(), c2);
        this.markersCheckBox = this.uif.createCheckBox("ct.markers");
        this.markersCheckBox.addChangeListener(this.listener);
        body.add((Component)this.markersCheckBox, c);
        body.add(Box.createHorizontalGlue(), c2);
        this.filterCheckBox = this.uif.createCheckBox("ct.filter");
        this.filterCheckBox.setEnabled(this.markersCheckBox.isSelected());
        body.add((Component)this.filterCheckBox, c);
        body.add(Box.createHorizontalGlue(), c2);
        this.clearCheckBox = this.uif.createCheckBox("ct.clear");
        body.add((Component)this.clearCheckBox, c);
        this.setBody(body);
        this.okBtn = this.uif.createButton("ct.ok", this.listener);
        this.okBtn.setEnabled(false);
        JButton cancelBtn = this.uif.createCancelButton("ct.cancel");
        JButton helpBtn = this.uif.createHelpButton("ct.help", "confEdit.templateDialog.csh");
        this.setButtons(new JButton[]{this.okBtn, cancelBtn, helpBtn}, null);
    }

    private void doBrowse() {
        File file;
        String fileFieldText = this.fileField.getText();
        File f = null;
        if (!fileFieldText.isEmpty()) {
            f = new File(fileFieldText);
            if (f.isDirectory()) {
                this.fileChooser.setCurrentDirectory(f);
            } else {
                this.fileChooser.setSelectedFile(f);
            }
        }
        if ((file = InterviewEditor.saveConfigFile(this.model.getContextManager(), this.parent, this.uif, this.fileChooser, f, false)) != null) {
            this.fileField.setText(file.getPath());
        }
    }

    private boolean doSave() {
        InterviewParameters c;
        String path;
        String fileFieldText = this.fileField.getText();
        if (fileFieldText.isEmpty()) {
            return false;
        }
        File file = new File(fileFieldText);
        if (!file.exists() && !(path = file.getPath()).endsWith(".jti")) {
            file = new File(path + ".jti");
        }
        if (file.exists()) {
            int rc = this.uif.showYesNoCancelDialog("ce.save.warn");
            switch (rc) {
                case 0: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        boolean createdNew = false;
        if (this.clearCheckBox.isSelected() || this.markersCheckBox.isSelected() != this.config.getMarkersEnabled() || this.filterCheckBox.isSelected() != this.config.getMarkersFilterEnabled()) {
            try {
                c = this.config.getTestSuite().createInterview();
                createdNew = true;
                HashMap<String, String> data = new HashMap<String, String>();
                this.config.save(data);
                c.load(data, false);
            }
            catch (Interview.Fault | TestSuite.Fault e) {
                return false;
            }
            c.setMarkersEnabled(this.markersCheckBox.isSelected());
            c.setMarkersFilterEnabled(this.filterCheckBox.isSelected());
            if (this.clearCheckBox.isSelected()) {
                c.clearMarkedResponses(null);
            }
        } else {
            c = this.config;
        }
        boolean tsb = this.testSuiteCheckBox.isSelected();
        boolean wdb = this.workDirCheckBox.isSelected();
        try {
            c.saveAs(file, tsb, !tsb ? false : wdb, true);
            if (createdNew) {
                c.dispose();
            }
            return true;
        }
        catch (IOException e) {
            this.uif.showError("ct.save", (Object)e.toString());
            return false;
        }
        catch (Interview.Fault e) {
            this.uif.showError("ct.save", (Object)e.getMessage());
            return false;
        }
    }

    private class Listener
    implements ActionListener,
    ChangeListener,
    DocumentListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean ok;
            Object src = e.getSource();
            if (src == CE_TemplateDialog.this.browseBtn) {
                CE_TemplateDialog.this.doBrowse();
            } else if (src == CE_TemplateDialog.this.okBtn && (ok = CE_TemplateDialog.this.doSave())) {
                CE_TemplateDialog.this.setVisible(false);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object src = e.getSource();
            if (src == CE_TemplateDialog.this.testSuiteCheckBox) {
                CE_TemplateDialog.this.workDirCheckBox.setEnabled(CE_TemplateDialog.this.testSuiteCheckBox.isSelected());
            } else if (src == CE_TemplateDialog.this.markersCheckBox) {
                CE_TemplateDialog.this.filterCheckBox.setEnabled(CE_TemplateDialog.this.markersCheckBox.isSelected());
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            File parent;
            File f;
            String path = CE_TemplateDialog.this.fileField.getText();
            boolean ok = path.isEmpty() ? false : ((f = new File(path)).exists() && f.isDirectory() ? false : (parent = f.getParentFile()) != null && parent.exists() && parent.isDirectory());
            CE_TemplateDialog.this.okBtn.setEnabled(ok);
        }
    }
}

