/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

public class Status {
    public static final int PASSED = 0;
    public static final int FAILED = 1;
    public static final int ERROR = 2;
    public static final int NOT_RUN = 3;
    public static final int NUM_STATES = 4;
    public static final String EXIT_PREFIX = "STATUS:";
    public static final int[] exitCodes = new int[]{95, 97, 98, 99};
    private static final String ENC_PREFFIX = "<EncodeD>";
    private static final String ENC_SUFFFIX = "</EncodeD>";
    private static final String ENC_SEPARATOR = " ";
    private static String[] texts = new String[]{"Passed.", "Failed.", "Error.", "Not run."};
    private final int type;
    private final String reason;

    private Status(String s) {
        for (int t = 0; t < texts.length; ++t) {
            if (!s.startsWith(texts[t])) continue;
            int l = texts[t].length();
            String r = l < s.length() ? (s.charAt(l) == ' ' ? s.substring(l + 1) : s.substring(l)) : "";
            this.type = t;
            this.reason = Status.normalize(r);
            return;
        }
        throw new IllegalArgumentException();
    }

    public Status(int type, String reason) {
        if (type < 0 || type >= 4) {
            throw new IllegalArgumentException(String.valueOf(type));
        }
        this.type = type;
        this.reason = Status.normalize(reason);
    }

    public static Status passed(String reason) {
        return new Status(0, reason);
    }

    public static Status failed(String reason) {
        return new Status(1, reason);
    }

    public static Status error(String reason) {
        return new Status(2, reason);
    }

    @Deprecated
    public static Status notApplicable(String reason) {
        return new Status(1, "Not Applicable: " + reason);
    }

    static Status notRun(String reason) {
        return new Status(3, reason);
    }

    public static Status parse(String s) {
        try {
            return new Status(Status.decode(s));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String typeToString(int typeNum) {
        if (typeNum < 4) {
            return texts[typeNum];
        }
        return null;
    }

    private static String normalize(String msg) {
        boolean ok = true;
        boolean prevIsWhite = false;
        for (int i = 0; ok && i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (prevIsWhite || ch != ' ' || i == 0) {
                    ok = false;
                    break;
                }
                prevIsWhite = true;
                continue;
            }
            prevIsWhite = false;
        }
        if (prevIsWhite) {
            ok = false;
        }
        if (ok) {
            return msg;
        }
        StringBuilder sb = new StringBuilder();
        boolean needWhite = false;
        for (int i = 0; i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (sb.length() <= 0) continue;
                needWhite = true;
                continue;
            }
            if (needWhite) {
                sb.append(' ');
            }
            sb.append(ch);
            needWhite = false;
        }
        return sb.toString();
    }

    private static boolean isPrintable(char c) {
        return ' ' <= c && c < '\u007f';
    }

    public static String encode(String str) {
        if (str == null) {
            return null;
        }
        boolean isAscii = true;
        for (int i = 0; i < str.length(); ++i) {
            if (Status.isPrintable(str.charAt(i))) continue;
            isAscii = false;
            break;
        }
        if (isAscii) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ENC_PREFFIX);
        for (int i = 0; i < str.length(); ++i) {
            sb.append(Status.encodeChar(str.charAt(i)));
            sb.append(ENC_SEPARATOR);
        }
        sb.append(ENC_SUFFFIX);
        return sb.toString();
    }

    public static String decode(String str) {
        if (str == null) {
            return null;
        }
        int ind = str.indexOf(ENC_PREFFIX);
        if (ind < 0 || !str.endsWith(ENC_SUFFFIX)) {
            return str;
        }
        String encoded = str.substring(ind + ENC_PREFFIX.length(), str.length() - ENC_SUFFFIX.length());
        StringBuilder sb = new StringBuilder();
        sb.append(str.substring(0, ind));
        int begin = 0;
        int end = encoded.indexOf(ENC_SEPARATOR);
        while (end >= 0) {
            sb.append(Status.decodeChar(encoded.substring(begin, end)));
            begin = end + ENC_SEPARATOR.length();
            end = encoded.indexOf(ENC_SEPARATOR, begin);
        }
        sb.append(encoded.substring(begin));
        return sb.toString();
    }

    private static String encodeChar(char c) {
        return Integer.toString(c, 16);
    }

    private static char decodeChar(String s) {
        return (char)Integer.parseInt(s, 16);
    }

    public boolean isPassed() {
        return this.type == 0;
    }

    public boolean isFailed() {
        return this.type == 1;
    }

    public boolean isError() {
        return this.type == 2;
    }

    public boolean isNotRun() {
        return this.type == 3;
    }

    public int getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public Status augment(String aux) {
        if (aux == null || aux.isEmpty()) {
            return this;
        }
        return new Status(this.type, this.reason + " [" + aux + "]");
    }

    public Status augment(Status aux) {
        return aux == null ? this : this.augment(aux.reason);
    }

    public String toString() {
        if (this.reason == null || this.reason.isEmpty()) {
            return texts[this.type];
        }
        return texts[this.type] + ENC_SEPARATOR + this.reason;
    }

    public void exit() {
        if (System.err != null) {
            System.err.print(EXIT_PREFIX);
            System.err.print(texts[this.type]);
            System.err.println(Status.encode(this.reason));
            System.err.flush();
        }
        System.exit(exitCodes[this.type]);
    }
}

