/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class ChoiceArrayQuestion
extends Question {
    protected boolean[] value;
    private String[] choices;
    private String[] displayChoices;
    private boolean[] defaultValue;

    protected ChoiceArrayQuestion(Interview interview, String tag) {
        super(interview, tag);
    }

    protected ChoiceArrayQuestion(Interview interview, String tag, String ... choices) {
        super(interview, tag);
        this.setChoices(choices, choices);
    }

    private static boolean white(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    protected void setChoices(String[] choices, boolean localize) {
        this.setChoices(choices, localize ? null : choices);
    }

    protected void setChoices(String[] choices, String ... displayChoices) {
        if (choices == null) {
            throw new NullPointerException();
        }
        for (String choice : choices) {
            if (choice != null) continue;
            throw new NullPointerException();
        }
        if (displayChoices != null) {
            if (choices.length != displayChoices.length) {
                throw new IllegalArgumentException();
            }
            for (String displayChoice : displayChoices) {
                if (displayChoice != null) continue;
                throw new NullPointerException();
            }
        }
        this.choices = choices;
        this.displayChoices = displayChoices;
        this.value = new boolean[choices.length];
        if (this.defaultValue != null && this.defaultValue.length != choices.length) {
            this.defaultValue = null;
        }
    }

    public String[] getChoices() {
        return this.choices;
    }

    protected void setChoices(String ... choices) {
        this.setChoices(choices, choices);
    }

    public String[] getDisplayChoices() {
        if (this.displayChoices == null) {
            ResourceBundle b = this.interview.getResourceBundle();
            if (b == null) {
                return this.choices;
            }
            this.displayChoices = new String[this.choices.length];
            for (int i = 0; i < this.choices.length; ++i) {
                String c = this.choices[i];
                String rn = this.key + "." + c;
                try {
                    this.displayChoices[i] = c == null ? null : b.getString(rn);
                    continue;
                }
                catch (MissingResourceException e) {
                    System.err.println("WARNING: missing resource " + rn);
                    this.displayChoices[i] = c;
                }
            }
        }
        return this.displayChoices;
    }

    public boolean[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(boolean ... v) {
        this.defaultValue = v;
    }

    public boolean[] getValue() {
        if (this.value == null) {
            throw new IllegalStateException();
        }
        boolean[] cp = null;
        if (this.value != null) {
            cp = new boolean[this.value.length];
            for (int i = 0; i < this.value.length; ++i) {
                cp[i] = this.value[i];
            }
        }
        return cp;
    }

    @Override
    public void setValue(String newValue) {
        if (this.choices == null) {
            return;
        }
        boolean[] bb = new boolean[this.choices.length];
        int start = -1;
        for (int i = 0; i < newValue.length(); ++i) {
            if (ChoiceArrayQuestion.white(newValue.charAt(i))) {
                if (start != -1) {
                    this.set(bb, newValue.substring(start, i));
                }
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start != -1) {
            this.set(bb, newValue.substring(start));
        }
        this.setValue(bb);
    }

    public void setValue(boolean ... newValue) {
        if (this.choices == null) {
            return;
        }
        boolean changed = false;
        if (newValue == null) {
            for (int i = 0; i < this.value.length; ++i) {
                if (!changed) {
                    changed = this.value[i];
                }
                this.value[i] = false;
            }
        } else {
            for (int i = 0; i < Math.min(newValue.length, this.value.length); ++i) {
                if (!changed) {
                    changed = this.value[i] != newValue[i];
                }
                this.value[i] = newValue[i];
            }
        }
        if (changed) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public boolean[] getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    @Override
    public String getStringValue() {
        if (this.value == null) {
            return "";
        }
        if (this.value.length != this.choices.length) {
            throw new IllegalStateException();
        }
        StringBuilder sb = new StringBuilder();
        if (this.value != null) {
            for (int i = 0; i < this.value.length; ++i) {
                if (!this.value[i]) continue;
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(this.choices[i].replace(' ', '_'));
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    public boolean isValueAlwaysValid() {
        return false;
    }

    private void set(boolean[] bb, String s) {
        for (int i = 0; i < this.choices.length; ++i) {
            if (!s.equals(this.choices[i].replace(' ', '_'))) continue;
            bb[i] = true;
            return;
        }
    }

    @Override
    public void clear() {
        this.setValue(this.defaultValue);
    }

    @Override
    protected void save(Map<String, String> data) {
        data.put(this.tag, this.getStringValue());
    }
}

