/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.ClassHierarchyImpl;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.core.context.BaseOptions;
import com.sun.tdk.signaturetest.core.context.MergeOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.loaders.VirtualClassDescriptionLoader;
import com.sun.tdk.signaturetest.merge.JSR68Merger;
import com.sun.tdk.signaturetest.merge.MergedSigFile;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.MultipleFileReader;
import com.sun.tdk.signaturetest.sigfile.Writer;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.Logger;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;

public class Merge
extends SigTest {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Merge.class);

    public static void main(String[] args) {
        Merge m = Merge.getInstance();
        m.run(args, new PrintWriter(System.err, true), null);
        m.exit();
    }

    protected static Merge getInstance() {
        return new Merge();
    }

    public void run(String[] args, PrintWriter pw, PrintWriter ref) {
        this.setLog(pw);
        if (this.parseParameters(args)) {
            this.perform();
            this.getLog().flush();
        } else if (args.length > 0 && Option.VERSION.accept(args[0])) {
            System.err.println(Version.getVersionInfo());
        } else {
            this.usage();
        }
    }

    private boolean parseParameters(String[] args) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        this.initErrors();
        if (args == null || args.length == 0 || Option.HELP.accept(args[0])) {
            return false;
        }
        String optionsDecoder = "decodeOptions";
        MergeOptions mo = AppContext.getContext().getBean(MergeOptions.class);
        parser.addOptions(mo.getOptions(), "decodeOptions");
        try {
            parser.processArgs(args);
            if (mo.getValue(Option.WRITE) != null) {
                this.checkValidWriteFile();
            }
        }
        catch (CommandLineParserException e) {
            this.getLog().println(e.getMessage());
            return this.failed(e.getMessage());
        }
        return this.passed();
    }

    private void checkValidWriteFile() throws CommandLineParserException {
        File canonicalFile = null;
        MergeOptions mo = AppContext.getContext().getBean(MergeOptions.class);
        try {
            canonicalFile = new File(mo.getValue(Option.WRITE)).getCanonicalFile();
        }
        catch (IOException e) {
            throw new CommandLineParserException(i18n.getString("Merge.could.not.resolve.file", mo.getValue(Option.WRITE)));
        }
        for (String inFile : mo.getValues(Option.FILES)) {
            try {
                File sigFile = new File(inFile).getCanonicalFile();
                if (!canonicalFile.equals(sigFile)) continue;
                throw new CommandLineParserException(i18n.getString("Merge.notunique.writefile"));
            }
            catch (IOException ex) {
                throw new CommandLineParserException(i18n.getString("Merge.could.not.resolve.file", inFile));
            }
        }
        try {
            FileOutputStream f = new FileOutputStream(mo.getValue(Option.WRITE));
            f.close();
        }
        catch (IOException e) {
            throw new CommandLineParserException(i18n.getString("Merge.could.not.create.write.file"));
        }
    }

    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        MergeOptions mo = AppContext.getContext().getBean(MergeOptions.class);
        mo.readOptions(optionName, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void perform() {
        MemberCollectionBuilder builder;
        MergeOptions mo = AppContext.getContext().getBean(MergeOptions.class);
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        String testURL = bo.getValue(Option.TEST_URL);
        if (testURL == null) {
            testURL = "";
        }
        MergedSigFile[] files = new MergedSigFile[mo.getValues(Option.FILES).size()];
        PrintWriter log = new PrintWriter(System.out);
        FeaturesHolder fh = new FeaturesHolder();
        for (int i = 0; i < mo.getValues(Option.FILES).size(); ++i) {
            String sigFiles = mo.getValues(Option.FILES).get(i);
            MultipleFileReader in = new MultipleFileReader(log, 1, this.getFileManager());
            if (!in.readSignatureFiles(testURL, sigFiles)) {
                String msg = i18n.getString("SignatureTest.error.sigfile.invalid", sigFiles);
                in.close();
                this.error(msg);
            }
            files[i] = new MergedSigFile(in, this);
            if (i == 0) {
                fh.setFeatures(in.getSupportedFeatures());
            } else {
                fh.retainFeatures(in.getSupportedFeatures());
            }
            builder = new MemberCollectionBuilder(new SilentLog());
            for (ClassDescription c : files[i].getClassSet().values()) {
                c.setHierarchy(files[i].getClassHierarchy());
                try {
                    if (in.isFeatureSupported(FeaturesHolder.BuildMembers)) {
                        builder.createMembers(c, true, true, false);
                    }
                    this.normalizer.normThrows(c, true);
                }
                catch (ClassNotFoundException e) {}
            }
        }
        JSR68Merger merger = new JSR68Merger(this, this, fh);
        VirtualClassDescriptionLoader result = merger.merge(files);
        if (!this.isPassed()) {
            this.printErrors();
            return;
        }
        ClassHierarchyImpl ch = new ClassHierarchyImpl(result, 2);
        Iterator i = result.getClassIterator();
        while (i.hasNext()) {
            ClassDescription c = (ClassDescription)i.next();
            c.setHierarchy(ch);
        }
        builder = new MemberCollectionBuilder(new SilentLog());
        Iterator i2 = result.getClassIterator();
        while (i2.hasNext()) {
            ClassDescription c;
            c = (ClassDescription)i2.next();
            try {
                builder.createMembers(c, false, true, false);
                this.normalizer.normThrows(c, true);
            }
            catch (ClassNotFoundException e) {
                this.storeError(i18n.getString("Merge.warning.message.classnotfound", e.getMessage()), null);
            }
        }
        Writer writer = null;
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        PrintWriter pw = null;
        try {
            writer = this.getFileManager().getWriter(merger.getSupportedFeatures());
            if (writer == null) {
                this.failed("Could not find a writer for given sigtest file formats.");
                return;
            }
            writer.setApiVersion("");
            if (mo.getValue(Option.WRITE) != null) {
                fos = new FileOutputStream(mo.getValue(Option.WRITE));
                osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
                pw = new PrintWriter(osw);
            } else {
                pw = new PrintWriter(System.out);
            }
            writer.init(pw);
            for (FeaturesHolder.Feature f : merger.getSupportedFeatures()) {
                if (f == FeaturesHolder.CopyRight) continue;
                writer.addFeature(f);
            }
            writer.writeHeader();
            Iterator i3 = result.getClassIterator();
            while (i3.hasNext()) {
                ClassDescription c = (ClassDescription)i3.next();
                writer.write(c);
            }
        }
        catch (IOException e) {
            SwissKnife.reportThrowable(e);
            this.error(e.getMessage());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            try {
                if (fos != null) {
                    fos.close();
                }
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException ex) {
                SwissKnife.reportThrowable(ex);
            }
            if (pw != null) {
                pw.close();
            }
        }
        this.printErrors();
    }

    @Override
    protected void usage() {
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(nl).append(this.getComponentName() + " - " + i18n.getString("SignatureTest.usage.version", "4.0"));
        sb.append(nl).append(i18n.getString("Setup.usage.start"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Merge.usage.files", Option.FILES.getKey()));
        sb.append(nl).append(i18n.getString("Merge.usage.write", Option.WRITE.getKey()));
        sb.append(nl).append(i18n.getString("Merge.usage.binary", Option.BINARY.getKey()));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("SetupAndTest.helpusage.version", Option.VERSION.getKey()));
        sb.append(nl).append(i18n.getString("Setup.usage.help", Option.HELP.getKey()));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Setup.usage.end"));
        System.err.println(sb.toString());
    }

    @Override
    protected String getComponentName() {
        return "Merge";
    }

    static class SilentLog
    implements Log {
        SilentLog() {
        }

        @Override
        public void storeError(String s, Logger utilLogger) {
        }

        @Override
        public void storeWarning(String s, Logger utilLogger) {
        }
    }
}

