/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.patchtests;

import ee.jakarta.tck.jsonp.api.common.JsonValueType;
import ee.jakarta.tck.jsonp.api.common.SimpleValues;
import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.patchtests.CommonOperation;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonPatchBuilder;
import jakarta.json.JsonValue;
import java.util.logging.Logger;

public class PatchOperationReplace
extends CommonOperation {
    private static final Logger LOGGER = Logger.getLogger(PatchOperationReplace.class.getName());
    private final String OPERATION = "REPLACE";

    PatchOperationReplace() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 6902 replace operation");
        LOGGER.info("Testing RFC 6902 replace operation:");
        this.testReplaceStringOnSimpleObject(result);
        this.testReplaceStringOnSimpleArray(result);
        this.testReplaceStringOnSimpleArray2(result);
        this.testReplaceIntOnSimpleObject(result);
        this.testReplaceIntOnSimpleArray(result);
        this.testReplaceIntOnSimpleArray2(result);
        this.testReplaceBoolOnSimpleObject(result);
        this.testReplaceBoolOnSimpleArray(result);
        this.testReplaceBoolOnSimpleArray2(result);
        this.testReplaceObjectOnCompoundObject(result);
        this.testReplaceObjectOnSimpleArray(result);
        this.testReplaceObjectOnSimpleArray2(result);
        this.testReplaceOfNonExistingLocationInObject(result);
        this.testReplaceOfNonExistingLocationInArray(result);
        return result;
    }

    private void testReplaceStringOnSimpleObject(TestResult result) {
        LOGGER.info(" - for String on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectStr();
        JsonObject check = SimpleValues.createSimpleObjectReplaceStr();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/address", "In a land of myth");
    }

    private void testReplaceStringOnSimpleArray(TestResult result) {
        LOGGER.info(" - for String on simple JSON array of size 1");
        JsonArray in = SimpleValues.createStringArray1();
        JsonArray check = SimpleValues.createSimpleStringArrayReplaceStr();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", "In a galaxy far far away");
    }

    private void testReplaceStringOnSimpleArray2(TestResult result) {
        LOGGER.info(" - for String on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleStringArray5();
        JsonArray check = SimpleValues.createSimpleStringArray5R();
        this.complexOperation(result, in, check, new String[]{"/4", "/3", "/1", "/0"}, new String[]{"First value", "Second value", "Fourth value", "Fifth value"});
        this.complexOperation(result, in, check, new String[]{"/0", "/1", "/3", "/4"}, new String[]{"Fifth value", "Fourth value", "Second value", "First value"});
    }

    private void testReplaceIntOnSimpleObject(TestResult result) {
        LOGGER.info(" - for int on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectInt();
        JsonObject check = SimpleValues.createSimpleObjectReplaceInt();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/age", 32);
    }

    private void testReplaceIntOnSimpleArray(TestResult result) {
        LOGGER.info(" - for int on simple JSON array of size 1");
        JsonArray in = SimpleValues.createIntArray1();
        JsonArray check = SimpleValues.createSimpleIntArrayReplaceInt();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", 42);
    }

    private void testReplaceIntOnSimpleArray2(TestResult result) {
        LOGGER.info(" - for int on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleIntArray5();
        JsonArray check = SimpleValues.createSimpleIntArray5R();
        this.complexOperation(result, in, check, new String[]{"/4", "/3", "/1", "/0"}, new Integer[]{1, 2, 4, 5});
        this.complexOperation(result, in, check, new String[]{"/0", "/1", "/3", "/4"}, new Integer[]{5, 4, 2, 1});
    }

    private void testReplaceBoolOnSimpleObject(TestResult result) {
        LOGGER.info(" - for boolean on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectBool();
        JsonObject check = SimpleValues.createSimpleObjectReplaceBool();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/married", false);
    }

    private void testReplaceBoolOnSimpleArray(TestResult result) {
        LOGGER.info(" - for boolean on simple JSON array of size 1");
        JsonArray in = SimpleValues.createBoolArray1();
        JsonArray check = SimpleValues.createSimpleBoolArrayReplaceBool();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", false);
    }

    private void testReplaceBoolOnSimpleArray2(TestResult result) {
        LOGGER.info(" - for boolean on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleBoolArray5();
        JsonArray check = SimpleValues.createSimpleBoolArray5R();
        this.complexOperation(result, in, check, new String[]{"/4", "/3", "/1", "/0"}, new Boolean[]{false, true, false, true});
        this.complexOperation(result, in, check, new String[]{"/0", "/1", "/3", "/4"}, new Boolean[]{true, false, true, false});
    }

    private void testReplaceObjectOnCompoundObject(TestResult result) {
        LOGGER.info(" - for JsonObject on simple JSON object");
        JsonObject in = SimpleValues.createCompoundObjectWithObject();
        JsonObject check = SimpleValues.createCompoundObjectReplaceObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/wife", SimpleValues.OBJ_VALUE2);
    }

    private void testReplaceObjectOnSimpleArray(TestResult result) {
        LOGGER.info(" - for JsonObject on simple JSON array of size 1");
        JsonArray in = SimpleValues.createObjectArray1();
        JsonArray check = SimpleValues.createSimpleObjectArrayReplaceObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", SimpleValues.OBJ_VALUE);
    }

    private void testReplaceObjectOnSimpleArray2(TestResult result) {
        LOGGER.info(" - for JsonObject on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleObjectArray5();
        JsonArray check = SimpleValues.createSimpleObjectArray5R();
        this.complexOperation(result, in, check, new String[]{"/4", "/3", "/1", "/0"}, new JsonObject[]{SimpleValues.OBJ_VALUE_1, SimpleValues.OBJ_VALUE_2, SimpleValues.OBJ_VALUE_4, SimpleValues.OBJ_VALUE_5});
        this.complexOperation(result, in, check, new String[]{"/0", "/1", "/3", "/4"}, new JsonObject[]{SimpleValues.OBJ_VALUE_5, SimpleValues.OBJ_VALUE_4, SimpleValues.OBJ_VALUE_2, SimpleValues.OBJ_VALUE_1});
    }

    private void testReplaceOfNonExistingLocationInObject(TestResult result) {
        LOGGER.info(" - for non existing location in JsonObject");
        JsonObject[] objsIn = new JsonObject[]{SimpleValues.createEmptyObject(), SimpleValues.createSimpleObject(), SimpleValues.createCompoundObject()};
        String[] paths = new String[]{"/address", "/age", "/married", "/wife"};
        Object[] values = new Object[]{"In a galaxy far far away", 42, true, SimpleValues.OBJ_VALUE};
        for (int i = 0; i < objsIn.length; ++i) {
            for (int j = 0; j < paths.length; ++j) {
                this.simpleOperationFail(result, (JsonValue)objsIn[i], paths[j], values[i]);
            }
        }
    }

    private void testReplaceOfNonExistingLocationInArray(TestResult result) {
        LOGGER.info(" - for non existing location in JsonArray");
        JsonArray[] arraysIn = new JsonArray[]{SimpleValues.createEmptyArray(), SimpleValues.createStringArray1(), SimpleValues.createIntArray2(), SimpleValues.createSimpleBoolArray5(), SimpleValues.createObjectArray2()};
        String[] paths = new String[]{"/", "/-1", "/-", "/5", "/0a", "/42", "/address/0"};
        Object[] values = new Object[]{"In a galaxy far far away", "In a galaxy far far away", 42, true, SimpleValues.OBJ_VALUE};
        for (int i = 0; i < arraysIn.length; ++i) {
            for (int j = 0; j < paths.length; ++j) {
                this.simpleOperationFail(result, (JsonValue)arraysIn[i], paths[j], values[i]);
            }
        }
    }

    @Override
    protected String operationName() {
        return "REPLACE";
    }

    @Override
    protected JsonPatchBuilder createOperationBuilder(String path, Object value) {
        return PatchOperationReplace.builderReplace(Json.createPatchBuilder(), path, value);
    }

    @Override
    protected JsonPatchBuilder updateOperationBuilder(JsonPatchBuilder builder, String path, Object value) {
        return PatchOperationReplace.builderReplace(builder, path, value);
    }

    private static JsonPatchBuilder builderReplace(JsonPatchBuilder builder, String path, Object value) {
        switch (JsonValueType.getType(value.getClass())) {
            case String: {
                return builder.replace(path, (String)value);
            }
            case Integer: {
                return builder.replace(path, ((Integer)value).intValue());
            }
            case Boolean: {
                return builder.replace(path, ((Boolean)value).booleanValue());
            }
            case JsonValue: {
                return builder.replace(path, (JsonValue)value);
            }
        }
        throw new IllegalArgumentException("Value does not match known JSON value type");
    }
}

