/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.mergetests;

import ee.jakarta.tck.jsonp.api.common.SimpleValues;
import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.mergetests.MergeCommon;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.logging.Logger;

public class MergeNonObject
extends MergeCommon {
    private static final Logger LOGGER = Logger.getLogger(MergeNonObject.class.getName());

    MergeNonObject() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 7396: Non object patch");
        LOGGER.info("Testing RFC 7396: Non object patch");
        this.testStringOnEmptyObject(result);
        this.testStringOnSimpleObject(result);
        this.testStringOnSimpleArray(result);
        this.testIntOnEmptyObject(result);
        this.testIntOnSimpleObject(result);
        this.testIntOnSimpleArray(result);
        this.testBoolOnEmptyObject(result);
        this.testBoolOnSimpleObject(result);
        this.testBoolOnSimpleArray(result);
        this.testArrayOnEmptyObject(result);
        this.testArrayOnCompoundObject(result);
        this.testArrayOnSimpleArray(result);
        return result;
    }

    private void testStringOnEmptyObject(TestResult result) {
        LOGGER.info(" - for String on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonString patch = Json.createValue((String)"In a galaxy far far away");
        JsonString check = Json.createValue((String)"In a galaxy far far away");
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testStringOnSimpleObject(TestResult result) {
        LOGGER.info(" - for String on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectWithStr();
        JsonString patch = Json.createValue((String)"In a galaxy far far away");
        JsonString check = Json.createValue((String)"In a galaxy far far away");
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testStringOnSimpleArray(TestResult result) {
        LOGGER.info(" - for String on simple JSON array");
        JsonArray in = SimpleValues.createStringArray2();
        JsonString patch = Json.createValue((String)"In a galaxy far far away");
        JsonString check = Json.createValue((String)"In a galaxy far far away");
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testIntOnEmptyObject(TestResult result) {
        LOGGER.info(" - for int on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonNumber patch = Json.createValue((int)42);
        JsonNumber check = Json.createValue((int)42);
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testIntOnSimpleObject(TestResult result) {
        LOGGER.info(" - for int on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectWithInt();
        JsonNumber patch = Json.createValue((int)42);
        JsonNumber check = Json.createValue((int)42);
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testIntOnSimpleArray(TestResult result) {
        LOGGER.info(" - for int on simple JSON array");
        JsonArray in = SimpleValues.createIntArray2();
        JsonNumber patch = Json.createValue((int)42);
        JsonNumber check = Json.createValue((int)42);
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testBoolOnEmptyObject(TestResult result) {
        LOGGER.info(" - for boolean on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonValue patch = SimpleValues.toJsonValue(true);
        JsonValue check = SimpleValues.toJsonValue(true);
        this.simpleMerge(result, (JsonValue)in, patch, check);
        this.simpleDiff(result, (JsonValue)in, check, patch);
    }

    private void testBoolOnSimpleObject(TestResult result) {
        LOGGER.info(" - for boolean on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectWithBool();
        JsonValue patch = SimpleValues.toJsonValue(true);
        JsonValue check = SimpleValues.toJsonValue(true);
        this.simpleMerge(result, (JsonValue)in, patch, check);
        this.simpleDiff(result, (JsonValue)in, check, patch);
    }

    private void testBoolOnSimpleArray(TestResult result) {
        LOGGER.info(" - for boolean on simple JSON array");
        JsonArray in = SimpleValues.createBoolArray2();
        JsonValue patch = SimpleValues.toJsonValue(true);
        JsonValue check = SimpleValues.toJsonValue(true);
        this.simpleMerge(result, (JsonValue)in, patch, check);
        this.simpleDiff(result, (JsonValue)in, check, patch);
    }

    private void testArrayOnEmptyObject(TestResult result) {
        LOGGER.info(" - for JsonArray on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonArray patch = SimpleValues.createStringArray1();
        JsonArray check = SimpleValues.createStringArray1();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testArrayOnCompoundObject(TestResult result) {
        LOGGER.info(" - for JsonArray on compound JSON object");
        JsonObject in = SimpleValues.createCompoundObject();
        JsonArray patch = SimpleValues.createStringArray2();
        JsonArray check = SimpleValues.createStringArray2();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testArrayOnSimpleArray(TestResult result) {
        LOGGER.info(" - for JsonArray on simple JSON array");
        JsonArray in = SimpleValues.createBoolArray2();
        JsonArray patch = SimpleValues.createIntArray2();
        JsonArray check = SimpleValues.createIntArray2();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }
}

