/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.provider;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Logger;

public class MyJsonWriter
implements JsonWriter {
    private static final Logger LOGGER = Logger.getLogger(MyJsonWriter.class.getName());
    private OutputStream out = null;
    private Writer writer = null;
    private Charset charset = Charset.forName("UTF-8");
    private static StringBuilder calls = new StringBuilder();

    private void dumpInstanceVars() {
        LOGGER.info("writer=" + this.writer);
        LOGGER.info("out=" + this.out);
        LOGGER.info("charset=" + this.charset);
    }

    public static String getCalls() {
        return calls.toString();
    }

    public static void clearCalls() {
        calls.delete(0, calls.length());
    }

    private static void addCalls(String s) {
        calls.append(s);
    }

    public MyJsonWriter() {
    }

    public MyJsonWriter(OutputStream out) {
        this.out = out;
    }

    public MyJsonWriter(Writer writer) {
        this.writer = writer;
    }

    public void close() {
        LOGGER.info("public void close()");
        MyJsonWriter.addCalls("public void close()");
    }

    public void write(JsonStructure value) {
        LOGGER.info("public void write(JsonStructure)");
        MyJsonWriter.addCalls("public void write(JsonStructure)");
    }

    public void writeArray(JsonArray array) {
        LOGGER.info("public void writeArray(JsonArray)");
        MyJsonWriter.addCalls("public void writeArray(JsonArray)");
    }

    public void writeObject(JsonObject object) {
        LOGGER.info("public void writeObject(JsonObject)");
        MyJsonWriter.addCalls("public void writeObject(JsonObject)");
    }
}

