/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import com.sun.javatest.util.PathClassLoader;
import com.sun.javatest.util.WriterStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JavaCompileCommand
extends Command {
    public static boolean defaultVerbose = Boolean.getBoolean("javatest.JavaCompileCommand.verbose");
    private boolean verbose = defaultVerbose;
    private PrintWriter log;
    private static final Status passed = Status.passed("Compilation successful");
    private static final Status failed = Status.failed("Compilation failed");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Status s;
        PrintWriter out = new PrintWriter(System.out);
        PrintWriter err = new PrintWriter(System.err);
        try {
            JavaCompileCommand c = new JavaCompileCommand();
            s = c.run(args, out, err);
        }
        finally {
            out.flush();
            err.flush();
        }
        s.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status run(String[] args, PrintWriter log, PrintWriter ref) {
        int i;
        if (args.length == 0) {
            return Status.error("No args supplied");
        }
        String compilerClassName = null;
        String compilerName = null;
        String classpath = null;
        String[] options = null;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-")) continue;
            options = new String[i];
            System.arraycopy(args, 0, options, 0, options.length);
            args = JavaCompileCommand.shift(args, i + 1);
            break;
        }
        if (options != null) {
            for (i = 0; i < options.length; ++i) {
                if (options[i].equals("-compiler")) {
                    String s;
                    int colon;
                    if (i + 1 == options.length) {
                        return Status.error("No compiler specified after -compiler option");
                    }
                    if ((colon = (s = options[++i]).indexOf(":")) == -1) {
                        compilerClassName = s;
                        compilerName = "java " + s;
                        continue;
                    }
                    compilerClassName = s.substring(colon + 1);
                    compilerName = s.substring(0, colon);
                    continue;
                }
                if (options[i].equals("-cp") || options[i].equals("-classpath")) {
                    if (i + 1 == options.length) {
                        return Status.error("No path specified after -cp or -classpath option");
                    }
                    classpath = options[++i];
                    continue;
                }
                if (options[i].equals("-verbose")) {
                    this.verbose = true;
                    continue;
                }
                return Status.error("Unrecognized option: " + options[i]);
            }
        }
        this.log = log;
        try {
            Object result;
            Object compiler;
            Object[] compileMethodArgs;
            Class compilerClass;
            PathClassLoader loader = classpath == null ? null : new PathClassLoader(classpath);
            if (compilerClassName != null) {
                compilerClass = this.getClass(loader, compilerClassName);
                if (compilerClass == null) {
                    Status colon = Status.error("Cannot find compiler: " + compilerClassName);
                    return colon;
                }
            } else {
                compilerName = "javac";
                compilerClass = this.getClass(loader, "com.sun.tools.javac.Main");
                if (compilerClass == null) {
                    compilerClass = this.getClass(loader, "sun.tools.javac.Main");
                }
                if (compilerClass == null) {
                    Status colon = Status.error("Cannot find compiler");
                    return colon;
                }
            }
            loader = null;
            Method compileMethod = this.getMethod(compilerClass, "compile", new Class[]{String[].class, PrintWriter.class});
            if (compileMethod != null) {
                compileMethodArgs = new Object[]{args, ref};
            } else {
                compileMethod = this.getMethod(compilerClass, "compile", new Class[]{String[].class});
                if (compileMethod != null) {
                    compileMethodArgs = new Object[]{args};
                } else {
                    Status status = Status.error("Cannot find compile method for " + compilerClass.getName());
                    return status;
                }
            }
            if (Modifier.isStatic(compileMethod.getModifiers())) {
                compiler = null;
            } else {
                Object[] constrArgs;
                Constructor constr = this.getConstructor(compilerClass, new Class[]{OutputStream.class, String.class});
                if (constr != null) {
                    constrArgs = new Object[]{new WriterStream(ref), compilerName};
                } else {
                    constr = this.getConstructor(compilerClass, new Class[0]);
                    if (constr != null) {
                        constrArgs = new Object[]{};
                    } else {
                        Status status = Status.error("Cannot find suitable constructor for " + compilerClass.getName());
                        return status;
                    }
                }
                try {
                    compiler = constr.newInstance(constrArgs);
                }
                catch (Throwable t) {
                    t.printStackTrace(log);
                    Status status = Status.error("Cannot instantiate compiler");
                    log.flush();
                    ref.flush();
                    return status;
                }
            }
            try {
                result = compileMethod.invoke(compiler, compileMethodArgs);
            }
            catch (Throwable t) {
                t.printStackTrace(log);
                Status status = Status.error("Error invoking compiler");
                log.flush();
                ref.flush();
                return status;
            }
            if (result instanceof Boolean) {
                boolean ok = (Boolean)result;
                Status status = ok ? passed : failed;
                return status;
            }
            if (result instanceof Integer) {
                int rc = (Integer)result;
                Status status = rc == 0 ? passed : failed;
                return status;
            }
            Status status = Status.error("Unexpected return value from compiler: " + result);
            return status;
        }
        finally {
            log.flush();
            ref.flush();
        }
    }

    private Class getClass(ClassLoader loader, String name) {
        try {
            return loader == null ? Class.forName(name) : loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Constructor getConstructor(Class c, Class[] argTypes) {
        try {
            return c.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Throwable t) {
            if (this.verbose) {
                t.printStackTrace(this.log);
            }
            return null;
        }
    }

    private Method getMethod(Class c, String name, Class[] argTypes) {
        try {
            return c.getMethod(name, argTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Throwable t) {
            if (this.verbose) {
                t.printStackTrace(this.log);
            }
            return null;
        }
    }

    private static String[] shift(String[] args, int n) {
        String[] newArgs = new String[args.length - n];
        System.arraycopy(args, n, newArgs, 0, newArgs.length);
        return newArgs;
    }
}

