/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

class VerifySMAP {
    private static final int INIT_SIZE_FILE = 3;
    private static final int INIT_SIZE_LINE = 100;
    private static final int INIT_SIZE_STRATUM = 3;
    static final String BASE_STRATUM_NAME = "Java";
    private FileTableRecord[] fileTable = null;
    private LineTableRecord[] lineTable = null;
    private StratumTableRecord[] stratumTable = null;
    private int fileIndex = 0;
    private int lineIndex = 0;
    private int stratumIndex = 0;
    private int currentFileId = 0;
    private int defaultStratumIndex = -1;
    private String jplsFilename = null;
    private String defaultStratumId = null;
    private boolean parseComplete = false;
    private static int sdePos = 0;
    private static int lineNumber = 1;
    private static String smap;
    private static String source;
    private static boolean resolved;

    static void configError(String string) {
        System.err.println(source + ": Configuration error - " + string);
        throw new RuntimeException(string);
    }

    static byte[] readWhole(String string) throws IOException {
        int n;
        byte[] byArray;
        FileInputStream fileInputStream;
        long l;
        File file = new File(string);
        if (!file.exists()) {
            VerifySMAP.configError("File does not exists");
        }
        if ((l = file.length()) > Integer.MAX_VALUE) {
            VerifySMAP.configError("File too big to verify");
        }
        if ((fileInputStream = new FileInputStream(file)).read(byArray = new byte[n = (int)l], 0, n) != n) {
            VerifySMAP.configError("unexpected size of read file, expected size: " + n);
        }
        fileInputStream.close();
        return byArray;
    }

    VerifySMAP(String string, boolean bl) {
        smap = string;
        resolved = bl;
    }

    VerifySMAP() {
    }

    char sdePeek() {
        if (sdePos >= smap.length()) {
            this.syntax("unexpected end of SMAP");
        }
        return smap.charAt(sdePos);
    }

    char sdeRead() {
        if (sdePos >= smap.length()) {
            this.syntax("unexpected end of SMAP");
        }
        return smap.charAt(sdePos++);
    }

    void sdeAdvance() {
        ++sdePos;
    }

    void error(int n, String string, String string2) {
        System.err.println("Assertion #" + n + " failed - " + string);
        System.err.println(source + (this.parseComplete ? "" : ":" + lineNumber) + ": " + string2);
        throw new AssertionViolationException(n, string);
    }

    void error(int n, String string) {
        System.err.println(source + (this.parseComplete ? "" : ":" + lineNumber) + ": Assertion #" + n + " failed - " + string);
        throw new AssertionViolationException(n, string);
    }

    void syntax(String string) {
        this.error(1, "SMAP syntax error", string);
    }

    void assureLineTableSize() {
        int n;
        int n2 = n = this.lineTable == null ? 0 : this.lineTable.length;
        if (this.lineIndex >= n) {
            int n3;
            int n4 = n == 0 ? 100 : n * 2;
            LineTableRecord[] lineTableRecordArray = new LineTableRecord[n4];
            for (n3 = 0; n3 < n; ++n3) {
                lineTableRecordArray[n3] = this.lineTable[n3];
            }
            while (n3 < n4) {
                lineTableRecordArray[n3] = new LineTableRecord();
                ++n3;
            }
            this.lineTable = lineTableRecordArray;
        }
    }

    void assureFileTableSize() {
        int n;
        int n2 = n = this.fileTable == null ? 0 : this.fileTable.length;
        if (this.fileIndex >= n) {
            int n3;
            int n4 = n == 0 ? 3 : n * 2;
            FileTableRecord[] fileTableRecordArray = new FileTableRecord[n4];
            for (n3 = 0; n3 < n; ++n3) {
                fileTableRecordArray[n3] = this.fileTable[n3];
            }
            while (n3 < n4) {
                fileTableRecordArray[n3] = new FileTableRecord();
                ++n3;
            }
            this.fileTable = fileTableRecordArray;
        }
    }

    void assureStratumTableSize() {
        int n;
        int n2 = n = this.stratumTable == null ? 0 : this.stratumTable.length;
        if (this.stratumIndex >= n) {
            int n3;
            int n4 = n == 0 ? 3 : n * 2;
            StratumTableRecord[] stratumTableRecordArray = new StratumTableRecord[n4];
            for (n3 = 0; n3 < n; ++n3) {
                stratumTableRecordArray[n3] = this.stratumTable[n3];
            }
            while (n3 < n4) {
                stratumTableRecordArray[n3] = new StratumTableRecord();
                ++n3;
            }
            this.stratumTable = stratumTableRecordArray;
        }
    }

    String readLine() {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        this.ignoreWhite();
        while ((c = this.sdeRead()) != '\n' && c != '\r') {
            stringBuffer.append(c);
        }
        if (c == '\r' && this.sdePeek() == '\n') {
            this.sdeRead();
        }
        this.ignoreWhite();
        ++lineNumber;
        return stringBuffer.toString().trim();
    }

    private int defaultStratumTableIndex() {
        if (this.defaultStratumIndex == -1 && this.defaultStratumId != null) {
            this.defaultStratumIndex = this.stratumTableIndex(this.defaultStratumId);
        }
        return this.defaultStratumIndex;
    }

    int stratumTableIndex(String string) {
        if (string == null) {
            return this.defaultStratumTableIndex();
        }
        for (int i = 0; i < this.stratumIndex - 1; ++i) {
            if (!this.stratumTable[i].id.equals(string)) continue;
            return i;
        }
        return this.defaultStratumTableIndex();
    }

    void ignoreWhite() {
        char c;
        while ((c = this.sdePeek()) == ' ' || c == '\t') {
            this.sdeAdvance();
        }
    }

    void skipRemainingWhite() {
        this.ignoreWhite();
        char c = this.sdeRead();
        if (c != '\n' && c != '\r') {
            this.syntax("unexpected characters at end of line: " + c + this.readLine());
        }
        if (c == '\r' && this.sdePeek() == '\n') {
            this.sdeAdvance();
        }
        this.ignoreWhite();
        ++lineNumber;
    }

    int readNumber() {
        int n = 0;
        this.ignoreWhite();
        char c = this.sdePeek();
        if (c < '0' || c > '9') {
            this.syntax("Number expected");
        }
        while ((c = this.sdePeek()) >= '0' && c <= '9') {
            this.sdeAdvance();
            n = n * 10 + c - 48;
        }
        this.ignoreWhite();
        return n;
    }

    void storeFile(int n, String string, String string2) {
        this.assureFileTableSize();
        this.fileTable[this.fileIndex].fileId = n;
        this.fileTable[this.fileIndex].sourceName = string;
        this.fileTable[this.fileIndex].sourcePath = string2;
        ++this.fileIndex;
    }

    void fileLine() {
        String string;
        int n;
        boolean bl = false;
        String string2 = null;
        if (this.sdePeek() == '+') {
            this.sdeAdvance();
            bl = true;
        }
        if (this.fileTableIndex(this.stratumIndex - 1, n = this.readNumber()) != -1) {
            this.error(7, "In a FileSection, each FileId must be unique within that FileSection", "FileId = " + n);
        }
        if ((string = this.readLine()).length() == 0) {
            this.error(8, "In a FileSection, the FileName must be non empty");
        }
        if (bl && (string2 = this.readLine()).length() == 0) {
            this.error(9, "In a FileSection, the AbsoluteFileName, if specified, must be non empty");
        }
        this.storeFile(n, string, string2);
    }

    void storeLine(int n, int n2, int n3, int n4, int n5, int n6) {
        this.assureLineTableSize();
        this.lineTable[this.lineIndex].jplsStart = n;
        this.lineTable[this.lineIndex].jplsEnd = n2;
        this.lineTable[this.lineIndex].jplsLineInc = n3;
        this.lineTable[this.lineIndex].njplsStart = n4;
        this.lineTable[this.lineIndex].njplsEnd = n5;
        this.lineTable[this.lineIndex].fileId = n6;
        ++this.lineIndex;
    }

    void lineLine() {
        int n;
        int n2 = 1;
        int n3 = 1;
        int n4 = this.readNumber();
        if (n4 < 1) {
            this.error(14, "In a LineSection, InputStartLine must be greater than or equal to one", "InputStartLine = " + n4);
        }
        if (this.sdePeek() == '#') {
            this.sdeAdvance();
            this.currentFileId = this.readNumber();
        }
        if (this.sdePeek() == ',') {
            this.sdeAdvance();
            n2 = this.readNumber();
            if (n2 < 1) {
                this.error(12, "In a LineSection, RepeatCount must be greater than or equal to one", "RepeatCount = " + n2);
            }
        }
        if (this.sdeRead() != ':') {
            this.syntax("expected a ':'");
        }
        if ((n = this.readNumber()) < 1) {
            this.error(15, "In a LineSection,  OutputStartLine  must be greater than or equal to one", "OutputStartLine = " + n);
        }
        if (this.sdePeek() == ',') {
            this.sdeAdvance();
            n3 = this.readNumber();
        }
        this.skipRemainingWhite();
        this.storeLine(n, n + n2 * n3 - 1, n3, n4, n4 + n2 - 1, this.currentFileId);
    }

    void storeStratum(String string) {
        this.assureStratumTableSize();
        this.stratumTable[this.stratumIndex].id = string;
        this.stratumTable[this.stratumIndex].fileIndex = this.fileIndex;
        this.stratumTable[this.stratumIndex].lineIndex = this.lineIndex;
        this.stratumTable[this.stratumIndex].fileSectionCount = 0;
        this.stratumTable[this.stratumIndex].lineSectionCount = 0;
        ++this.stratumIndex;
        this.currentFileId = 0;
    }

    void stratumSection() {
        String string = this.readLine();
        if (string.equals(BASE_STRATUM_NAME)) {
            this.error(4, "'Java' stratum cannot be defined");
        }
        this.storeStratum(string);
    }

    void fileSection() {
        this.skipRemainingWhite();
        if (this.stratumIndex == 0) {
            this.error(5, "FileSection must only occur after StratumSection");
        } else {
            ++this.stratumTable[this.stratumIndex - 1].fileSectionCount;
        }
        while (this.sdePeek() != '*') {
            this.fileLine();
        }
    }

    void lineSection() {
        this.skipRemainingWhite();
        if (this.stratumIndex == 0) {
            this.error(10, "LineSection must only occur after StratumSection");
        } else {
            ++this.stratumTable[this.stratumIndex - 1].lineSectionCount;
        }
        while (this.sdePeek() != '*') {
            this.lineLine();
        }
    }

    void vendorSection() {
        this.skipRemainingWhite();
        String string = this.readLine();
        if (string.length() == 0) {
            this.error(17, "VENDORID missing");
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            this.error(17, "VENDORID contains invalid character", "Bad character: '" + c + "' at position " + i);
        }
        this.ignoreSection();
    }

    void openEmbeddedSection() {
        String string;
        char c;
        String string2;
        if (resolved) {
            this.error(20, "An embedded SMAP must not occur in a resolved SMAP");
        }
        if ((string2 = this.readLine()).length() == 0) {
            this.syntax("Output StratumID missing");
        }
        do {
            VerifySMAP verifySMAP;
            if ((verifySMAP = new VerifySMAP()).decode()) {
                verifySMAP.verify();
            }
            this.skipRemainingWhite();
        } while (this.sdePeek() != '*');
        if (this.sdeRead() != '*') {
            this.syntax("expected a '*'");
        }
        if ((c = this.sdeRead()) != 'C') {
            this.error(21, "CloseEmbeddedSection must terminate an OpenEmbeddedSection", "expected a CloseEmbeddedSection - '*C'");
        }
        if (!(string = this.readLine()).equals(string2)) {
            this.error(22, "StratumId of CloseEmbeddedSection does not match StratumId of OpenEmbeddedSection", "'" + string + "' vs. '" + string2 + "'");
        }
    }

    void ignoreSection() {
        while (this.sdePeek() != '*') {
            this.readLine();
        }
    }

    boolean decode() {
        if (smap.length() < 4 || this.sdeRead() != 'S' || this.sdeRead() != 'M' || this.sdeRead() != 'A' || this.sdeRead() != 'P') {
            this.syntax("Not an SMAP - does not start with 'SMAP'");
        }
        this.skipRemainingWhite();
        this.jplsFilename = this.readLine();
        this.defaultStratumId = this.readLine();
        block8: while (true) {
            if (this.sdeRead() != '*') {
                this.syntax("expected a '*'");
            }
            char c = this.sdeRead();
            switch (c) {
                case 'S': {
                    this.stratumSection();
                    continue block8;
                }
                case 'F': {
                    this.fileSection();
                    continue block8;
                }
                case 'L': {
                    this.lineSection();
                    continue block8;
                }
                case 'V': {
                    this.vendorSection();
                    continue block8;
                }
                case 'E': {
                    this.storeStratum("*terminator*");
                    this.parseComplete = true;
                    return true;
                }
                case 'O': {
                    this.openEmbeddedSection();
                    continue block8;
                }
            }
            this.error(18, "Unknown section type", "Section type: *" + c);
            this.ignoreSection();
        }
    }

    void verify() {
        int n;
        int n2;
        if (this.stratumIndex == 0) {
            this.error(19, "There must be at least one StratumSection");
        }
        if (this.defaultStratumId.length() == 0) {
            if (resolved) {
                this.error(2, "resolved SMAP with unspecified DefaultStratumId");
            }
        } else if (!this.defaultStratumId.equals(BASE_STRATUM_NAME)) {
            n2 = 0;
            for (n = 0; n < this.stratumIndex; ++n) {
                if (!this.stratumTable[n].id.equals(this.defaultStratumId)) continue;
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                this.error(3, "DefaultStratumId is not a valid stratum", "DefaultStratumId = '" + this.defaultStratumId + "'");
            }
        }
        for (n2 = 0; n2 < this.stratumIndex - 1; ++n2) {
            if (this.stratumTable[n2].fileSectionCount == 1) continue;
            this.error(6, "There must be exactly one FileSection after each StratumSection", "There are " + this.stratumTable[n2].fileSectionCount + " file sections");
        }
        for (n2 = 0; n2 < this.stratumIndex - 1; ++n2) {
            if (this.stratumTable[n2].lineSectionCount == 1) continue;
            this.error(11, "There must be exactly one LineSection after each StratumSection", "There are " + this.stratumTable[n2].lineSectionCount + " line sections");
        }
        for (n2 = 0; n2 < this.stratumIndex - 1; ++n2) {
            n = this.stratumTable[n2].lineIndex;
            int n3 = this.stratumTable[n2 + 1].lineIndex;
            for (int i = n; i < n3; ++i) {
                if (this.fileTableIndex(n2, this.lineTable[i].fileId) != -1) continue;
                this.error(16, "In a LineSection, LineFileId must be a FileId in the FileSection after the same StratumSection", "FileId " + this.lineTable[i].fileId + " not found");
            }
        }
    }

    private int stiLineTableIndex(int n, int n2) {
        int n3 = this.stratumTable[n].lineIndex;
        int n4 = this.stratumTable[n + 1].lineIndex;
        for (int i = n3; i < n4; ++i) {
            if (n2 < this.lineTable[i].jplsStart || n2 > this.lineTable[i].jplsEnd) continue;
            return i;
        }
        return -1;
    }

    private int stiLineNumber(int n, int n2, int n3) {
        return this.lineTable[n2].njplsStart + (n3 - this.lineTable[n2].jplsStart) / this.lineTable[n2].jplsLineInc;
    }

    private int fileTableIndex(int n, int n2) {
        int n3 = this.stratumTable[n].fileIndex;
        int n4 = this.stratumTable[n + 1].fileIndex;
        for (int i = n3; i < n4; ++i) {
            if (this.fileTable[i].fileId != n2) continue;
            return i;
        }
        return -1;
    }

    private int stiFileTableIndex(int n, int n2) {
        return this.fileTableIndex(n, this.lineTable[n2].fileId);
    }

    public static void main(String[] stringArray) throws IOException {
        String string;
        if (stringArray.length != 1) {
            VerifySMAP.configError("Must be exactly one argument (the SMAP or class file to verify)");
        }
        System.out.println();
        source = stringArray[0];
        boolean bl = false;
        if (source.endsWith(".class")) {
            string = new ExtractSDE(source).parseClassFile();
            bl = true;
        } else {
            string = new String(VerifySMAP.readWhole(source));
        }
        VerifySMAP verifySMAP = new VerifySMAP(string, bl);
        if (verifySMAP.decode()) {
            verifySMAP.verify();
        }
        System.out.println(source + (bl ? " contains" : " is") + " a correctly formatted SMAP");
    }

    class AssertionViolationException
    extends RuntimeException {
        final int assertionNumber;
        final String message;

        AssertionViolationException(int n, String string) {
            super("assertion #" + n + " failed - " + string);
            this.assertionNumber = n;
            this.message = string;
        }
    }

    static class ExtractSDE {
        static final String nameSDE = "SourceDebugExtension";
        final byte[] classFile;
        int classFilePos = 0;

        ExtractSDE(String string) throws IOException {
            this.classFile = VerifySMAP.readWhole(string);
        }

        String parseClassFile() {
            long l = this.readU4();
            if (l != 3405691582L) {
                VerifySMAP.configError("class file not in Java Virtual Machine class file format - bad value of magic: 0x" + Long.toHexString(l));
            }
            this.skip(4);
            int n = this.readConstantPool();
            if (n == 0) {
                VerifySMAP.configError("No Source Debug Extension in this class file (attribute name not defined)");
            }
            this.skip(6);
            int n2 = this.readU2();
            this.skip(n2 * 2);
            this.skipMembers();
            this.skipMembers();
            int n3 = this.readU2();
            for (int i = 0; i < n3; ++i) {
                String string = this.readAttr(n);
                if (string == null) continue;
                return string;
            }
            VerifySMAP.configError("No Source Debug Extension in this class file");
            return null;
        }

        void skipMembers() {
            int n = this.readU2();
            for (int i = 0; i < n; ++i) {
                this.skip(6);
                int n2 = this.readU2();
                for (int j = 0; j < n2; ++j) {
                    this.skipAttr();
                }
            }
        }

        void skipAttr() {
            this.skip(2);
            int n = (int)this.readU4();
            this.skip(n);
        }

        String readAttr(int n) {
            int n2 = this.readU2();
            int n3 = (int)this.readU4();
            if (n2 == n) {
                return this.read(n3);
            }
            this.skip(n3);
            return null;
        }

        int readU1() {
            return this.classFile[this.classFilePos++] & 0xFF;
        }

        int readU2() {
            int n = this.readU1();
            return (n << 8) + this.readU1();
        }

        long readU4() {
            long l = this.readU2();
            return (l << 16) + (long)this.readU2();
        }

        String read(int n) {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.classFile[this.classFilePos++];
            }
            return new String(byArray);
        }

        void skip(int n) {
            this.classFilePos += n;
        }

        int readConstantPool() {
            int n = 0;
            int n2 = this.readU2();
            block6: for (int i = 1; i < n2; ++i) {
                int n3 = this.readU1();
                switch (n3) {
                    case 7: 
                    case 8: {
                        this.skip(2);
                        continue block6;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        this.skip(4);
                        continue block6;
                    }
                    case 5: 
                    case 6: {
                        this.skip(8);
                        ++i;
                        continue block6;
                    }
                    case 1: {
                        int n4 = this.readU2();
                        String string = this.read(n4);
                        if (!string.equals(nameSDE)) continue block6;
                        n = i;
                        continue block6;
                    }
                    default: {
                        VerifySMAP.configError("bad class file - unexpected constant pool tag: " + n3);
                    }
                }
            }
            return n;
        }
    }

    private class StratumTableRecord {
        String id;
        int fileIndex;
        int lineIndex;
        int fileSectionCount;
        int lineSectionCount;

        private StratumTableRecord() {
        }
    }

    private class LineTableRecord {
        int jplsStart;
        int jplsEnd;
        int jplsLineInc;
        int njplsStart;
        int njplsEnd;
        int fileId;

        private LineTableRecord() {
        }
    }

    private class FileTableRecord {
        int fileId;
        String sourceName;
        String sourcePath;

        private FileTableRecord() {
        }
    }
}

