/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.web.transaction;

import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import ee.jakarta.tck.data.framework.junit.anno.Persistence;
import ee.jakarta.tck.data.framework.junit.anno.Web;
import ee.jakarta.tck.data.standalone.persistence.Catalog;
import ee.jakarta.tck.data.standalone.persistence.Product;
import jakarta.inject.Inject;
import jakarta.transaction.UserTransaction;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;

@Web
@Persistence
public class PersistenceTests {
    @Inject
    UserTransaction tran;
    @Inject
    Catalog catalog;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{Catalog.class, Product.class});
    }

    @Assertion(id="133", strategy="Verify that data is persisted to repository when a transaction is committed")
    public void testCommit() throws Exception {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        this.tran.begin();
        this.catalog.save(Product.of("wool-yarn", 7.99, "TEST-PROD-100", Product.Department.CRAFTS));
        this.catalog.save(Product.of("cotton-yarn", 5.99, "TEST-PROD-101", Product.Department.CRAFTS));
        this.catalog.save(Product.of("acylic-yarn", 3.99, "TEST-PROD-102", Product.Department.CRAFTS));
        this.tran.commit();
        List<Product> yarns = this.catalog.findByProductNumLike("TEST-PROD-10_");
        Assertions.assertFalse((boolean)yarns.isEmpty(), (String)"Commit should have persisted data");
        Assertions.assertEquals((int)3, (int)yarns.size());
        Product woolYarn = yarns.stream().filter(p -> p.getProductNum().equals("TEST-PROD-100")).findFirst().orElse(null);
        Assertions.assertNotNull((Object)woolYarn, (String)"Result set did not contain the expected product");
        Assertions.assertEquals((Object)"wool-yarn", (Object)woolYarn.getName());
        Assertions.assertEquals((double)7.99, (Double)woolYarn.getPrice());
        Assertions.assertTrue((boolean)woolYarn.getDepartments().contains((Object)Product.Department.CRAFTS), (String)"Result was did not have the correct department.");
    }

    @Assertion(id="133", strategy="Verify that data is not persisted to repository when a transaction is rolled back")
    public void testRollback() throws Exception {
        this.catalog.deleteByProductNumLike("TEST-PROD-%");
        this.tran.begin();
        this.catalog.save(Product.of("oil-paint", 12.55, "TEST-PROD-110", Product.Department.CRAFTS));
        this.catalog.save(Product.of("acrylic-paint", 6.55, "TEST-PROD-111", Product.Department.CRAFTS));
        this.catalog.save(Product.of("watercolor", 5.55, "TEST-PROD-112", Product.Department.CRAFTS));
        this.tran.rollback();
        List<Product> paints = this.catalog.findByProductNumLike("TEST-PROD-11_");
        Assertions.assertTrue((boolean)paints.isEmpty(), (String)"Save should not have persisted data after transaction rollback.");
    }
}

