/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.signature;

import ee.jakarta.tck.data.framework.signature.PackageList;
import ee.jakarta.tck.data.framework.signature.SignatureTestDriver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Logger;

public class SigTestDriver
extends SignatureTestDriver {
    private static final Logger log = Logger.getLogger(SigTestDriver.class.getCanonicalName());
    private static final String CLASSPATH_FLAG = "-Classpath";
    private static final String FILENAME_FLAG = "-FileName";
    private static final String PACKAGE_FLAG = "-Package";
    private static final String PACKAGE_NO_SUBS_FLAG = "-PackageWithoutSubpackages";
    private static final String API_VERSION_FLAG = "-ApiVersion";
    private static final String EXCLUDE_FLAG = "-Exclude";
    private static final String STATIC_FLAG = "-Static";
    private static final String CHECKVALUE_FLAG = "-CheckValue";
    private static final String SMODE_FLAG = "-mode";
    private static final String EXCLUDE_JDK_CLASS_FLAG = "-IgnoreJDKClass";

    @Override
    protected String normalizeFileName(File f) {
        String sURL = null;
        try {
            sURL = f.toURI().toURL().toExternalForm();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sURL;
    }

    @Override
    protected String[] createTestArguments(String packageListFile, String mapFile, String signatureRepositoryDir, String packageOrClassUnderTest, String classpath, boolean bStaticMode) throws Exception {
        SignatureTestDriver.SignatureFileInfo info = this.getSigFileInfo(packageOrClassUnderTest, mapFile, signatureRepositoryDir);
        PackageList packageList = new PackageList(packageListFile);
        String[] subPackages = packageList.getSubPackages(packageOrClassUnderTest);
        ArrayList<String> command = new ArrayList<String>();
        if (bStaticMode) {
            log.info("Setting static mode flag to allow constant checking.");
            command.add(STATIC_FLAG);
            command.add(CHECKVALUE_FLAG);
            command.add(SMODE_FLAG);
            command.add("src");
            command.add("-BootCp");
        } else {
            log.info("Not Setting static mode flag to allow constant checking.");
        }
        command.add("-Verbose");
        command.add(FILENAME_FLAG);
        command.add(info.getFile());
        command.add(CLASSPATH_FLAG);
        command.add(classpath);
        command.add(PACKAGE_FLAG);
        command.add(packageOrClassUnderTest);
        for (int i = 0; i < subPackages.length; ++i) {
            command.add(EXCLUDE_FLAG);
            command.add(subPackages[i]);
        }
        command.add(EXCLUDE_JDK_CLASS_FLAG);
        command.add(API_VERSION_FLAG);
        command.add(info.getVersion());
        return command.toArray(new String[command.size()]);
    }

    @Override
    protected boolean runSignatureTest(String packageOrClassName, String[] testArguments) throws Exception {
        Class<?> sigTestClass = Class.forName("com.sun.tdk.signaturetest.SignatureTest");
        Object sigTestInstance = sigTestClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        log.fine("\nCalling:  com.sun.tdk.signaturetest.SignatureTest() with following args:");
        for (int ii = 0; ii < testArguments.length; ++ii) {
            log.fine("   testArguments[" + ii + "] = " + testArguments[ii]);
        }
        Method runMethod = sigTestClass.getDeclaredMethod("run", String[].class, PrintWriter.class, PrintWriter.class);
        runMethod.invoke(sigTestInstance, testArguments, new PrintWriter(output, true), null);
        String rawMessages = output.toString();
        log.info("********** Status Report '" + packageOrClassName + "' **********\n");
        log.info(rawMessages);
        return sigTestInstance.toString().substring(7).startsWith("Passed.");
    }

    @Override
    protected boolean runPackageSearch(String packageOrClassName, String[] testArguments) throws Exception {
        int ii;
        Class<?> sigTestClass = Class.forName("com.sun.tdk.signaturetest.SignatureTest");
        Object sigTestInstance = sigTestClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (ii = 0; ii < testArguments.length; ++ii) {
            if (!testArguments[ii].equals(PACKAGE_FLAG)) continue;
            testArguments[ii] = PACKAGE_NO_SUBS_FLAG;
        }
        log.fine("\nCalling:  com.sun.tdk.signaturetest.SignatureTest() with following args:");
        for (ii = 0; ii < testArguments.length; ++ii) {
            log.fine("\t  testArguments[" + ii + "] = " + testArguments[ii]);
        }
        Method runMethod = sigTestClass.getDeclaredMethod("run", String[].class, PrintWriter.class, PrintWriter.class);
        runMethod.invoke(sigTestInstance, testArguments, new PrintWriter(output, true), null);
        String rawMessages = output.toString();
        log.info("********** Status Report '" + packageOrClassName + "' **********\n");
        log.info(rawMessages);
        return sigTestInstance.toString().substring(7).startsWith("Passed.");
    }
}

