/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.containerelementlevel;

import jakarta.validation.Configuration;
import jakarta.validation.Validator;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.executable.ExecutableValidator;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ContainerElementTypeIgnoreAnnotationsMappingTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ContainerElementTypeIgnoreAnnotationsMappingTest.webArchiveBuilder().withTestClass(ContainerElementTypeIgnoreAnnotationsMappingTest.class)).withResource("field-ignoreAnnotationsTrue-mapping.xml")).withResource("field-ignoreAnnotationsFalse-mapping.xml")).withResource("getter-ignoreAnnotationsTrue-mapping.xml")).withResource("getter-ignoreAnnotationsFalse-mapping.xml")).withResource("returnvalue-ignoreAnnotationsTrue-mapping.xml")).withResource("returnvalue-ignoreAnnotationsFalse-mapping.xml")).withResource("parameter-ignoreAnnotationsTrue-mapping.xml")).withResource("parameter-ignoreAnnotationsFalse-mapping.xml")).build();
    }

    @Test
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="e")
    public void ignoreAnnotationsOnEncapsulatingFieldAppliesToContainerElementType() {
        Validator validator = this.getValidator("field-ignoreAnnotationsTrue-mapping.xml");
        Set violations = validator.validate((Object)OrderField.invalid(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(DecimalMin.class));
        validator = this.getValidator("field-ignoreAnnotationsFalse-mapping.xml");
        violations = validator.validate((Object)OrderField.invalid(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class), ConstraintViolationAssert.violationOf(DecimalMin.class));
    }

    @Test
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="e")
    public void ignoreAnnotationsOnEncapsulatingGetterAppliesToContainerElementType() {
        Validator validator = this.getValidator("getter-ignoreAnnotationsTrue-mapping.xml");
        Set violations = validator.validate((Object)OrderGetter.invalid(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(DecimalMin.class));
        validator = this.getValidator("getter-ignoreAnnotationsFalse-mapping.xml");
        violations = validator.validate((Object)OrderGetter.invalid(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class), ConstraintViolationAssert.violationOf(DecimalMin.class));
    }

    @Test
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="e")
    public void ignoreAnnotationsOnEncapsulatingMethodReturnValueAppliesToContainerElementType() throws NoSuchMethodException, SecurityException {
        ExecutableValidator validator = this.getValidator("returnvalue-ignoreAnnotationsTrue-mapping.xml").forExecutables();
        OrderReturnValue invalidObject = OrderReturnValue.invalid();
        Set violations = validator.validateReturnValue((Object)invalidObject, OrderReturnValue.class.getMethod("retrieveLines", new Class[0]), invalidObject.lines, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(DecimalMin.class));
        validator = this.getValidator("returnvalue-ignoreAnnotationsFalse-mapping.xml").forExecutables();
        violations = validator.validateReturnValue((Object)invalidObject, OrderReturnValue.class.getMethod("retrieveLines", new Class[0]), invalidObject.lines, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class), ConstraintViolationAssert.violationOf(DecimalMin.class));
    }

    @Test
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="e")
    public void ignoreAnnotationsOnEncapsulatingMethodParameterAppliesToContainerElementType() throws NoSuchMethodException, SecurityException {
        ExecutableValidator validator = this.getValidator("parameter-ignoreAnnotationsTrue-mapping.xml").forExecutables();
        OrderParameter invalidObject = OrderParameter.invalid();
        HashMap<String, BigDecimal> additionalLines = new HashMap<String, BigDecimal>();
        additionalLines.put("", BigDecimal.ZERO);
        Set violations = validator.validateParameters((Object)invalidObject, OrderParameter.class.getMethod("addLines", Map.class), new Object[]{additionalLines}, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(DecimalMin.class));
        validator = this.getValidator("parameter-ignoreAnnotationsFalse-mapping.xml").forExecutables();
        violations = validator.validateParameters((Object)invalidObject, OrderParameter.class.getMethod("addLines", Map.class), new Object[]{additionalLines}, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class), ConstraintViolationAssert.violationOf(DecimalMin.class));
    }

    private Validator getValidator(String mappingFile) {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(((Object)((Object)this)).getClass().getResourceAsStream(mappingFile));
        return config.buildValidatorFactory().getValidator();
    }

    private static class OrderField {
        private final Map<@NotBlank String, BigDecimal> lines = new HashMap<String, BigDecimal>();

        private OrderField() {
        }

        private static OrderField invalid() {
            OrderField order = new OrderField();
            order.lines.put("", BigDecimal.ZERO);
            return order;
        }
    }

    private static class OrderGetter {
        private final Map<String, BigDecimal> lines = new HashMap<String, BigDecimal>();

        private OrderGetter() {
        }

        private static OrderGetter invalid() {
            OrderGetter order = new OrderGetter();
            order.lines.put("", BigDecimal.ZERO);
            return order;
        }

        public Map<@NotBlank String, BigDecimal> getLines() {
            return this.lines;
        }
    }

    public static class OrderReturnValue {
        private final Map<String, BigDecimal> lines = new HashMap<String, BigDecimal>();

        private static OrderReturnValue invalid() {
            OrderReturnValue order = new OrderReturnValue();
            order.lines.put("", BigDecimal.ZERO);
            return order;
        }

        public Map<@NotBlank String, BigDecimal> retrieveLines() {
            return this.lines;
        }
    }

    public static class OrderParameter {
        private final Map<String, BigDecimal> lines = new HashMap<String, BigDecimal>();

        private static OrderParameter invalid() {
            OrderParameter order = new OrderParameter();
            order.lines.put("", BigDecimal.ZERO);
            return order;
        }

        public void addLines(Map<@NotBlank String, BigDecimal> lines) {
            this.lines.putAll(lines);
        }
    }
}

