/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.runtime.BatchStatus;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JobExecutableSequenceTests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp = null;

    @Test
    public void testJobExecutableSequenceToUnknown() throws Exception {
        String METHOD = "testJobExecutableSequenceToUnknown";
        try {
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = null;
            boolean seenException = false;
            try {
                jobExec = jobOp.startJobAndWaitForResult("job_executable_sequence_invalid", null);
            }
            catch (JobStartException e) {
                Reporter.log((String)("Caught JobStartException:  " + e.getLocalizedMessage()));
                seenException = true;
            }
            if (!seenException) {
                Reporter.log((String)("Didn't catch JobStartException, Job Batch Status = " + String.valueOf(jobExec.getBatchStatus())));
                AssertionUtils.assertWithMessage("Job should have failed because of out of scope execution elements.", BatchStatus.FAILED, jobExec.getBatchStatus());
            }
            Reporter.log((String)"job failed");
        }
        catch (Exception e) {
            JobExecutableSequenceTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    @BeforeAll
    public static void beforeTest() throws ClassNotFoundException {
        jobOp = new JobOperatorBridge();
    }

    @AfterAll
    public static void afterTest() {
        jobOp = null;
    }
}

