/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.Properties;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class CDITests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp = null;

    @ParameterizedTest
    @ValueSource(strings={"CDIDependentScopedBatchlet", "dependentScopedBatchlet", "com.ibm.jbatch.tck.artifacts.cdi.DependentScopedBatchlet"})
    public void testCDIInject(String refName) throws Exception {
        String METHOD = "testCDIInject";
        try {
            String parm1Val = "It's a parm";
            Properties jobParams = new Properties();
            jobParams.setProperty("refName", refName);
            jobParams.setProperty("parm1", parm1Val);
            Reporter.log((String)("starting job with refName = " + refName));
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("cdi_inject_beans", jobParams);
            Reporter.log((String)("Job Status = " + String.valueOf(jobExec.getBatchStatus())));
            Assertions.assertEquals((Object)BatchStatus.COMPLETED, (Object)jobExec.getBatchStatus(), (String)"Job didn't complete successfully");
            String exitStatus = jobExec.getExitStatus();
            Reporter.log((String)("job completed with exit status: " + exitStatus));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            Assertions.assertEquals((int)1, (int)steps.size(), (String)"Wrong number of step executions found");
            String expectedExitStatus = jobExec.getExecutionId() + ":" + steps.get(0).getStepExecutionId() + ":" + parm1Val;
            Assertions.assertEquals((Object)expectedExitStatus, (Object)jobExec.getExitStatus(), (String)"Test fails - unexpected exit status");
            Reporter.log((String)"GOOD result");
        }
        catch (Exception e) {
            CDITests.handleException(METHOD, e);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"CDIDependentScopedBatchletContexts", "dependentScopedBatchletContexts", "com.ibm.jbatch.tck.artifacts.cdi.DependentScopedBatchletContexts"})
    public void testCDIInjectContexts(String refName) throws Exception {
        String METHOD = "testCDIInjectContexts";
        try {
            Properties jobParams = new Properties();
            jobParams.setProperty("refName", refName);
            Reporter.log((String)("starting job with refName = " + refName));
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("cdi_inject_beans", jobParams);
            Reporter.log((String)("Job Status = " + String.valueOf(jobExec.getBatchStatus())));
            Assertions.assertEquals((Object)BatchStatus.COMPLETED, (Object)jobExec.getBatchStatus(), (String)"Job didn't complete successfully");
            String exitStatus = jobExec.getExitStatus();
            Reporter.log((String)("job completed with exit status: " + exitStatus));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            Assertions.assertEquals((int)1, (int)steps.size(), (String)"Wrong number of step executions found");
            Reporter.log((String)("step completed with exit status: " + steps.get(0).getExitStatus()));
            long stepExecId = steps.get(0).getStepExecutionId();
            String expectedJobExitStatus = jobExec.getExecutionId() + ":" + jobExec.getExecutionId() + ":" + jobExec.getExecutionId() + ":";
            Assertions.assertEquals((Object)expectedJobExitStatus, (Object)jobExec.getExitStatus(), (String)"Test fails - unexpected job exit status");
            String expectedStepExitStatus = stepExecId + ":" + stepExecId + ":" + stepExecId + ":";
            Assertions.assertEquals((Object)expectedStepExitStatus, (Object)steps.get(0).getExitStatus(), (String)"Test fails - unexpected step exit status");
            Reporter.log((String)"GOOD result");
        }
        catch (Exception e) {
            CDITests.handleException(METHOD, e);
        }
    }

    @Test
    public void testCDIInjectListenerIntoBatchlet() throws Exception {
        String METHOD = "testCDIInjectListenerIntoBatchlet";
        try {
            Properties jobParams = new Properties();
            jobParams.setProperty("listenerName", "CDIApplicationScopedStepListener");
            jobParams.setProperty("batchletName", "CDIDependentScopedBatchletInjectListener");
            Reporter.log((String)"starting job for testCDIInjectListenerIntoBatchlet");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("cdi_inject_listener_into_batchlet", jobParams);
            Reporter.log((String)("Job Status = " + String.valueOf(jobExec.getBatchStatus())));
            Assertions.assertEquals((Object)BatchStatus.COMPLETED, (Object)jobExec.getBatchStatus(), (String)"Job didn't complete successfully");
            String exitStatus = jobExec.getExitStatus();
            Reporter.log((String)("job completed with exit status: " + exitStatus));
            String expectedJobExitStatus = "2:4:5:";
            Assertions.assertEquals((Object)expectedJobExitStatus, (Object)jobExec.getExitStatus(), (String)"Test fails - unexpected job exit status");
            Reporter.log((String)"GOOD result");
        }
        catch (Exception e) {
            CDITests.handleException(METHOD, e);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"CDIDependentScopedBatchletProps", "dependentScopedBatchletProps", "com.ibm.jbatch.tck.artifacts.cdi.DependentScopedBatchletProps"})
    public void testCDIBatchProps(String refName) throws Exception {
        String METHOD = "testCDIBatchProps";
        try {
            Properties jobParams = new Properties();
            String ctor1 = "CTOR";
            String ctor2 = "CAT";
            String field1 = "ABC";
            String field2 = "APPLE";
            String method1 = "XYZ";
            String method2 = "X-WING";
            jobParams.setProperty("refName", refName);
            jobParams.setProperty("c1", ctor1);
            jobParams.setProperty("c2", ctor2);
            jobParams.setProperty("f1", field1);
            jobParams.setProperty("f2", field2);
            jobParams.setProperty("m1", method1);
            jobParams.setProperty("m2", method2);
            Reporter.log((String)("starting job with refName = " + refName));
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("cdi_batch_props", jobParams);
            Reporter.log((String)("Job Status = " + String.valueOf(jobExec.getBatchStatus())));
            Assertions.assertEquals((Object)BatchStatus.COMPLETED, (Object)jobExec.getBatchStatus(), (String)"Job didn't complete successfully");
            Reporter.log((String)("job completed with exit status = " + jobExec.getExitStatus()));
            String expectedExitStatus = String.join((CharSequence)":", ctor1, ctor2, field1, field2, method1, method2);
            Assertions.assertEquals((Object)expectedExitStatus, (Object)jobExec.getExitStatus(), (String)"Test fails - unexpected exit status");
            Reporter.log((String)"GOOD result");
        }
        catch (Exception e) {
            CDITests.handleException(METHOD, e);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"CDIDependentScopedBatchletRepeatProps", "dependentScopedBatchletRepeatProps", "com.ibm.jbatch.tck.artifacts.cdi.DependentScopedBatchletRepeatProps"})
    public void testCDIInjectRepeatProps(String refName) throws Exception {
        String METHOD = "testCDIInjectRepeatProps";
        try {
            String p1 = "myParm1";
            String p2 = "myParm2";
            Properties jobParams = new Properties();
            jobParams.setProperty("refName", refName);
            jobParams.setProperty("parm1", p1);
            jobParams.setProperty("parm2", p2);
            Reporter.log((String)("starting job with refName = " + refName));
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("cdi_inject_beans", jobParams);
            Reporter.log((String)("Job Status = " + String.valueOf(jobExec.getBatchStatus())));
            Assertions.assertEquals((Object)BatchStatus.COMPLETED, (Object)jobExec.getBatchStatus(), (String)"Job didn't complete successfully");
            String exitStatus = jobExec.getExitStatus();
            Reporter.log((String)("job completed with exit status: " + exitStatus));
            String expectedExitStatus = String.join((CharSequence)":", p1, p2, p1, p1, p2, p1, p1, p2, p1, p1, p1, p1);
            Assertions.assertEquals((Object)expectedExitStatus, (Object)jobExec.getExitStatus(), (String)"Test fails - unexpected exit status");
            Reporter.log((String)"GOOD result");
        }
        catch (Exception e) {
            CDITests.handleException(METHOD, e);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"CDIApplicationScopedBatchlet", "applicationScopedBatchlet", "com.ibm.jbatch.tck.artifacts.cdi.ApplicationScopedBatchlet"})
    public void testCDILazyInject(String refName) throws Exception {
        String METHOD = "testCDILazyInject";
        try {
            String parm1Val = "It's a parm";
            String parm2Val = "Or a prop";
            Properties jobParams = new Properties();
            jobParams.setProperty("refName", refName);
            jobParams.setProperty("parm1", parm1Val);
            jobParams.setProperty("parm2", parm2Val);
            Reporter.log((String)("starting job with refName = " + refName));
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("cdi_inject_beans_2step", jobParams);
            Reporter.log((String)("Job Status = " + String.valueOf(jobExec.getBatchStatus())));
            Assertions.assertEquals((Object)BatchStatus.COMPLETED, (Object)jobExec.getBatchStatus(), (String)"Job didn't complete successfully");
            String exitStatus = jobExec.getExitStatus();
            Reporter.log((String)("job completed with exit status: " + exitStatus));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            Assertions.assertEquals((int)2, (int)steps.size(), (String)"Wrong number of step executions found");
            String expectedExitStatus = jobExec.getExecutionId() + ":step1:" + parm1Val + ":" + parm2Val + "," + jobExec.getExecutionId() + ":step2:s2" + parm1Val + ":s2" + parm2Val;
            Assertions.assertEquals((Object)expectedExitStatus, (Object)jobExec.getExitStatus(), (String)"Test fails - unexpected exit status");
            Reporter.log((String)"GOOD result");
        }
        catch (Exception e) {
            CDITests.handleException(METHOD, e);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"com.ibm.jbatch.tck.artifacts.cdi.NonCDIBeanBatchlet"})
    @Disabled(value="https://github.com/jakartaee/batch-tck/issues/71")
    public void testCDILookup(String refName) throws Exception {
        String METHOD = "testCDILookup";
        try {
            String parm1Val = "It's a parm";
            String parm2Val = "Or a prop";
            Properties jobParams = new Properties();
            jobParams.setProperty("refName", refName);
            jobParams.setProperty("parm1", parm1Val);
            jobParams.setProperty("parm2", parm2Val);
            Reporter.log((String)("starting job with refName = " + refName));
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("cdi_inject_beans_2step", jobParams);
            Reporter.log((String)("Job Status = " + String.valueOf(jobExec.getBatchStatus())));
            Assertions.assertEquals((Object)BatchStatus.COMPLETED, (Object)jobExec.getBatchStatus(), (String)"Job didn't complete successfully");
            String exitStatus = jobExec.getExitStatus();
            Reporter.log((String)("job completed with exit status: " + exitStatus));
            List<StepExecution> steps = jobOp.getStepExecutions(jobExec.getExecutionId());
            Assertions.assertEquals((int)2, (int)steps.size(), (String)"Wrong number of step executions found");
            String expectedExitStatus = jobExec.getExecutionId() + ":step1:" + parm1Val + ":" + parm2Val + "," + jobExec.getExecutionId() + ":step2:s2" + parm1Val + ":s2" + parm2Val;
            Assertions.assertEquals((Object)expectedExitStatus, (Object)jobExec.getExitStatus(), (String)"Test fails - unexpected exit status");
            Reporter.log((String)"GOOD result");
        }
        catch (Exception e) {
            CDITests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    @BeforeAll
    public static void beforeTest() throws ClassNotFoundException {
        jobOp = new JobOperatorBridge();
    }

    @AfterAll
    public static void afterTest() {
        jobOp = null;
    }
}

