/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.chunktypes.ArrayIndexCheckpointData;
import com.ibm.jbatch.tck.artifacts.chunktypes.ReadRecord;
import com.ibm.jbatch.tck.artifacts.reusable.MyPersistentRestartUserData;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.AbstractItemReader;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.logging.Logger;

@Named(value="doSomethingArrayItemReaderImpl")
public class DoSomethingArrayItemReaderImpl
extends AbstractItemReader {
    private static final Logger logger = Logger.getLogger(DoSomethingArrayItemReaderImpl.class.getName());
    private int count = 0;
    private int[] readerDataArray;
    private int idx;
    ArrayIndexCheckpointData _cpd = new ArrayIndexCheckpointData();
    @Inject
    @BatchProperty(name="readrecord.fail")
    String readrecordfailNumberString;
    @Inject
    @BatchProperty(name="execution.number")
    String executionNumberString;
    @Inject
    @BatchProperty(name="app.arraysize")
    String appArraySizeString;
    @Inject
    @BatchProperty(name="app.checkpoint.position")
    String appCheckpointPositionString;
    @Inject
    private StepContext stepCtx = null;
    int failnum;
    int execnum;
    int arraysize;
    int checkpointPosition;

    public void open(Serializable cpd) throws Exception {
        ArrayIndexCheckpointData checkpointData = (ArrayIndexCheckpointData)cpd;
        this.failnum = Integer.parseInt(this.readrecordfailNumberString);
        if (this.executionNumberString != null) {
            this.execnum = Integer.parseInt(this.executionNumberString);
        }
        this.arraysize = Integer.parseInt(this.appArraySizeString);
        this.readerDataArray = new int[this.arraysize];
        if (this.appCheckpointPositionString != null) {
            this.checkpointPosition = Integer.parseInt(this.appCheckpointPositionString);
        }
        for (int i = 0; i < this.arraysize; ++i) {
            this.readerDataArray[i] = i;
        }
        this.idx = cpd == null ? 0 : checkpointData.getCurrentIndex() + 1;
        logger.fine("READ: starting at index: " + this.idx);
        if (this.appCheckpointPositionString != null) {
            if (this.idx != this.checkpointPosition) {
                throw new Exception("checkpointPosition incorect, test will now fail");
            }
            logger.fine("AJM: checkpoint position as expected");
        }
    }

    public ReadRecord readItem() throws Exception {
        int i = this.idx;
        this.execnum = ((MyPersistentRestartUserData)this.stepCtx.getPersistentUserData()).getExecutionNumber();
        logger.fine("AJM: iteration number = " + this.execnum);
        if (i == this.arraysize) {
            return null;
        }
        if (this.execnum == 2) {
            this.failnum = -1;
        }
        if (this.idx == this.failnum - 1) {
            logger.fine("READ: got the fail num..." + this.failnum);
            throw new Exception("fail on purpose on idx = " + this.failnum);
        }
        ++this.count;
        ++this.idx;
        this._cpd.setCurrentIndex(i);
        return new ReadRecord(this.readerDataArray[i]);
    }

    public ArrayIndexCheckpointData checkpointInfo() {
        logger.fine("READ: in getCPD cpd index from store: " + this._cpd.getCurrentIndex());
        logger.fine("READ: in getCPD idx : " + this.idx);
        return this._cpd;
    }

    private class MyTransient {
        int data = 0;

        MyTransient(int x) {
            this.data = x;
        }
    }
}

