/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.common.StatusConstants;
import jakarta.batch.api.Decider;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.StepExecution;
import jakarta.inject.Named;

@Named
public class FlowTransitionToDecisionTestDecider
implements Decider,
StatusConstants {
    public static final String DECIDER_EXIT_STATUS = "DECIDER_EXIT_STATUS";

    public String decide(StepExecution[] stepExecutions) throws Exception {
        if (stepExecutions.length != 1) {
            throw new IllegalStateException("Expecting stepExecutions array of size 1, found one of size = " + stepExecutions.length);
        }
        StepExecution stepExecution = stepExecutions[0];
        for (StepExecution stepExec : stepExecutions) {
            if (stepExec == null) {
                throw new Exception("Null StepExecution after flow.");
            }
            if (stepExec.getBatchStatus().equals((Object)BatchStatus.COMPLETED)) continue;
            throw new Exception("All step executions must be compelete before transitioning to a decider.");
        }
        return "DECIDER_EXIT_STATUS*" + stepExecution.getExitStatus();
    }
}

