/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.listener.ChunkListener;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;

@Named
public class ArtifactInstanceTestChunkListener
implements ChunkListener {
    @Inject
    JobContext jobCtx;
    @Inject
    StepContext stepCtx;
    @Inject
    @BatchProperty(name="chunk.property")
    String chunkPropertyString;
    static String prop1 = "chunkListenerA";
    static String prop2 = "chunkListenerB";
    int instance1Count = 0;
    int instance2Count = 0;
    boolean uniqueInstance1 = false;
    boolean uniqueInstance2 = false;
    private boolean saw2Listeners = false;

    public void beforeChunk() throws Exception {
        Map instanceData = (Map)this.stepCtx.getTransientUserData();
        if (this.chunkPropertyString.equals(prop1)) {
            instanceData.put("sawChunkProp1", true);
            ++this.instance1Count;
        } else if (this.chunkPropertyString.equals(prop2)) {
            instanceData.put("sawChunkProp2", true);
            ++this.instance2Count;
        }
    }

    public void afterChunk() throws Exception {
        String currentStatus;
        Map instanceData = (Map)this.stepCtx.getTransientUserData();
        if (((Boolean)instanceData.get("sawChunkProp1")).booleanValue() && ((Boolean)instanceData.get("sawChunkProp2")).booleanValue()) {
            this.saw2Listeners = true;
        }
        if (this.chunkPropertyString.equals(prop1) && this.instance1Count == 1) {
            this.uniqueInstance1 = true;
        }
        if (this.chunkPropertyString.equals(prop2) && this.instance2Count == 1) {
            this.uniqueInstance2 = true;
        }
        if ((currentStatus = this.jobCtx.getExitStatus()) != null && currentStatus.equals("BAD")) {
            return;
        }
        if (this.saw2Listeners && this.uniqueInstance1 ^ this.uniqueInstance2) {
            this.jobCtx.setExitStatus(this.jobCtx.getExitStatus() + "ChunkListener");
        } else {
            this.jobCtx.setExitStatus("CHUNK_BAD");
        }
    }

    public void onError(Exception e) throws Exception {
    }
}

