/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.runtime.BatchStatus;
import java.util.Properties;
import org.junit.Before;
import org.testng.Reporter;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class JobExecutableSequenceTests {
    private JobOperatorBridge jobOp = null;

    @Test
    @org.junit.Test
    public void testJobExecutableSequenceToUnknown() throws Exception {
        String METHOD = "testJobExecutableSequenceToUnknown";
        try {
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = null;
            boolean seenException = false;
            try {
                jobExec = this.jobOp.startJobAndWaitForResult("job_executable_sequence_invalid", null);
            }
            catch (JobStartException e) {
                Reporter.log((String)("Caught JobStartException:  " + e.getLocalizedMessage()));
                seenException = true;
            }
            if (!seenException) {
                Reporter.log((String)("Didn't catch JobStartException, Job Batch Status = " + jobExec.getBatchStatus()));
                AssertionUtils.assertWithMessage("Job should have failed because of out of scope execution elements.", BatchStatus.FAILED, jobExec.getBatchStatus());
            }
            Reporter.log((String)"job failed");
        }
        catch (Exception e) {
            JobExecutableSequenceTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    public void setup(String[] args, Properties props) throws Exception {
        String METHOD = "setup";
        try {
            this.jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            JobExecutableSequenceTests.handleException(METHOD, e);
        }
    }

    public void cleanup() {
    }

    @BeforeTest
    @Before
    public void beforeTest() throws ClassNotFoundException {
        this.jobOp = new JobOperatorBridge();
    }

    @AfterTest
    public void afterTest() {
        this.jobOp = null;
    }
}

