/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.runtime.BatchStatus;
import java.util.Properties;
import org.junit.Before;
import org.testng.Reporter;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class FlowTransitioningTests {
    private JobOperatorBridge jobOp = null;

    @Test
    @org.junit.Test
    public void testFlowTransitionToStep() throws Exception {
        String METHOD = "testFlowTransitionToStep";
        try {
            String[] transitionList = new String[]{"flow1step1", "flow1step2", "flow1step3", "step1"};
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("flow_transition_to_step", null);
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            String[] jobTransitionList = jobExec.getExitStatus().split(",");
            AssertionUtils.assertWithMessage("transitioned to exact number of steps", transitionList.length, jobTransitionList.length);
            for (int i = 0; i < jobTransitionList.length; ++i) {
                AssertionUtils.assertWithMessage("Flow transitions", transitionList[i], jobTransitionList[i].trim());
            }
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            Reporter.log((String)"Job completed");
        }
        catch (Exception e) {
            FlowTransitioningTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testFlowTransitionToStepOutOfScope() throws Exception {
        String METHOD = " testFlowTransitionToStepOutOfScope";
        try {
            boolean seenException = false;
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = null;
            try {
                jobExec = this.jobOp.startJobAndWaitForResult("flow_transition_to_step_out_of_scope", null);
            }
            catch (JobStartException e) {
                Reporter.log((String)("Caught JobStartException:  " + e.getLocalizedMessage()));
                seenException = true;
            }
            if (!seenException) {
                Reporter.log((String)("Didn't catch JobStartException, Job Batch Status = " + jobExec.getBatchStatus()));
                AssertionUtils.assertWithMessage("Job should have failed because of out of scope execution elements.", BatchStatus.FAILED, jobExec.getBatchStatus());
            }
        }
        catch (Exception e) {
            FlowTransitioningTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testFlowTransitionToDecision() throws Exception {
        String METHOD = "testFlowTransitionToDecision";
        try {
            String exitStatus = "ThatsAllFolks";
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("flow_transition_to_decision", null);
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job Exit Status is from decider", exitStatus, jobExec.getExitStatus());
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            Reporter.log((String)"Job completed");
        }
        catch (Exception e) {
            FlowTransitioningTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testFlowTransitionWithinFlow() throws Exception {
        String METHOD = "testFlowTransitionWithinFlow";
        try {
            String[] transitionList = new String[]{"flow1step1", "flow1step2", "flow1step3"};
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("flow_transition_within_flow", null);
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            String[] jobTransitionList = jobExec.getExitStatus().split(",");
            AssertionUtils.assertWithMessage("transitioned to exact number of steps", transitionList.length, jobTransitionList.length);
            for (int i = 0; i < jobTransitionList.length; ++i) {
                AssertionUtils.assertWithMessage("Flow transitions", transitionList[i], jobTransitionList[i].trim());
            }
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            Reporter.log((String)"Job completed");
        }
        catch (Exception e) {
            FlowTransitioningTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    public void setup(String[] args, Properties props) throws Exception {
        String METHOD = "setup";
        try {
            this.jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            FlowTransitioningTests.handleException(METHOD, e);
        }
    }

    public void cleanup() {
    }

    @BeforeTest
    @Before
    public void beforeTest() throws ClassNotFoundException {
        this.jobOp = new JobOperatorBridge();
    }

    @AfterTest
    public void afterTest() {
        this.jobOp = null;
    }
}

