/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;
import org.junit.BeforeClass;
import org.testng.Reporter;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BatchletRestartStateMachineTests {
    private static JobOperatorBridge jobOp = null;

    public static void setup(String[] args, Properties props) throws Exception {
        String METHOD = "setup";
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            BatchletRestartStateMachineTests.handleException(METHOD, e);
        }
    }

    @BeforeMethod
    @BeforeClass
    public static void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    public void cleanup() {
    }

    @Test
    @org.junit.Test
    public void testTransitionElementOnAttrValuesWithRestartJobParamOverrides() throws Exception {
        String METHOD = "testTransitionElementOnAttrValuesWithRestartJobParamOverrides";
        String EXECUTION2_EXPECTED_EXIT_STATUS_FROM_JSL_ATTRIBUTE = "EXPECTED_FAILURE";
        try {
            TCKJobExecutionWrapper execution1 = null;
            TCKJobExecutionWrapper execution2 = null;
            TCKJobExecutionWrapper execution3 = null;
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            jobParams.setProperty("execution.number", "1");
            jobParams.setProperty("step1.stop", "ES.STEP1");
            jobParams.setProperty("step1.next", "ES.XXX");
            jobParams.setProperty("step2.fail", "ES.STEP2");
            jobParams.setProperty("step2.next", "ES.XXX");
            Reporter.log((String)"Invoke startJobAndWaitForResult");
            execution1 = jobOp.startJobAndWaitForResult("overrideOnAttributeValuesUponRestartBatchlet", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.STOPPED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "STOPPED", execution1.getExitStatus());
            Reporter.log((String)"Create job parameters for execution #2:<p>");
            Properties restartJobParameters = new Properties();
            Reporter.log((String)"execution.number=2<p>");
            Reporter.log((String)"step1.stop=ES.STOP<p>");
            Reporter.log((String)"step1.next=ES.STEP1<p>");
            restartJobParameters.setProperty("execution.number", "2");
            restartJobParameters.setProperty("step1.stop", "ES.STOP");
            restartJobParameters.setProperty("step1.next", "ES.STEP1");
            restartJobParameters.setProperty("step2.fail", "ES.STEP2");
            restartJobParameters.setProperty("step2.next", "ES.STEP2");
            Reporter.log((String)("Invoke restartJobAndWaitForResult with executionId: " + execution1.getExecutionId() + "<p>"));
            execution2 = jobOp.restartJobAndWaitForResult(execution1.getExecutionId(), restartJobParameters);
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + execution2.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + execution2.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.FAILED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", EXECUTION2_EXPECTED_EXIT_STATUS_FROM_JSL_ATTRIBUTE, execution2.getExitStatus());
            Reporter.log((String)"Create job parameters for execution #3:<p>");
            restartJobParameters = new Properties();
            Reporter.log((String)"execution.number=3<p>");
            Reporter.log((String)"step1.stop=ES.STOP<p>");
            Reporter.log((String)"step1.next=ES.STEP1<p>");
            Reporter.log((String)"step2.fail=ES.FAIL<p>");
            Reporter.log((String)"step2.next=ES.STEP2<p>");
            restartJobParameters.setProperty("execution.number", "3");
            restartJobParameters.setProperty("step1.stop", "ES.STOP");
            restartJobParameters.setProperty("step1.next", "ES.STEP1");
            restartJobParameters.setProperty("step2.fail", "ES.FAIL");
            restartJobParameters.setProperty("step2.next", "ES.STEP2");
            Reporter.log((String)("Invoke restartJobAndWaitForResult with executionId: " + execution2.getExecutionId() + "<p>"));
            execution3 = jobOp.restartJobAndWaitForResult(execution2.getExecutionId(), restartJobParameters);
            Reporter.log((String)("execution #3 JobExecution getBatchStatus()=" + execution3.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #3 JobExecution getExitStatus()=" + execution3.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #3", BatchStatus.COMPLETED, execution3.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #3", "COMPLETED", execution3.getExitStatus());
        }
        catch (Exception e) {
            BatchletRestartStateMachineTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testAllowStartIfCompleteRestartExecution() throws Exception {
        String METHOD = "testAllowStartIfCompleteRestartExecution";
        try {
            long lastExecutionId = 0L;
            TCKJobExecutionWrapper exec = null;
            for (int i = 1; i <= 6; ++i) {
                String execString = new Integer(i).toString();
                Properties jobParameters = new Properties();
                jobParameters.put("execution.number", execString);
                if (i == 1) {
                    Reporter.log((String)"Invoking startJobAndWaitForResult for Execution #1<p>");
                    exec = jobOp.startJobAndWaitForResult("batchletRestartStateMachine", jobParameters);
                } else {
                    Reporter.log((String)"Invoke restartJobAndWaitForResult<p>");
                    exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParameters);
                }
                lastExecutionId = exec.getExecutionId();
                Reporter.log((String)("Execution #" + i + " JobExecution getBatchStatus()=" + exec.getBatchStatus() + "<p>"));
                Reporter.log((String)("Execution #" + i + " JobExecution getExitStatus()=" + exec.getExitStatus() + "<p>"));
                if (i == 6) {
                    AssertionUtils.assertWithMessage("Testing execution #" + i, BatchStatus.COMPLETED, exec.getBatchStatus());
                } else {
                    AssertionUtils.assertWithMessage("Testing execution #" + i, BatchStatus.STOPPED, exec.getBatchStatus());
                }
                AssertionUtils.assertWithMessage("Testing execution #" + i, "EXECUTION." + execString, exec.getExitStatus());
            }
        }
        catch (Exception e) {
            BatchletRestartStateMachineTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }
}

