/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.util;

import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CertStoreCallback;
import javax.security.auth.message.callback.PrivateKeyCallback;
import javax.security.auth.message.callback.SecretKeyCallback;
import javax.security.auth.message.callback.TrustStoreCallback;

public class CommonCallbackSupport {
    private static TSLogger logger = null;
    private static CallbackHandler callbackHandler = null;
    private static String profile = null;
    private static String runtimeType = null;

    public CommonCallbackSupport(TSLogger tsLogger, CallbackHandler cbkHandler, String profile, String runtimeType) {
        logger = tsLogger;
        callbackHandler = cbkHandler;
        CommonCallbackSupport.profile = profile;
        CommonCallbackSupport.runtimeType = runtimeType;
    }

    public boolean verify() {
        try {
            this.CertStoreCallbackSupport();
            this.PrivateKeyCallbackSupport();
            this.SecretKeyCallbackSupport();
            this.TrustStoreCallbackSupport();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void CertStoreCallbackSupport() {
        if (callbackHandler != null) {
            try {
                CertStoreCallback certStoreCallback = new CertStoreCallback();
                Callback[] callbacks = new Callback[]{certStoreCallback};
                callbackHandler.handle(callbacks);
                CertStore certStore = certStoreCallback.getCertStore();
                if (certStore != null) {
                    this.logMsg("CertStore type =" + certStore.getType());
                }
                this.logMsg("CallbackHandler supports CertStoreCallback");
            }
            catch (UnsupportedCallbackException usce) {
                this.logMsg("CallbackHandler failed to support CertStoreCallback :" + usce.getMessage());
                usce.printStackTrace();
            }
            catch (IOException ioe) {
                this.logMsg("CallbackHandler failed to support CertStoreCallback :" + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    private void PrivateKeyCallbackSupport() {
        if (callbackHandler != null) {
            try {
                PrivateKeyCallback.AliasRequest aliasRequest = new PrivateKeyCallback.AliasRequest("s1as");
                PrivateKeyCallback privateKeyCallback = new PrivateKeyCallback((PrivateKeyCallback.Request)aliasRequest);
                Callback[] callbacks = new Callback[]{privateKeyCallback};
                callbackHandler.handle(callbacks);
                PrivateKey privateKey = privateKeyCallback.getKey();
                if (privateKey != null) {
                    this.logMsg("Private Key for s1as =" + privateKey.getAlgorithm());
                }
                this.logMsg("CallbackHandler supports PrivateKeyCallback");
            }
            catch (UnsupportedCallbackException usce) {
                this.logMsg("CallbackHandler failed to support PrivateKeyCallback :" + usce.getMessage());
                usce.printStackTrace();
            }
            catch (IOException ioe) {
                this.logMsg("CallbackHandler failed to support PrivateKeyCallback :" + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    private void SecretKeyCallbackSupport() {
        if (callbackHandler != null) {
            try {
                SecretKeyCallback.AliasRequest aliasRequest = new SecretKeyCallback.AliasRequest("s1as");
                SecretKeyCallback secretKeyCallback = new SecretKeyCallback((SecretKeyCallback.Request)aliasRequest);
                Callback[] callbacks = new Callback[]{secretKeyCallback};
                callbackHandler.handle(callbacks);
                SecretKey secretKey = secretKeyCallback.getKey();
                if (secretKey != null) {
                    this.logMsg("Secret Key for s1as =" + secretKey.getAlgorithm());
                }
                this.logMsg("CallbackHandler supports SecretKeyCallback");
            }
            catch (UnsupportedCallbackException usce) {
                this.logMsg("CallbackHandler failed to support secretKeyCallback :" + usce.getMessage());
                usce.printStackTrace();
            }
            catch (IOException ioe) {
                this.logMsg("CallbackHandler failed to support secretKeyCallback :" + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    private void TrustStoreCallbackSupport() {
        if (callbackHandler != null) {
            try {
                TrustStoreCallback trustStoreCallback = new TrustStoreCallback();
                Callback[] callbacks = new Callback[]{trustStoreCallback};
                callbackHandler.handle(callbacks);
                KeyStore trustStore = trustStoreCallback.getTrustStore();
                if (trustStore != null) {
                    this.logMsg("TrustStore type =" + trustStore.getType());
                }
                this.logMsg("CallbackHandler supports TrustStoreCallback");
            }
            catch (UnsupportedCallbackException usce) {
                this.logMsg("CallbackHandler failed to support TrustStoreCallback :" + usce.getMessage());
                usce.printStackTrace();
            }
            catch (IOException ioe) {
                this.logMsg("CallbackHandler failed to support TrustStoreCallback :" + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    public void logMsg(String str) {
        if (logger != null) {
            logger.log(Level.INFO, "In " + profile + " : " + runtimeType + " " + str);
        } else {
            System.out.println("*** TSLogger Not Initialized properly ***");
            System.out.println("*** TSSVLogMessage : ***" + str);
        }
    }
}

