/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import jakarta.batch.api.AbstractBatchlet;
import jakarta.batch.api.BatchProperty;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.reflect.Field;
import java.util.logging.Logger;

@Named(value="myBatchletWithPropertiesImpl")
public class MyBatchletWithPropertiesImpl
extends AbstractBatchlet {
    private static final Logger logger = Logger.getLogger(MyBatchletWithPropertiesImpl.class.getName());
    private static int count = 1;
    public static String GOOD_EXIT_CODE = "VERY GOOD INVOCATION";
    @Inject
    @BatchProperty
    private String myProperty1;
    @Inject
    @BatchProperty
    public String myProperty2 = "This EYECATCHER should get overwritten from the job xml!!";
    @Inject
    @BatchProperty
    public String myDefaultProp1 = "Should get overwritten by default value";
    @Inject
    @BatchProperty
    public String mySubmittedProp = "This EYECATCHER should get overwritten by a submitted prop.";
    @Inject
    @BatchProperty
    public String batchletProp = "This EYECATCHER should get overwritten.";
    @Inject
    @BatchProperty
    private String javaDefaultValueProp = "JAVA DEFAULT INITIALIZER";
    @Inject
    @BatchProperty(name="myProperty4")
    private String property4;
    @Inject
    @BatchProperty
    String myConcatProp;
    @Inject
    @BatchProperty
    String myJavaSystemProp;
    @Inject
    @BatchProperty
    String defaultPropName1;
    @Inject
    @BatchProperty
    String defaultPropName2;

    public String process() throws Exception {
        String propName = System.getProperty("property.junit.propName");
        String propertyValue = this.getBatchPropertyValue(propName);
        if (propertyValue == null) {
            System.clearProperty("property.junit.result");
        } else {
            System.setProperty("property.junit.result", propertyValue);
        }
        return this.getBatchPropertyValue(propName);
    }

    public void stop() throws Exception {
        logger.fine("MyBatchletWithProperties.cancel() - @Cancel #" + count);
    }

    private String getBatchPropertyValue(String name) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        for (Field field : fields = MyBatchletWithPropertiesImpl.class.getDeclaredFields()) {
            BatchProperty batchProperty = field.getAnnotation(BatchProperty.class);
            if (batchProperty == null) continue;
            if (!batchProperty.name().equals("") && batchProperty.name().equals(name)) {
                return (String)field.get((Object)this);
            }
            if (!field.getName().equals(name)) continue;
            return (String)field.get((Object)this);
        }
        return null;
    }
}

