/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.builder;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.markup.builder.BuilderState;
import org.eclipse.mylyn.docs.intent.markup.builder.operation.DocumentLinkResolver;
import org.eclipse.mylyn.docs.intent.markup.builder.state.SDocument;
import org.eclipse.mylyn.docs.intent.markup.markup.Document;
import org.eclipse.mylyn.docs.intent.markup.markup.MarkupFactory;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelDocumentBuilder
extends DocumentBuilder {
    private BuilderState currentState;
    private Collection<EObject> roots = new ArrayList<EObject>(1);

    public Collection<EObject> getRoots() {
        return this.roots;
    }

    public void acronym(String text, String definition) {
        this.currentState = this.currentState.acronym(text, definition);
    }

    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        this.currentState = this.currentState.beginBlock(type, attributes);
    }

    public void beginDocument() {
        Document doc = MarkupFactory.eINSTANCE.createDocument();
        this.currentState = new SDocument(null, doc);
        this.roots.add((EObject)doc);
    }

    public void beginHeading(int level, Attributes attributes) {
        this.currentState = this.currentState.beginHeading(level, attributes);
    }

    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        this.currentState = this.currentState.beginSpan(type, attributes);
    }

    public void characters(String text) {
        this.currentState = this.currentState.characters(text);
    }

    public void charactersUnescaped(String literal) {
        this.currentState = this.currentState.charactersUnescaped(literal);
    }

    public void endBlock() {
        this.currentState = this.currentState.endBlock();
    }

    public void endDocument() {
        this.currentState = this.currentState.endDocument();
        for (Document doc : Iterables.filter(this.roots, Document.class)) {
            new DocumentLinkResolver(doc).resolveLinks();
        }
    }

    public void endHeading() {
        this.currentState = this.currentState.endHeading();
    }

    public void endSpan() {
        this.currentState = this.currentState.endSpan();
    }

    public void entityReference(String entity) {
        this.currentState = this.currentState.entityReference(entity);
    }

    public void image(Attributes attributes, String url) {
        this.currentState = this.currentState.image(attributes, url);
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.currentState = this.currentState.imageLink(linkAttributes, imageAttributes, href, imageUrl);
    }

    public void lineBreak() {
        this.currentState = this.currentState.lineBreak();
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.currentState = this.currentState.link(attributes, hrefOrHashName, text);
    }
}

