/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.external.parser;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.eclipse.mylyn.docs.intent.external.parser.contribution.IExternalParser;
import org.eclipse.mylyn.docs.intent.external.parser.internal.IntentExternalParserContributionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntentExternalParserContributionRegistry {
    private static final Map<IntentExternalParserContributionDescriptor, IExternalParser> DECLARED_CONTRIBUTIONS = Maps.newLinkedHashMap();

    private IntentExternalParserContributionRegistry() {
    }

    public static Collection<IExternalParser> getExternalParserContributions() {
        for (Map.Entry<IntentExternalParserContributionDescriptor, IExternalParser> descriptorToContribution : DECLARED_CONTRIBUTIONS.entrySet()) {
            if (descriptorToContribution.getValue() != null) continue;
            descriptorToContribution.setValue(descriptorToContribution.getKey().createExternalParserContribution());
        }
        return DECLARED_CONTRIBUTIONS.values();
    }

    public static void addExternalParserContribution(IntentExternalParserContributionDescriptor descriptor) {
        DECLARED_CONTRIBUTIONS.put(descriptor, null);
    }

    public static void removeExtension(String extensionClassName) {
        for (IntentExternalParserContributionDescriptor extension : DECLARED_CONTRIBUTIONS.keySet()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            DECLARED_CONTRIBUTIONS.remove(extension);
        }
    }

    public static void clearContributedExternalParserContributions() {
        DECLARED_CONTRIBUTIONS.clear();
    }
}

